/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter.helper;

import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeIDFormat;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeLong;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributePath;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeUser;
import com.arcway.cockpit.modulelib2.client.platformadapter.ChildrenIDFormatPropertyTypeDeclaration;
import com.arcway.cockpit.modulelib2.client.platformadapter.EnumerationDeclaration;
import com.arcway.cockpit.modulelib2.client.platformadapter.IPropertyDeclarations;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.DiscreteValueHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryDataTypeWithDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.AbstractFrontendDataTypeEnumeration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTBoolean;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDateUTC64Bitmsec;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDisplayName;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDuration64Bitmsec;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeString;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeText;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTInteger32Bit;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTInteger64Bit;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTPrefixIDFormat;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTUID;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.prefixidformat.PrefixIDFormat;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryDataTypeEnumeration;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTDuration64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger32Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTPrefixIDFormat;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AttributeTypeConverter {
    public static RepositoryDataTypeWithDataTypeParameters getRepositoryDataTypeForModuleDataAttribute(String attributeID, IModuleDataAttribute moduleDataAttribute, boolean mandatory, IPropertyDeclarations propertyDeclarations) {
        if (moduleDataAttribute instanceof ModuleDataAttributeDiscrete) {
            EnumerationDeclaration enumeration = propertyDeclarations.getEnumerationDeclaration(attributeID);
            AbstractRepositoryDataTypeEnumeration.EnumerationParameters repositoryDataTypeParameters = enumeration.isMandatory() ? RDTSingleChoice.SingleChoiceParameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE(enumeration.getValueUserIDPairs()) : RDTSingleChoice.SingleChoiceParameters.PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE(enumeration.getValueUserIDPairs());
            AbstractFrontendDataTypeEnumeration.Parameters frontendDataTypeParameters = AbstractFrontendDataTypeEnumeration.Parameters.DEFAULTS(enumeration.getLabels());
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTSingleChoice.DATA_TYPE_ID, (IRepositoryDataTypeParameters)repositoryDataTypeParameters, (IFrontendDataTypeParameters)frontendDataTypeParameters);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeBoolean) {
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTBoolean.DATA_TYPE_ID, (IRepositoryDataTypeParameters)RDTBoolean.Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE, (IFrontendDataTypeParameters)FDTBoolean.Parameters.YES_NO);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeDuration) {
            FDTDuration64Bitmsec.Parameters frontendParameters;
            RDTDuration64Bitmsec.Parameters parameters;
            ModuleDataAttributeDuration durationAttribute = (ModuleDataAttributeDuration)moduleDataAttribute;
            if (durationAttribute.getUnit() == 3) {
                parameters = RDTDuration64Bitmsec.Parameters.PARAMETERS__IS_SET_ALWAYS__NULL_OR_POSITIVE_H;
                frontendParameters = FDTDuration64Bitmsec.Parameters.IS_IN_HOURS;
            } else if (durationAttribute.getUnit() == 2) {
                parameters = RDTDuration64Bitmsec.Parameters.PARAMETERS__IS_SET_ALWAYS__NULL_OR_POSITIVE_MIN;
                frontendParameters = FDTDuration64Bitmsec.Parameters.IS_IN_MINUTES;
            } else if (durationAttribute.getUnit() == 1) {
                parameters = RDTDuration64Bitmsec.Parameters.PARAMETERS__IS_SET_ALWAYS__NULL_OR_POSITIVE_H;
                frontendParameters = FDTDuration64Bitmsec.Parameters.IS_IN_HOURS;
            } else {
                parameters = RDTDuration64Bitmsec.Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE_MS;
                frontendParameters = FDTDuration64Bitmsec.Parameters.IS_IN_HOURS;
            }
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTDuration64Bitmsec.DATA_TYPE_ID, (IRepositoryDataTypeParameters)parameters, (IFrontendDataTypeParameters)frontendParameters);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeInteger) {
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTInteger32Bit.DATA_TYPE_ID, (IRepositoryDataTypeParameters)RDTInteger32Bit.Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE, (IFrontendDataTypeParameters)FDTInteger32Bit.Parameters.DEFAULTS);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeLong) {
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTInteger64Bit.DATA_TYPE_ID, (IRepositoryDataTypeParameters)RDTInteger64Bit.Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE, (IFrontendDataTypeParameters)FDTInteger64Bit.Parameters.DEFAULTS);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributePath) {
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTFreeString.DATA_TYPE_ID, (IRepositoryDataTypeParameters)RDTFreeString.Parameters.PARAMETERS__IS_SET_ALWAYS__POTENTIALLY_EMPTY, (IFrontendDataTypeParameters)FDTFreeString.Parameters.DEFAULTS);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeString) {
            int type = ((ModuleDataAttributeString)moduleDataAttribute).getType();
            boolean isSetAlways = true;
            long minLength = mandatory ? 1L : 0L;
            long maxLength = Integer.MAX_VALUE;
            boolean isBlackList = true;
            String blackList = "";
            if (type == 1) {
                return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTDisplayName.DATA_TYPE_ID, (IRepositoryDataTypeParameters)new RDTDisplayName.Parameters(isSetAlways, true, minLength, maxLength, isBlackList, blackList), (IFrontendDataTypeParameters)FDTDisplayName.Parameters.DEFAULTS);
            }
            if (type == 2) {
                return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTFreeText.DATA_TYPE_ID, (IRepositoryDataTypeParameters)new RDTFreeText.Parameters(isSetAlways, false, minLength, maxLength, isBlackList, blackList), (IFrontendDataTypeParameters)FDTFreeText.Parameters.DEFAULTS);
            }
            if (type == 3) {
                return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTUID.DATA_TYPE_ID, (IRepositoryDataTypeParameters)RDTUID.Parameters.PARAMETERS__IS_SET_ALWAYS__LENGTH_1_TO_256__CHARACTERS_DIGITS_LETTERS_UNDERSCORE_HYPHEN_DOT, (IFrontendDataTypeParameters)FDTUID.Parameters.DEFAULTS);
            }
            assert (false);
            return null;
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeTimestamp) {
            ModuleDataAttributeTimestamp timestampAttribute = (ModuleDataAttributeTimestamp)moduleDataAttribute;
            RDTDateUTC64Bitmsec.Parameters parameters = timestampAttribute.isTimeIncluded() ? RDTDateUTC64Bitmsec.Parameters.PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_AND_TIME__IN_MS : RDTDateUTC64Bitmsec.Parameters.PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_ONLY;
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTDateUTC64Bitmsec.DATA_TYPE_ID, (IRepositoryDataTypeParameters)parameters, (IFrontendDataTypeParameters)FDTDateUTC64Bitmsec.Parameters.DEFAULTS);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeUser) {
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTDisplayName.DATA_TYPE_ID, (IRepositoryDataTypeParameters)RDTDisplayName.Parameters.PARAMETERS__IS_SET_ALWAYS__POTENTIALLY_EMPTY, (IFrontendDataTypeParameters)FDTDisplayName.Parameters.DEFAULTS);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeIDFormat) {
            ChildrenIDFormatPropertyTypeDeclaration childrenIDFormatPropertyTypeDeclaration = propertyDeclarations.getChildrenIDFormatPropertyTypeDeclaration(attributeID);
            return new RepositoryDataTypeWithDataTypeParameters((IRepositoryDataTypeID)RDTPrefixIDFormat.DATA_TYPE_ID, (IRepositoryDataTypeParameters)new RDTPrefixIDFormat.PrefixIDFormatParameters(true, childrenIDFormatPropertyTypeDeclaration.getChildObjectTypeID(), childrenIDFormatPropertyTypeDeclaration.getDefaultPrefix()), (IFrontendDataTypeParameters)FDTPrefixIDFormat.Parameters.DEFAULTS);
        }
        assert (false);
        return null;
    }

    public static IRepositoryData getRepositoryDataValueSampleForModuleDataAttribute(IModuleDataAttribute moduleDataAttribute, boolean isRootItem) {
        if (moduleDataAttribute instanceof ModuleDataAttributeDiscrete) {
            ModuleDataAttributeDiscrete moduleDataAttributeDiscrete = (ModuleDataAttributeDiscrete)moduleDataAttribute;
            int indexOfEmptyEntry = DiscreteValueHelper.getIndexOfEmptyValue(moduleDataAttributeDiscrete.getValueRange());
            String uniqueStringRepresentation = moduleDataAttributeDiscrete.getValue() == indexOfEmptyEntry ? null : DiscreteValueHelper.getPlatformEnumerationElementID(moduleDataAttributeDiscrete.getUniqueStringRepresentation());
            return RDTSingleChoice.getInstance().createData(uniqueStringRepresentation);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeBoolean) {
            return RDTBoolean.getInstance().createData(Boolean.valueOf(((ModuleDataAttributeBoolean)moduleDataAttribute).getValue()));
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeDuration) {
            Long msecs = ((ModuleDataAttributeDuration)moduleDataAttribute).getValue();
            return RDTDuration64Bitmsec.getInstance().createData(msecs);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeInteger) {
            return RDTInteger32Bit.getInstance().createData(Integer.valueOf(((ModuleDataAttributeInteger)moduleDataAttribute).getValue()));
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeLong) {
            return RDTInteger64Bit.getInstance().createData(((ModuleDataAttributeLong)moduleDataAttribute).getValue());
        }
        if (moduleDataAttribute instanceof ModuleDataAttributePath) {
            return RDTFreeString.getInstance().createData(((ModuleDataAttributePath)moduleDataAttribute).getValue().toPortableString());
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeString) {
            int type = ((ModuleDataAttributeString)moduleDataAttribute).getType();
            if (type == 1) {
                String moduleData = ((ModuleDataAttributeString)moduleDataAttribute).getValue();
                if (moduleData == null) {
                    moduleData = "";
                }
                return RDTDisplayName.getInstance().createData(moduleData);
            }
            if (type == 2) {
                String moduleData = ((ModuleDataAttributeString)moduleDataAttribute).getValue();
                if (moduleData == null) {
                    moduleData = "";
                }
                return RDTFreeText.getInstance().createData(moduleData);
            }
            if (type == 3) {
                return RDTUID.getInstance().createData(((ModuleDataAttributeString)moduleDataAttribute).getValue());
            }
            assert (false);
            return null;
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeTimestamp) {
            Long value = ((ModuleDataAttributeTimestamp)moduleDataAttribute).getValue();
            Date date = value == null ? null : AttributeTypeConverter.convertModuleStoredDateIntoUTC(value);
            return RDTDateUTC64Bitmsec.getInstance().createData(date);
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeUser) {
            return RDTDisplayName.getInstance().createData(((ModuleDataAttributeUser)moduleDataAttribute).getValue());
        }
        if (moduleDataAttribute instanceof ModuleDataAttributeIDFormat) {
            ModuleDataAttributeIDFormat moduleDataAttributeIDFormat = (ModuleDataAttributeIDFormat)moduleDataAttribute;
            PrefixIDFormat prefixIDFormat = moduleDataAttributeIDFormat.getIDFormat();
            if (isRootItem && prefixIDFormat.getConstructionMode() == 0) {
                prefixIDFormat = PrefixIDFormat.createStandardIDPrefix((int)prefixIDFormat.getNumberOfDigits());
                moduleDataAttributeIDFormat.setIDFormat(prefixIDFormat);
            }
            return RDTPrefixIDFormat.getInstance().createData(prefixIDFormat);
        }
        assert (false);
        return null;
    }

    public static IRepositoryData getRepositoryDataValueForModuleDataAttribute(String attributeID, IModuleDataAttribute moduleDataAttribute, boolean isRootItem, IPropertyDeclarations propertyDeclarations, IRepositoryTypeManagerRO typeManager) {
        IRepositoryPropertyTypeID propertyTypeID = propertyDeclarations.createPropertyTypeID(attributeID);
        IRepositoryObjectTypeID objectTypeID = propertyDeclarations.getRepositoryObjectTypeID();
        IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
        IRepositoryPropertyType propertyType = objectType.getAttributeSetType(propertyTypeID).getPropertyType(propertyTypeID);
        IRepositoryDataTypeParameters dataTypeParameters = propertyType.getDataTypeParameters();
        IRepositoryData repositoryData = AttributeTypeConverter.getRepositoryDataValueSampleForModuleDataAttribute(moduleDataAttribute, isRootItem);
        IRepositoryDataType targetDataType = repositoryData.getDataType();
        try {
            targetDataType.snapAndCheckData(repositoryData, dataTypeParameters);
            return repositoryData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Date convertModuleStoredDateIntoUTC(Long moduleDate) {
        return new Date(moduleDate);
    }

    private static Long convertUTCIntoModuleStoredDate(Date date) {
        return date.getTime();
    }

    public static void setModuleDataAttributeWithRepositoryDataValue(IModuleDataAttribute moduleDataAttribute, IRepositoryData repositoryDataValue) {
        if (moduleDataAttribute instanceof ModuleDataAttributeDiscrete) {
            String indexAsString;
            ModuleDataAttributeDiscrete moduleDataAttributeDiscrete = (ModuleDataAttributeDiscrete)moduleDataAttribute;
            String uniqueStringRepresentation = RDTSingleChoice.getInstance().dataToValue(repositoryDataValue);
            if (uniqueStringRepresentation == null) {
                int indexOfEmptyEntry = DiscreteValueHelper.getIndexOfEmptyValue(moduleDataAttributeDiscrete.getValueRange());
                assert (indexOfEmptyEntry >= 0);
                indexAsString = ModuleDataAttributeDiscrete.getUniqueStringRepresentation(indexOfEmptyEntry);
            } else {
                indexAsString = DiscreteValueHelper.getUniqueStringRepresentation(uniqueStringRepresentation);
            }
            moduleDataAttributeDiscrete.setValueViaUniqueStringRepresentation(indexAsString);
        } else if (moduleDataAttribute instanceof ModuleDataAttributeBoolean) {
            ((ModuleDataAttributeBoolean)moduleDataAttribute).setValue(RDTBoolean.getInstance().dataToValue(repositoryDataValue));
        } else if (moduleDataAttribute instanceof ModuleDataAttributeDuration) {
            Long inModuleUnits = RDTDuration64Bitmsec.getInstance().dataToValue(repositoryDataValue);
            ((ModuleDataAttributeDuration)moduleDataAttribute).setValue(inModuleUnits);
        } else if (moduleDataAttribute instanceof ModuleDataAttributeInteger) {
            ((ModuleDataAttributeInteger)moduleDataAttribute).setValue(RDTInteger32Bit.getInstance().dataToValue(repositoryDataValue));
        } else if (moduleDataAttribute instanceof ModuleDataAttributeLong) {
            ((ModuleDataAttributeLong)moduleDataAttribute).setValue((long)RDTInteger64Bit.getInstance().dataToValue(repositoryDataValue));
        } else if (moduleDataAttribute instanceof ModuleDataAttributePath) {
            String string = RDTFreeString.getInstance().dataToValue(repositoryDataValue);
            IPath path = string != null ? Path.fromPortableString((String)string) : null;
            ((ModuleDataAttributePath)moduleDataAttribute).setValue(path);
        } else if (moduleDataAttribute instanceof ModuleDataAttributeString) {
            int type = ((ModuleDataAttributeString)moduleDataAttribute).getType();
            if (type == 1) {
                ((ModuleDataAttributeString)moduleDataAttribute).setValue(RDTDisplayName.getInstance().dataToValue(repositoryDataValue));
            } else if (type == 2) {
                ((ModuleDataAttributeString)moduleDataAttribute).setValue(RDTFreeText.getInstance().dataToValue(repositoryDataValue));
            } else if (type == 3) {
                ((ModuleDataAttributeString)moduleDataAttribute).setValue(RDTUID.getInstance().dataToValue(repositoryDataValue));
            } else assert (false);
        } else if (moduleDataAttribute instanceof ModuleDataAttributeTimestamp) {
            Date date = RDTDateUTC64Bitmsec.getInstance().dataToValue(repositoryDataValue);
            Long value = date == null ? null : AttributeTypeConverter.convertUTCIntoModuleStoredDate(date);
            ((ModuleDataAttributeTimestamp)moduleDataAttribute).setValue(value);
        } else if (moduleDataAttribute instanceof ModuleDataAttributeUser) {
            ((ModuleDataAttributeUser)moduleDataAttribute).setValue(RDTDisplayName.getInstance().dataToValue(repositoryDataValue));
        } else if (moduleDataAttribute instanceof ModuleDataAttributeIDFormat) {
            ((ModuleDataAttributeIDFormat)moduleDataAttribute).setIDFormat(RDTPrefixIDFormat.getInstance().dataToValue(repositoryDataValue));
        } else assert (false);
    }
}

