/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter;

import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.ICrossModuleLinkType;
import com.arcway.cockpit.modulelib2.client.platformadapter.AbstractModulePlatformAdapterModule;
import com.arcway.cockpit.modulelib2.client.platformadapter.LinkManagerAdapter_CrossModuleLink;
import com.arcway.cockpit.modulelib2.client.platformadapter.PlatformAdaptorConstants;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.AdapterForFrameLinkManager;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IObjectTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterModule;
import com.arcway.repository.clientadapter.interFace.IRelationTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import de.plans.lib.resources.IIconResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class PlatformAdapterModuleProviderCrossModuleLinks {
    public static final String ROLE_ID_REFERRING_ITEM = "referringItem";
    public static final String ROLE_ID_REFERRED_ITEM = "referredItem";

    public static Collection<IPlatformAdapterModule> getPlatformAdapterModules(Collection<ICrossModuleLinkType> crossModuleLinkTypes, final Map<String, String> map_cockpitTypeID_moduleID, final LinkManager linkManager, final ILockManager lockManager, final Map<String, ILicenseTypeProvider> map_moduleID_licenseTypeProvider, final ProjectAgent projectAgent) {
        LinkedList<IPlatformAdapterModule> platformAdapterModules = new LinkedList<IPlatformAdapterModule>();
        for (final ICrossModuleLinkType linkType : crossModuleLinkTypes) {
            platformAdapterModules.add(new AbstractModulePlatformAdapterModule("crossmodulelinks"){

                @Override
                protected String getRepositoryDeclarationModuleID() {
                    return linkType.getId();
                }

                @Override
                public String getModuleName(Locale locale) {
                    return String.valueOf(Messages.getString("CrossModuleLinks.General.Name", locale)) + " " + linkType.getId();
                }

                @Override
                public IIconResource getModuleIcon() {
                    return null;
                }

                public IRepositoryModuleTypeID[] getNeededRepositoryModuleTypeIDs() {
                    LinkedList<IRepositoryModuleTypeID> requiredModules = new LinkedList<IRepositoryModuleTypeID>();
                    requiredModules.add(PlatformAdaptorConstants.MODULE_TYPE_ID_GENERAL_DECLARATIONS_FOR_THE_MODULES);
                    HashSet<String> includedModules = new HashSet<String>();
                    HashSet<String> explicitelyAllowedTypes = new HashSet<String>();
                    explicitelyAllowedTypes.addAll(linkType.getAllowedTypesForLinkableObjectContribution());
                    explicitelyAllowedTypes.addAll(linkType.getAllowedTypesForModuleDataContribution());
                    for (String cockpitTypeID : explicitelyAllowedTypes) {
                        String moduleID = (String)map_cockpitTypeID_moduleID.get(cockpitTypeID);
                        if (includedModules.contains(moduleID)) continue;
                        requiredModules.add(new RepositoryIDCreator(RepositoryIDCreator.getCoreTypeID(moduleID), "declaration_module_coremodule").createRepositoryModuleTypeID());
                        includedModules.add(moduleID);
                    }
                    IRepositoryModuleTypeID[] requiredModules_asArray = new IRepositoryModuleTypeID[requiredModules.size()];
                    requiredModules.toArray(requiredModules_asArray);
                    return requiredModules_asArray;
                }

                public IObjectTypeDeclaration[] getAbstractObjectTypeDeclarations() {
                    return new IObjectTypeDeclaration[0];
                }

                public IDataManagerAdapter[] getConcreteObjectTypeDataManagers() {
                    return new IDataManagerAdapter[0];
                }

                public IRelationTypeDeclaration[] getAbstractRelationTypeDeclarations() {
                    return new IRelationTypeDeclaration[0];
                }

                public ILinkManagerAdapter[] getConcreteRelationTypeLinkManagers() {
                    return new ILinkManagerAdapter[]{new LinkManagerAdapter_CrossModuleLink(linkType, map_cockpitTypeID_moduleID, new AdapterForFrameLinkManager(linkManager, lockManager), this.repositoryIDCreator, projectAgent, map_moduleID_licenseTypeProvider)};
                }
            });
        }
        return platformAdapterModules;
    }
}

