/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter;

import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.platformadapter.containerclasses.RelationContributionType;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.LockHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILinkManagerInterfaceForPlatformAdapter;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.ILock;
import com.arcway.repository.clientadapter.interFace.IRelation;
import com.arcway.repository.clientadapter.interFace.IRelationContribution;
import com.arcway.repository.clientadapter.interFace.IRelationContributionForPermissionCheck;
import com.arcway.repository.clientadapter.interFace.IRelationContributionType;
import com.arcway.repository.clientadapter.interFace.IRelationContributionWithRelatedObject;
import com.arcway.repository.clientadapter.lib.Relation;
import com.arcway.repository.clientadapter.lib.RelationContribution;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.lib.high.declaration.type.relation.RepositoryRelationTypeID;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public abstract class AbstractLinkManagerAdapter
implements ILinkManagerAdapter {
    protected final ILinkManagerInterfaceForPlatformAdapter linkManager;
    protected AbstractDataMgr dataManager;
    protected AbstractPermissionMgr permissionMgr;
    private final ILinkTypeHelper linkTypeHelper;
    protected RepositoryIDCreator repositoryIDCreator;

    public AbstractLinkManagerAdapter(ILinkManagerInterfaceForPlatformAdapter linkManager, AbstractDataMgr dataManager, ILinkTypeHelper linkTypeHelper, RepositoryIDCreator repositoryIDCreator) {
        this.linkManager = linkManager;
        this.dataManager = dataManager;
        if (dataManager != null) {
            this.permissionMgr = dataManager.getPermissionMgr();
        }
        this.linkTypeHelper = linkTypeHelper;
        this.repositoryIDCreator = repositoryIDCreator;
    }

    public IRepositoryRelationTypeID getRepositoryRelationTypeID() {
        return this.repositoryIDCreator.createRelationTypeID((RepositoryRelationTypeID)this.getRepositorySuperRelationTypeID(), this.getCockpitLinkTypeID());
    }

    protected IRepositoryRelationContributionRoleID getRelationContributionRoleIDForModuleData() {
        return this.repositoryIDCreator.createRelationContributionRoleID((RepositoryRelationTypeID)this.getRepositorySuperRelationTypeID(), this.getCockpitLinkTypeID(), this.getModuleDataRoleID());
    }

    protected IRepositoryRelationContributionRoleID getRelationContributionRoleIDForLinkableObject() {
        return this.repositoryIDCreator.createRelationContributionRoleID((RepositoryRelationTypeID)this.getRepositorySuperRelationTypeID(), this.getCockpitLinkTypeID(), this.getLinkableObjectRoleID());
    }

    public final IRelationContributionType[] getRelationContributionTypes() {
        return new IRelationContributionType[]{new RelationContributionType(this.getRelationContributionRoleIDForModuleData(), this.getModuleDataObjectTypeID(), this.getModuleDataCardinality(), this.getModuleDataRoleLabels()), new RelationContributionType(this.getRelationContributionRoleIDForLinkableObject(), this.getLinkableObjectObjectTypeID(), this.getLinkableObjectCardinality(), this.getLinkableObjectRoleLabels())};
    }

    public final void createLink(IRelationContribution[] relationContributions) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        assert (relationContributions.length == 2);
        IRelationContribution LOContribution = this.retrieveLinkableObjectContribution(relationContributions);
        assert (LOContribution != null);
        String linkableObjectUID = LOContribution.getCockpitDataUID();
        IRelationContribution MDContribution = this.retrieveModuleDataContribution(relationContributions);
        assert (MDContribution != null);
        String moduleDataUID = MDContribution.getCockpitDataUID();
        LockAccess lockAccess = this.linkManager.acquireLocksForLinkData(linkableObjectUID, moduleDataUID, this.getCockpitLinkTypeID());
        if (!lockAccess.hasLock()) {
            Collection<EOLock> conflictingLocks = lockAccess.getConflictingLocks();
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        this.checkPermissionForCreateOrDeleteLink(this.toRelationContributionsForPermissionCheck(relationContributions));
        IStatus status = this.linkManager.createLink(linkableObjectUID, moduleDataUID, this.getCockpitLinkTypeID());
        if (status.getSeverity() == 4) {
            throw new RuntimeException("Could not create link (" + MDContribution.getRepositoryRelationContributionRoleID().toCanonicalString() + " -> " + LOContribution.getRepositoryRelationContributionRoleID().toCanonicalString() + ")");
        }
        if (this.isPropertyOfModuleDataItems()) {
            String moduleDataCockpitTypeID = this.linkTypeHelper.getLinkSourceDataTypeIDForLinkType(this.getCockpitLinkTypeID());
            final IModuleData item = (IModuleData)this.dataManager.getItem(moduleDataCockpitTypeID, moduleDataUID);
            this.dataManager.getModelTransactionManager().executeTransaction(new Runnable(){

                @Override
                public void run() {
                    AbstractLinkManagerAdapter.this.dataManager.itemPropertiesModified(item);
                }
            });
        }
    }

    public final void deleteLink(IRelationContribution[] relationContributions) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        assert (relationContributions.length == 2);
        IRelationContribution LOContribution = this.retrieveLinkableObjectContribution(relationContributions);
        assert (LOContribution != null);
        String linkableObjectUID = LOContribution.getCockpitDataUID();
        IRelationContribution MDContribution = this.retrieveModuleDataContribution(relationContributions);
        assert (MDContribution != null);
        String moduleDataUID = MDContribution.getCockpitDataUID();
        LockAccess lockAccess = this.linkManager.acquireLocksForLinkData(linkableObjectUID, moduleDataUID, this.getCockpitLinkTypeID());
        if (!lockAccess.hasLock()) {
            Collection<EOLock> conflictingLocks = lockAccess.getConflictingLocks();
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        this.checkPermissionForCreateOrDeleteLink(this.toRelationContributionsForPermissionCheck(relationContributions));
        IStatus status = this.linkManager.deleteLink(linkableObjectUID, moduleDataUID, this.getCockpitLinkTypeID());
        if (status.getSeverity() == 4) {
            throw new RuntimeException("Could not delete link (" + MDContribution.getRepositoryRelationContributionRoleID().toCanonicalString() + " -> " + LOContribution.getRepositoryRelationContributionRoleID().toCanonicalString() + ")");
        }
        if (this.isPropertyOfModuleDataItems()) {
            String moduleDataCockpitTypeID = this.linkTypeHelper.getLinkSourceDataTypeIDForLinkType(this.getCockpitLinkTypeID());
            final IModuleData item = (IModuleData)this.dataManager.getItem(moduleDataCockpitTypeID, moduleDataUID);
            this.dataManager.getModelTransactionManager().executeTransaction(new Runnable(){

                @Override
                public void run() {
                    AbstractLinkManagerAdapter.this.dataManager.itemPropertiesModified(item);
                }
            });
        }
    }

    private IRelationContributionForPermissionCheck[] toRelationContributionsForPermissionCheck(IRelationContribution[] relationContributions) {
        IRelationContributionForPermissionCheck[] relationContributionsForPermissionChecks = new IRelationContributionForPermissionCheck[relationContributions.length];
        int i = 0;
        while (i < relationContributions.length) {
            IRelationContributionForPermissionCheck relationContributionForPermissionChecks;
            final IRelationContribution relationContribution = relationContributions[i];
            relationContributionsForPermissionChecks[i] = relationContributionForPermissionChecks = new IRelationContributionForPermissionCheck(){

                public IRepositoryRelationContributionRoleID getRepositoryRelationContributionRoleID() {
                    return relationContribution.getRepositoryRelationContributionRoleID();
                }

                public String getDataTypeIDOfTheDatasAncestor() {
                    return null;
                }

                public String getCockpitDataUID() {
                    return relationContribution.getCockpitDataUID();
                }
            };
            ++i;
        }
        return relationContributionsForPermissionChecks;
    }

    public final IRelation[] getRelations(IRelationContributionWithRelatedObject[] givenRelationContributions) {
        IRelation[] relations;
        int numberOfRC = givenRelationContributions.length;
        switch (numberOfRC) {
            case 0: {
                ISetMapWithFixReturnSetsRO<String, EOLink> allLinksMappedByLOUID = this.getAllLinksMappedByLinkableObjectUID();
                int totalLinkNumber = 0;
                for (String loUID : allLinksMappedByLOUID.keySet()) {
                    Set links4lo = allLinksMappedByLOUID.get((Object)loUID);
                    totalLinkNumber += links4lo.size();
                }
                relations = new IRelation[totalLinkNumber];
                int index = 0;
                IRepositoryRelationContributionRoleID iRepositoryRelationContributionRoleID = this.getRelationContributionRoleIDForModuleData();
                IRepositoryRelationContributionRoleID linkableObjectRepositoryRoleID = this.getRelationContributionRoleIDForLinkableObject();
                for (String loUID : allLinksMappedByLOUID.keySet()) {
                    RelationContribution linkableObjectDataRC = new RelationContribution(linkableObjectRepositoryRoleID, loUID);
                    for (EOLink link : allLinksMappedByLOUID.get((Object)loUID)) {
                        RelationContribution moduleDataRC = new RelationContribution(iRepositoryRelationContributionRoleID, link.getModuleDataUID());
                        relations[index] = new Relation(new IRelationContributionWithRelatedObject[0], new IRelationContribution[]{moduleDataRC, linkableObjectDataRC});
                        ++index;
                    }
                }
                break;
            }
            case 1: {
                Collection<? extends ICockpitProjectData> relatedItems = null;
                IRepositoryRelationContributionRoleID resultRepositoryRoleID = null;
                if (this.isContributionOfRole(givenRelationContributions[0].getRepositoryRelationContributionRoleID(), this.getRelationContributionRoleIDForModuleData())) {
                    relatedItems = this.getLinkableObjects(givenRelationContributions[0].getCockpitDataUID());
                    resultRepositoryRoleID = this.getRelationContributionRoleIDForLinkableObject();
                } else if (this.isContributionOfRole(givenRelationContributions[0].getRepositoryRelationContributionRoleID(), this.getRelationContributionRoleIDForLinkableObject())) {
                    relatedItems = this.getModuleDataItems(givenRelationContributions[0].getCockpitDataUID());
                    resultRepositoryRoleID = this.getRelationContributionRoleIDForModuleData();
                } else {
                    assert (false);
                    return new IRelation[0];
                }
                relations = new IRelation[relatedItems.size()];
                int index = 0;
                for (ICockpitProjectData iCockpitProjectData : relatedItems) {
                    relations[index] = new Relation(new IRelationContributionWithRelatedObject[]{givenRelationContributions[0]}, new IRelationContribution[]{new RelationContribution(resultRepositoryRoleID, iCockpitProjectData.getUID())});
                    ++index;
                }
                break;
            }
            case 2: {
                IRelationContributionWithRelatedObject moduleDataRC = null;
                IRelationContributionWithRelatedObject linkedObjectTypeRC = null;
                int i = 0;
                while (i < numberOfRC) {
                    if (this.isContributionOfRole(givenRelationContributions[i].getRepositoryRelationContributionRoleID(), this.getRelationContributionRoleIDForModuleData())) {
                        moduleDataRC = givenRelationContributions[i];
                    } else if (this.isContributionOfRole(givenRelationContributions[i].getRepositoryRelationContributionRoleID(), this.getRelationContributionRoleIDForLinkableObject())) {
                        linkedObjectTypeRC = givenRelationContributions[i];
                    }
                    ++i;
                }
                assert (moduleDataRC != null);
                assert (linkedObjectTypeRC != null);
                relations = new IRelation[]{};
                EOLink link = this.getLink(moduleDataRC.getCockpitDataUID(), linkedObjectTypeRC.getCockpitDataUID());
                if (link == null) break;
                relations = new IRelation[]{new Relation(new IRelationContributionWithRelatedObject[]{moduleDataRC, linkedObjectTypeRC}, new IRelationContribution[0])};
                break;
            }
            default: {
                throw new RuntimeException("Only relations with a maximum of two relation contributions are supported !");
            }
        }
        return relations;
    }

    protected <T extends IRelationContribution> T retrieveModuleDataContribution(T[] contributions) {
        return (T)this.retrieveRelationContributionOfRole((IRelationContribution[])contributions, this.getRelationContributionRoleIDForModuleData());
    }

    protected <T extends IRelationContribution> T retrieveLinkableObjectContribution(T[] contributions) {
        return (T)this.retrieveRelationContributionOfRole((IRelationContribution[])contributions, this.getRelationContributionRoleIDForLinkableObject());
    }

    protected <T extends IRelationContribution> T retrieveRelationContributionOfRole(T[] contributions, IRepositoryRelationContributionRoleID roleID) {
        T[] TArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            T contribution = TArray[n2];
            if (this.isContributionOfRole(contribution.getRepositoryRelationContributionRoleID(), roleID)) {
                return contribution;
            }
            ++n2;
        }
        return null;
    }

    private boolean isContributionOfRole(IRepositoryRelationContributionRoleID roleIDToCompare, IRepositoryRelationContributionRoleID roleID) {
        return IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleIDToCompare, (Object)roleID);
    }

    public final ILock getLockForCreateOrDeleteLink(IRelationContribution[] relationContributions) throws EXCockpitLockDenied {
        IRelationContribution LOContribution = this.retrieveLinkableObjectContribution(relationContributions);
        String linkableObjectUID = LOContribution != null ? LOContribution.getCockpitDataUID() : null;
        IRelationContribution MDContribution = this.retrieveModuleDataContribution(relationContributions);
        String moduleDataUID = MDContribution != null ? MDContribution.getCockpitDataUID() : null;
        LockAccess lockAccess = this.linkManager.acquireLocksForLinkData(linkableObjectUID, moduleDataUID, this.getCockpitLinkTypeID());
        return LockHelper.getILock(lockAccess);
    }

    protected abstract String getCockpitLinkTypeID();

    protected abstract String getModuleDataRoleID();

    protected abstract String getLinkableObjectRoleID();

    protected abstract IRepositoryObjectTypeID getModuleDataObjectTypeID();

    protected abstract IRepositoryObjectTypeID getLinkableObjectObjectTypeID();

    protected abstract CardinalityType getModuleDataCardinality();

    protected abstract CardinalityType getLinkableObjectCardinality();

    protected abstract ILabel[] getLinkableObjectRoleLabels();

    protected abstract ILabel[] getModuleDataRoleLabels();

    protected abstract boolean isPropertyOfModuleDataItems();

    protected ISetMapWithFixReturnSetsRO<String, EOLink> getAllLinksMappedByLinkableObjectUID() {
        return this.linkManager.getLinksForLinkType(this.getCockpitLinkTypeID());
    }

    protected Collection<? extends ICockpitProjectData> getLinkableObjects(String moduleDataUID) {
        return this.linkManager.getLinkableObjects(moduleDataUID, this.getCockpitLinkTypeID());
    }

    protected Collection<? extends ICockpitProjectData> getModuleDataItems(String linkableObjectUID) {
        return this.linkManager.getModuleData(linkableObjectUID, this.getCockpitLinkTypeID());
    }

    protected EOLink getLink(String moduleDataUID, String linkableObjectUID) {
        for (EOLink link : this.linkManager.getLinksForLinkableObject(linkableObjectUID, this.getCockpitLinkTypeID())) {
            if (!link.getModuleDataUID().equals(moduleDataUID)) continue;
            return link;
        }
        return null;
    }
}

