/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages;

import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkCardinality;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;

public class ModuleLinkType
implements ILinkType {
    private final String linkTypeID;
    private final String displayName;
    private final boolean hasFrameLinkableObjectType;
    private final String frameLinkableObjectTypeID;
    private final String moduleID;
    private final ILinkCardinality cardinality;
    private final boolean isAttributeLink;
    private final boolean isModificationToBeDisplayedToTheUser;
    private final ILinkTypeHelper_Shared linkTypeHelper;

    public ModuleLinkType(String linkTypeID, String displayName, String moduleID, ILinkCardinality cardinality, boolean isAttributeLink, boolean isModificationToBeDisplayedToTheUser, ILinkTypeHelper_Shared linkTypeHelper) {
        this.linkTypeID = linkTypeID;
        this.displayName = displayName;
        this.moduleID = moduleID;
        this.cardinality = cardinality;
        this.isAttributeLink = isAttributeLink;
        this.isModificationToBeDisplayedToTheUser = isModificationToBeDisplayedToTheUser;
        this.linkTypeHelper = linkTypeHelper;
        this.hasFrameLinkableObjectType = false;
        this.frameLinkableObjectTypeID = null;
    }

    public ModuleLinkType(String linkTypeID, String displayName, String moduleID, String frameLinkableObjectTypeID, ILinkCardinality cardinality, boolean isAttributeLink, boolean isModificationToBeDisplayedToTheUser, ILinkTypeHelper_Shared linkTypeHelper) {
        this.linkTypeID = linkTypeID;
        this.displayName = displayName;
        this.moduleID = moduleID;
        this.frameLinkableObjectTypeID = frameLinkableObjectTypeID;
        this.cardinality = cardinality;
        this.isAttributeLink = isAttributeLink;
        this.isModificationToBeDisplayedToTheUser = isModificationToBeDisplayedToTheUser;
        this.linkTypeHelper = linkTypeHelper;
        this.hasFrameLinkableObjectType = true;
    }

    public String getUID() {
        return this.linkTypeID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public String getLinkableObjectTypeID() {
        if (this.hasFrameLinkableObjectType) {
            return this.frameLinkableObjectTypeID;
        }
        return this.linkTypeHelper.getLinkTargetDataTypeIDForLinkType(this.linkTypeID);
    }

    public String getModuleDataTypeID() {
        return this.linkTypeHelper.getLinkSourceDataTypeIDForLinkType(this.linkTypeID);
    }

    public ILinkCardinality getCardinality() {
        return this.cardinality;
    }

    public boolean isAttributeLinkType() {
        return this.isAttributeLink;
    }

    public boolean isModificationToBeDisplayedToTheUser() {
        return this.isModificationToBeDisplayedToTheUser;
    }

    public int getLockingBehaviour() {
        return this.cardinality.getPreferredLockingBehaviour();
    }

    public String getCorrespondingLinkTypeID() {
        return null;
    }
}

