/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.valueranges.IString;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.ValueString;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractStringValueFilter
extends AbstractFilter {
    protected IString filterString = new ValueString("");
    private final IValueRangeHelperText valueRangeHelper = this.getValueRangeHelper();
    private static final ILogger logger = Logger.getLogger(AbstractStringValueFilter.class);

    protected abstract IValueRangeHelperText getValueRangeHelper();

    public boolean doesItemPassFilter(Viewer viewer, Object parentElement, Object element) {
        return this.doesItemPassFilter(element);
    }

    public boolean doesItemPassFilter(Object element) {
        String value = this.getStringAttribute(element).getValue();
        if (value != null) {
            if (this.filterString != null) {
                return StringUtil.containsSubstring((String)value, (String)this.filterString.getValue());
            }
            return true;
        }
        return false;
    }

    protected abstract IString getStringAttribute(Object var1);

    public void init(String valueString) {
        this.filterString = new ValueString(valueString);
    }

    public String getFilterValue() {
        return this.filterString.getValue();
    }

    public void setFilterValue(String value) {
        if (value != null) {
            this.filterString.setValue(value);
        } else {
            this.filterString.setValue("");
        }
        super.setFilterValue("");
    }

    public void setFilterFromUI(String displayRepresentation) {
        this.valueRangeHelper.setPersistentValue(displayRepresentation);
    }

    public String getUIRepresentation() {
        return this.valueRangeHelper.getDisplayFormat();
    }

    public void resetValue() {
        this.setFilterValue("");
    }
}

