/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure;

import com.arcway.cockpit.modulelib2.client.gui.editor.specification.AbstractEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.IEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.IItemID;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.WidgetParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Widget
extends AbstractEditorSpecificationPart {
    private final Map<String, Widget> widgetMap = new HashMap<String, Widget>();
    private final WidgetParameters widgetParameters;
    private final Map<String, IItemID> itemIDMap;
    private final String widgetTypeID;

    public Widget(List<Widget> widgetList, WidgetParameters widgetParameters, List<IItemID> itemIDList, String widgetTypeID) {
        int widgetListCounter = 1;
        for (Widget part : widgetList) {
            part.setIndex(widgetListCounter);
            String partID = part.getID();
            this.widgetMap.put(partID, part);
            ++widgetListCounter;
        }
        this.widgetParameters = widgetParameters;
        this.itemIDMap = new HashMap<String, IItemID>();
        int itemIDListCounter = 1;
        for (IItemID part : itemIDList) {
            ((AbstractEditorSpecificationPart)((Object)part)).setIndex(itemIDListCounter);
            String partID = part.getItemID();
            this.itemIDMap.put(partID, part);
            ++itemIDListCounter;
        }
        this.widgetTypeID = widgetTypeID;
    }

    public List<Widget> getWidgetList() {
        ArrayList<Widget> list = new ArrayList<Widget>(this.widgetMap.values());
        Widget.sortSpecificationPartList(list);
        return list;
    }

    public Widget getWidget(String id) {
        return this.widgetMap.get(id);
    }

    public Widget getWidget(int index) {
        return this.getWidgetList().get(index);
    }

    public WidgetParameters getWidgetParameters() {
        return this.widgetParameters;
    }

    public List<IItemID> getItemIDList() {
        ArrayList<IItemID> list = new ArrayList<IItemID>(this.itemIDMap.values());
        Widget.sortSpecificationPartList(list);
        return list;
    }

    public IItemID getItemID(String id) {
        return this.itemIDMap.get(id);
    }

    public IItemID getItemID(int index) {
        return this.getItemIDList().get(index);
    }

    public String getWidgetTypeID() {
        return this.widgetTypeID;
    }

    public List<IEditorSpecificationPart> getChildren() {
        ArrayList<IEditorSpecificationPart> children = new ArrayList<IEditorSpecificationPart>();
        children.addAll(this.widgetMap.values());
        children.add(this.widgetParameters);
        children.addAll(this.itemIDMap.values());
        return children;
    }

    @Override
    public String getTypeID() {
        return "Widget";
    }
}

