/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dnd;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataView;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.sequences.ISequencer;
import com.arcway.cockpit.frame.client.project.sequences.ISequencerManager;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ICopyDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.IMoveDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ModuleDataInternalTransfer;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.lib.eclipse.transfer.dnd.IDropHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractNaturalOrderDragNDropSupport
implements IModuleProjectSwitchListener,
IActiveProjectProvider {
    private static final String TRANSFER_TYPE_BASE = "ModuleData_Reordering_";
    private final Transfer transfer;
    private IModelController modelController;
    private IProjectAgent projectAgent;
    private ISequencerManager sequencerManager;
    private final TreeDataView<?> dataView;
    private IMoveDragNDropExecuter moveDragNDropExecuter;
    private final ICopyDragNDropExecuter copyDragNDropExecuter;
    private static ModuleDataReorderingTransferContent transferData = null;

    public AbstractNaturalOrderDragNDropSupport(IModelController modelController, TreeDataView<?> dataView, IMoveDragNDropExecuter moveDragNDropExecuter, ICopyDragNDropExecuter copyDragNDropExecuter) {
        this.dataView = dataView;
        this.modelController = modelController;
        if (modelController != null) {
            this.projectAgent = modelController.getProjectAgent();
            this.sequencerManager = ((IModuleProjectAgent)this.projectAgent).getSequencerManager();
        }
        this.moveDragNDropExecuter = moveDragNDropExecuter;
        this.copyDragNDropExecuter = copyDragNDropExecuter;
        this.transfer = new ModuleDataInternalTransfer(TRANSFER_TYPE_BASE + UUIDGenerator.getUniqueID());
    }

    public DragSource getDragSource() {
        return new DragSource(this.getDragOperations(), this.getTransfers(), this.getDragHandler(), this.getRequiredLicenseType(), this.getProjectManager(), (IActiveProjectProvider)this);
    }

    public DropTarget getDropTarget() {
        return new DropTarget(this.getDropOperations(), this.getTransfers(), this.getDropHandler(), this.getRequiredLicenseType(), this.getProjectManager(), (IActiveProjectProvider)this);
    }

    public void setMoveDragNDropExecuter(IMoveDragNDropExecuter executer) {
        this.moveDragNDropExecuter = executer;
    }

    private int getDragOperations() {
        return 19;
    }

    private int getDropOperations() {
        return 19;
    }

    private Set<Transfer> getTransfers() {
        return Collections.singleton(this.transfer);
    }

    private IDragHandler getDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){

            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
                if (AbstractNaturalOrderDragNDropSupport.this.dataView.getSortingMode() != 1) {
                    return false;
                }
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                List selectedItems = ((IStructuredSelection)selection).toList();
                if (selectedItems.size() == 0) {
                    return false;
                }
                String dataType = null;
                IModuleData parent = null;
                boolean commonParent = true;
                for (Object selectedItem : selectedItems) {
                    if (!(selectedItem instanceof IModuleData)) {
                        return false;
                    }
                    IModuleData selectedModuleDataItem = (IModuleData)selectedItem;
                    if (!selectedModuleDataItem.getTypeDescription().isNaturalOrderUserDetermined()) {
                        return false;
                    }
                    if (dataType == null) {
                        dataType = selectedModuleDataItem.getTypeDescription().getDataTypeForNaturalOrdering().getCockpitDataTypeID();
                    } else if (!dataType.equals(selectedModuleDataItem.getTypeDescription().getDataTypeForNaturalOrdering().getCockpitDataTypeID())) {
                        return false;
                    }
                    if (commonParent) {
                        if (parent == null) {
                            parent = AbstractNaturalOrderDragNDropSupport.this.modelController.getParent(selectedModuleDataItem);
                        } else if (!parent.equals(AbstractNaturalOrderDragNDropSupport.this.modelController.getParent(selectedModuleDataItem))) {
                            commonParent = false;
                            if (AbstractNaturalOrderDragNDropSupport.this.moveDragNDropExecuter == null && AbstractNaturalOrderDragNDropSupport.this.copyDragNDropExecuter == null) {
                                return false;
                            }
                        }
                    }
                    if (commonParent) continue;
                    parent = null;
                }
                transferData = new ModuleDataReorderingTransferContent(selectedItems, dataType, parent, !commonParent);
                return true;
            }

            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                return transferData.uid;
            }

            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
            }
        };
        return dragHandler;
    }

    private IDropHandler getDropHandler() {
        IDropHandler dropHandler = new IDropHandler(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isDropPossible(DropTargetEvent event, int location, Control targetControl, DropTargetParameters parametersToChoose) {
                if (transferData == null) {
                    return false;
                }
                if (event.item == null || event.item.getData() == null || !(event.item.getData() instanceof IModuleData)) return false;
                TransferData dataType = AbstractNaturalOrderDragNDropSupport.this.extractRequiredDatatype(event.dataTypes);
                if (dataType == null) {
                    return false;
                }
                parametersToChoose.requestedTransferType = dataType;
                int appropriateOperations = AbstractNaturalOrderDragNDropSupport.this.extractAppropriateOperations(event.operations, event.detail);
                if (appropriateOperations == 0) {
                    return false;
                }
                if (location != 1 && location != 2) {
                    return false;
                }
                IModuleData targetData = (IModuleData)event.item.getData();
                IModuleData targetParent = AbstractNaturalOrderDragNDropSupport.this.modelController.getParent(targetData);
                if (!targetData.getTypeDescription().getDataTypeForNaturalOrdering().getCockpitDataTypeID().equals(transferData.dataType)) {
                    return false;
                }
                if ((appropriateOperations & 2) != 0) {
                    int xorComposition;
                    boolean movingPossible = true;
                    for (IModuleData sourceItem : transferData.moduleData) {
                        if (!sourceItem.equals(targetData)) continue;
                        movingPossible = false;
                        break;
                    }
                    if (!movingPossible && (appropriateOperations &= (xorComposition = appropriateOperations ^ 2)) == 0) {
                        return false;
                    }
                }
                if (transferData.multipleParents || targetParent == null && transferData.parent != null || targetParent != null && !targetParent.equals(transferData.parent)) {
                    if ((appropriateOperations & 2) != 0 && AbstractNaturalOrderDragNDropSupport.this.moveDragNDropExecuter != null && AbstractNaturalOrderDragNDropSupport.this.moveDragNDropExecuter.isMovePossible(transferData.moduleData, targetParent, true)) {
                        parametersToChoose.requestedOperation = 2;
                    } else {
                        if ((appropriateOperations & 1) == 0 || AbstractNaturalOrderDragNDropSupport.this.copyDragNDropExecuter == null || !AbstractNaturalOrderDragNDropSupport.this.copyDragNDropExecuter.isCopyPossible(transferData.moduleData, targetParent, true)) return false;
                        parametersToChoose.requestedOperation = 1;
                    }
                } else if ((appropriateOperations & 2) != 0) {
                    parametersToChoose.requestedOperation = 2;
                } else {
                    if ((appropriateOperations & 1) == 0 || AbstractNaturalOrderDragNDropSupport.this.copyDragNDropExecuter == null || !AbstractNaturalOrderDragNDropSupport.this.copyDragNDropExecuter.isCopyPossible(transferData.moduleData, targetParent, true)) return false;
                    parametersToChoose.requestedOperation = 1;
                }
                transferData.operation = parametersToChoose.requestedOperation;
                parametersToChoose.requestedFeedbackTypes = 14;
                return true;
            }

            public boolean performDrop(DropTargetEvent event, final int location, final Control targetControl) {
                final IModuleData targetData = (IModuleData)event.item.getData();
                final IModuleData targetParent = AbstractNaturalOrderDragNDropSupport.this.modelController.getParent(targetData);
                Object targetParentAttributeOwner = targetParent != null ? AbstractNaturalOrderDragNDropSupport.this.modelController.getAttributeOwner(targetParent) : ((IModuleProjectAgent)AbstractNaturalOrderDragNDropSupport.this.projectAgent).getProject();
                final ISequencer targetSequencer = AbstractNaturalOrderDragNDropSupport.this.sequencerManager.getSequencer(targetParentAttributeOwner, new ArrayList(), (ICockpitDataType)targetData.getTypeDescription().getDataTypeForNaturalOrdering());
                LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController((IFrameProjectAgent)AbstractNaturalOrderDragNDropSupport.this.projectAgent);
                targetSequencer.requestSequenceChangePermission((ILocksAndPermissionsTransactionController)transactionController);
                Collection modificationProblems = transactionController.execute();
                if (modificationProblems.isEmpty()) {
                    ArrayList<IModuleData> notReorderableItems = new ArrayList<IModuleData>();
                    HashSet<LocksAndPermissionsTransactionController> transactionControllers = new HashSet<LocksAndPermissionsTransactionController>();
                    boolean moveBetweenDifferentParents = transferData.operation == 2 && (transferData.multipleParents || transferData.parent == null && targetParent != null || transferData.parent != null && !transferData.parent.equals(targetParent));
                    boolean reorderWithinParents = transferData.operation == 2 && !transferData.multipleParents && (transferData.parent == null && targetParent == null || transferData.parent != null && transferData.parent.equals(targetParent));
                    for (IModuleData sourceItem : transferData.moduleData) {
                        IModuleData sourceParent = AbstractNaturalOrderDragNDropSupport.this.modelController.getParent(sourceItem);
                        boolean lockOK = true;
                        if (moveBetweenDifferentParents) {
                            Object sourceParentAttributeOwner = sourceParent != null ? ((IFrameProjectAgent)AbstractNaturalOrderDragNDropSupport.this.projectAgent).getModuleController().getModuleForData((ICockpitProjectData)sourceParent).getAttributeOwner((ICockpitProjectData)sourceParent) : ((IModuleProjectAgent)AbstractNaturalOrderDragNDropSupport.this.projectAgent).getProject();
                            ISequencer sourceSequencer = AbstractNaturalOrderDragNDropSupport.this.sequencerManager.getSequencer((IAttributeOwner)sourceParentAttributeOwner, new ArrayList(), (ICockpitDataType)sourceItem.getTypeDescription().getDataTypeForNaturalOrdering());
                            transactionController = new LocksAndPermissionsTransactionController((IFrameProjectAgent)AbstractNaturalOrderDragNDropSupport.this.projectAgent);
                            sourceSequencer.requestSequenceChangePermission((ILocksAndPermissionsTransactionController)transactionController);
                            modificationProblems = transactionController.execute();
                            if (!modificationProblems.isEmpty()) {
                                lockOK = false;
                            } else {
                                transactionControllers.add(transactionController);
                            }
                        }
                        boolean permissionOk = true;
                        if (reorderWithinParents) {
                            permissionOk = AbstractNaturalOrderDragNDropSupport.this.modelController.getPermissionMgr().mayEditItemStructurally(sourceItem, sourceParent);
                        }
                        if (lockOK && permissionOk) continue;
                        notReorderableItems.add(sourceItem);
                    }
                    if (!notReorderableItems.isEmpty()) {
                        if (transferData.moduleData.size() == notReorderableItems.size()) {
                            MessageDialog.openInformation((Shell)targetControl.getShell(), (String)Messages.getString("ReorderingDragNDropSupport.ReorderingToTargetImpossible_Title"), (String)(String.valueOf(Messages.getString("ReorderingDragNDropSupport.AllItemsCantBeMoved")) + Messages.getString("ReorderingDragNDropSupport.NoLockOrPermissionProblem")));
                            return false;
                        }
                        String message = AbstractNaturalOrderDragNDropSupport.this.createReorderAnywayMessage(notReorderableItems, Messages.getString("ReorderingDragNDropSupport.NoLockOrPermissionProblem"));
                        if (!MessageDialog.openConfirm((Shell)targetControl.getShell(), (String)Messages.getString("ReorderingDragNDropSupport.NoLockOrPermissionTitle"), (String)message)) {
                            for (ILocksAndPermissionsTransactionController iLocksAndPermissionsTransactionController : transactionControllers) {
                                iLocksAndPermissionsTransactionController.rollback();
                            }
                            return false;
                        }
                    }
                    final HashSet<IModuleData> itemsToReorder_final = new HashSet<IModuleData>(transferData.moduleData);
                    itemsToReorder_final.removeAll(notReorderableItems);
                    final BooleanWrapper booleanWrapper = new BooleanWrapper();
                    AbstractNaturalOrderDragNDropSupport.this.modelController.executeTransaction(new Runnable(){

                        @Override
                        public void run() {
                            Collection itemsToReorder = itemsToReorder_final;
                            if (transferData.operation == 1) {
                                itemsToReorder = AbstractNaturalOrderDragNDropSupport.this.copyDragNDropExecuter.doCopy(itemsToReorder, targetParent, targetControl.getShell());
                            } else if (transferData.multipleParents || transferData.parent == null && targetParent != null || transferData.parent != null && !transferData.parent.equals(targetParent)) {
                                itemsToReorder = AbstractNaturalOrderDragNDropSupport.this.moveDragNDropExecuter.doMove(itemsToReorder, targetParent, targetControl.getShell());
                            }
                            if (itemsToReorder.isEmpty()) {
                                booleanWrapper.value = false;
                                return;
                            }
                            if (!AbstractNaturalOrderDragNDropSupport.this.ensureChildrenOrder(targetParent, ((IModuleData)itemsToReorder.iterator().next()).getTypeDescription().getDataTypeForNaturalOrdering().getCockpitDataTypeID(), targetSequencer)) {
                                booleanWrapper.value = false;
                                return;
                            }
                            IModuleData predecessor = AbstractNaturalOrderDragNDropSupport.this.determinePredecessor(targetData, location, targetSequencer);
                            booleanWrapper.value = AbstractNaturalOrderDragNDropSupport.this.reorderItems(itemsToReorder, predecessor, targetSequencer);
                            if (booleanWrapper.value) {
                                AbstractNaturalOrderDragNDropSupport.this.modelController.reorderedItems(itemsToReorder, targetParent);
                            }
                        }
                    });
                    if (booleanWrapper.value) {
                        PropertyChanges propertyChanges;
                        if (targetParent != null) {
                            propertyChanges = new PropertyChanges(null, (Object)targetParent, null);
                            AbstractNaturalOrderDragNDropSupport.this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)propertyChanges, targetParent.getClass());
                        } else {
                            propertyChanges = new PropertyChanges(null, (Object)targetData, null);
                            AbstractNaturalOrderDragNDropSupport.this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)propertyChanges, targetData.getClass());
                        }
                    }
                    return booleanWrapper.value;
                }
                MessageDialog mDialog = new MessageDialog(targetControl.getShell(), Messages.getString("ReorderingDragNDropSupport.ReorderingToTargetImpossible_Title"), null, Messages.getString("ReorderingDragNDropSupport.ReorderingToTargetImpossible_Message"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                return false;
            }
        };
        return dropHandler;
    }

    private String createReorderAnywayMessage(Collection<IModuleData> droppedItems, String reason) {
        boolean paneTooSmall;
        int maxItemsToBeWrittenOut = 5;
        String message = String.valueOf(Messages.getString("MoveDragNDropSupport.MoveAnywayProblem")) + reason;
        boolean bl = paneTooSmall = maxItemsToBeWrittenOut < droppedItems.size();
        if (paneTooSmall) {
            --maxItemsToBeWrittenOut;
        }
        Iterator<IModuleData> i = droppedItems.iterator();
        while (i.hasNext() && maxItemsToBeWrittenOut > 0) {
            IModuleData element = i.next();
            message = String.valueOf(message) + "\n" + element.getDisplayRepresentation();
        }
        if (paneTooSmall) {
            message = String.valueOf(message) + "\n...";
        }
        message = String.valueOf(message) + "\n" + Messages.getString("MoveDragNDropSupport.MoveAnywayQuestion");
        return message;
    }

    private boolean reorderItems(Collection<IModuleData> sourceData, IModuleData predecessor, ISequencer targetSequencer) {
        Iterator<IModuleData> i = sourceData.iterator();
        IModuleData firstItem = i.next();
        if (firstItem.equals(predecessor)) {
            return false;
        }
        if (predecessor != null) {
            targetSequencer.insertElement((ICockpitProjectData)firstItem, (ICockpitProjectData)predecessor);
        } else {
            targetSequencer.setFirstElement((ICockpitProjectData)firstItem);
        }
        IModuleData previousItem = firstItem;
        while (i.hasNext()) {
            IModuleData nextItem = i.next();
            targetSequencer.insertElement((ICockpitProjectData)nextItem, (ICockpitProjectData)previousItem);
            previousItem = nextItem;
        }
        return true;
    }

    private IModuleData determinePredecessor(IModuleData target, int location, ISequencer targetSequencer) {
        IModuleData predecessor = location == 1 ? (IModuleData)targetSequencer.getPredecessor((ICockpitProjectData)target) : (location == 2 ? target : null);
        return predecessor;
    }

    private boolean ensureChildrenOrder(IModuleData parent, String childDataType, ISequencer sequencer) {
        List<IModuleData> children = new ArrayList<IModuleData>(this.modelController.getChildren(parent, childDataType));
        children = this.dataView.applySorters(children);
        Iterator<IModuleData> childrenIterator = children.iterator();
        IModuleData currentElement = null;
        IModuleData lastElement = null;
        if (childrenIterator.hasNext()) {
            lastElement = childrenIterator.next();
            sequencer.setFirstElement((ICockpitProjectData)lastElement);
        }
        while (childrenIterator.hasNext()) {
            currentElement = childrenIterator.next();
            sequencer.insertElement((ICockpitProjectData)currentElement, (ICockpitProjectData)lastElement);
            lastElement = currentElement;
        }
        return true;
    }

    private int extractAppropriateOperations(int operations, int requestedOperation) {
        int appropriateOperations;
        if (requestedOperation == 16) {
            if ((operations & 0x10) != 0) {
                appropriateOperations = 2;
            } else {
                appropriateOperations = 0;
                if ((operations & 2) != 0) {
                    appropriateOperations |= 2;
                }
            }
        } else {
            appropriateOperations = (requestedOperation & 2) != 0 ? 2 : ((requestedOperation & 1) != 0 ? 1 : 0);
        }
        return appropriateOperations;
    }

    private TransferData extractRequiredDatatype(TransferData[] dataTypes) {
        TransferData[] transferDataArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (this.transfer.isSupportedType(dataType)) {
                return dataType;
            }
            ++n2;
        }
        return null;
    }

    protected abstract IProjectAgentProvider getProjectManager();

    protected abstract IModelControllerProvider getModelControllerProvider();

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return null;
    }

    public void projectSwitched(String projectUID) {
        this.modelController = this.getModelControllerProvider().getModelController(projectUID);
        if (this.modelController != null) {
            this.projectAgent = this.modelController.getProjectAgent();
            this.sequencerManager = ((IModuleProjectAgent)this.projectAgent).getSequencerManager();
        } else {
            this.projectAgent = null;
            this.sequencerManager = null;
        }
    }

    public String getActiveProject() {
        return this.modelController != null ? this.modelController.getProjectUID() : null;
    }

    private static class BooleanWrapper {
        boolean value;

        private BooleanWrapper() {
        }
    }

    private static class ModuleDataReorderingTransferContent {
        public String uid;
        public Collection<IModuleData> moduleData;
        public String dataType;
        public IModuleData parent;
        public boolean multipleParents;
        public int operation;

        public ModuleDataReorderingTransferContent(Collection<IModuleData> data, String dataType, IModuleData parent, boolean multipleParents) {
            this.moduleData = data;
            this.dataType = dataType;
            this.parent = parent;
            this.multipleParents = multipleParents;
            this.uid = UUIDGenerator.getUniqueID();
        }
    }
}

