/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dnd;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.project.editors.FMCAEditorDNDData;
import com.arcway.cockpit.frame.client.project.editors.IDropListener;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.planagent.controllinginterface.planeditor.FMCAEditorDNDCallbackTransfer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public abstract class AbstractEditorDragSupport
implements IModuleProjectSwitchListener,
IActiveProjectProvider {
    protected IModelController modelController;
    private static FMCAEditorDNDData dndData = null;

    public AbstractEditorDragSupport(IModelController modelController) {
        this.modelController = modelController;
    }

    public DragSource getDragSource() {
        return new DragSource(this.getDragOperations(), this.getTransfers(), this.getDragHandler(), this.getRequiredLicenseType(), this.getProjectManager(), (IActiveProjectProvider)this);
    }

    private int getDragOperations() {
        return 20;
    }

    private Set<Transfer> getTransfers() {
        return Collections.singleton(FMCAEditorDNDCallbackTransfer.getInstance());
    }

    private IDragHandler getDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){

            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                List selectedItems = ((IStructuredSelection)selection).toList();
                Collection linkableDataTypes = AbstractEditorDragSupport.this.getLinkableDataTypes();
                for (Object selectedObject : selectedItems) {
                    if (!(selectedObject instanceof IModuleData)) {
                        return false;
                    }
                    IModuleData selectedItem = (IModuleData)selectedObject;
                    if (!linkableDataTypes.contains(selectedItem.getTypeID())) {
                        return false;
                    }
                    if (AbstractEditorDragSupport.this.isLinkable(selectedItem)) continue;
                    return false;
                }
                dndData = new FMCAEditorDNDData(AbstractEditorDragSupport.this.getEditorDropListener(), AbstractEditorDragSupport.this.modelController.getProjectUID(), (Object)selectedItems);
                FMCAEditorDNDCallbackTransfer.getInstance().setData((Object)dndData);
                return true;
            }

            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                FMCAEditorDNDCallbackTransfer.getInstance().setData((Object)dndData);
                return dndData;
            }

            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                dndData = null;
                FMCAEditorDNDCallbackTransfer.getInstance().setData(null);
            }
        };
        return dragHandler;
    }

    protected boolean isLinkable(IModuleData item) {
        assert (item != null);
        return true;
    }

    protected abstract Collection getLinkableDataTypes();

    protected abstract IDropListener getEditorDropListener();

    protected abstract IProjectAgentProvider getProjectManager();

    protected abstract IModelControllerProvider getModelControllerProvider();

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return null;
    }

    public void projectSwitched(String projectUID) {
        this.modelController = this.getModelControllerProvider().getModelController(projectUID);
    }

    public String getActiveProject() {
        return this.modelController != null ? this.modelController.getProjectUID() : null;
    }
}

