/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard;

import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewHierarchy;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IUIDataTypesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class StandardTreeDataViewHierarchy
implements ITreeDataViewHierarchy {
    private final IModelControllerProvider modelControllerProvider;
    private final IDataTypesHelper dataTypesHelper;
    private final IUIDataTypesHelper uiDataTypesHelper;
    private final Collection<String> visibleTypeSubset;

    public StandardTreeDataViewHierarchy(IModelControllerProvider modelControllerProvider, IDataTypesHelper dataTypesHelper, IUIDataTypesHelper uiDataTypesHelper) {
        this(modelControllerProvider, dataTypesHelper, uiDataTypesHelper, null);
    }

    public StandardTreeDataViewHierarchy(IModelControllerProvider modelControllerProvider, IDataTypesHelper dataTypesHelper, IUIDataTypesHelper uiDataTypesHelper, Collection<String> visibleTypeSubset) {
        this.modelControllerProvider = modelControllerProvider;
        this.dataTypesHelper = dataTypesHelper;
        this.uiDataTypesHelper = uiDataTypesHelper;
        this.visibleTypeSubset = visibleTypeSubset;
    }

    public List<?> getRootItems(String projectUID) {
        if (projectUID == null) {
            return Collections.emptyList();
        }
        IModelController modelController = this.modelControllerProvider.getModelController(projectUID);
        ArrayList<IModuleData> rootItems = new ArrayList<IModuleData>();
        for (String typeID : this.dataTypesHelper.getRootDocumentationDataTypes()) {
            if (!this.uiDataTypesHelper.isToBeShownInDataView(typeID) || this.visibleTypeSubset != null && !this.visibleTypeSubset.contains(typeID)) continue;
            rootItems.addAll(modelController.getRootItems(typeID));
        }
        return rootItems;
    }

    public boolean itemExists(Object item, String projectUID) {
        assert (item instanceof IModuleData);
        IModuleData moduleDataItem = (IModuleData)item;
        IModelController modelController = this.modelControllerProvider.getModelController(projectUID);
        return modelController.itemExists(moduleDataItem.getTypeID(), moduleDataItem.getUID());
    }

    public boolean hasChildren(Object item, ViewerFilter[] filters, Viewer viewer, String projectUID) {
        Object[] childItems = this.getFilteredChildren(this.getChildren(item, filters, viewer, projectUID), filters, viewer, projectUID);
        return childItems.length > 0;
    }

    public List<?> getChildren(Object item, ViewerFilter[] filters, Viewer viewer, String projectUID) {
        assert (item instanceof IModuleData);
        IModuleData moduleDataItem = (IModuleData)item;
        IModelController modelController = this.modelControllerProvider.getModelController(projectUID);
        ArrayList<IModuleData> childItems = new ArrayList<IModuleData>();
        for (String typeID : this.dataTypesHelper.getChildTypeIDs(moduleDataItem.getTypeID())) {
            if (!this.uiDataTypesHelper.isToBeShownInDataView(typeID) || this.visibleTypeSubset != null && !this.visibleTypeSubset.contains(typeID)) continue;
            childItems.addAll(modelController.getChildren(moduleDataItem, typeID));
        }
        return childItems;
    }

    public List<?> getParents(Object item, String projectUID) {
        assert (item instanceof IModuleData);
        IModuleData moduleDataItem = (IModuleData)item;
        IModelController modelController = this.modelControllerProvider.getModelController(projectUID);
        IModuleData parent = modelController.getParent(moduleDataItem);
        if (parent != null) {
            return Collections.singletonList(parent);
        }
        return null;
    }

    protected final Object[] getFilteredChildren(Collection<?> childItems, ViewerFilter[] filters, Viewer viewer, String projectUID) {
        Object[] childItems_asObjects = childItems.toArray(new Object[childItems.size()]);
        if (filters != null) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                childItems_asObjects = filter.filter(viewer, childItems, childItems_asObjects);
                ++n2;
            }
        }
        return childItems_asObjects;
    }
}

