/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataView;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeBoolean;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationSingle;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.ChangeValueActionMenuManager;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForCustomProperties;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.IDiscreteAttributeHandler;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.java.collectionmaps.ListMap;
import de.plans.lib.util.incrementalsearch.ISearchCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public abstract class StandardTreeDataView
extends CockpitTreeDataView<IModuleData> {
    private StandardTreeDataViewProvider dataViewProvider;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    protected void callbackAfterExchangeOfViewer(String oldProjectUID, String newProjectUID) {
        super.callbackAfterExchangeOfViewer(oldProjectUID, newProjectUID);
        ChangeValueActionMenuManager changeValueActionMenuManager = this.dataViewProvider.getChangeValueActionMenuManager();
        changeValueActionMenuManager.setConfiguration(this.retrieveDiscreteAttributeHandlers(), this.getSelectionProvider(), this.dataViewProvider.getRequiredLicenseTypeForChangeValueActions(), this.getSite().getShell());
    }

    protected boolean isPropertyChangeRequiringExchangeOfViewer(IPropertyChanges<?> changes, Class<?> clazz) {
        if (IAttributeType.class.isAssignableFrom(clazz)) {
            HashSet customProperties = new HashSet(changes.getCreatedElements());
            customProperties.addAll(changes.getDeletedElements());
            customProperties.addAll(changes.getModifiedElements());
            Collection<String> allCustomPropertyDataTypes = this.dataViewProvider.getDataTypesHelper().getDocumentationCustomPropertyDataTypes();
            for (Object attributeTypeObject : customProperties) {
                IAttributeType attributeType = (IAttributeType)attributeTypeObject;
                if (!allCustomPropertyDataTypes.contains(attributeType.getCockpitDataType().getCockpitDataTypeID())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isPropertyChangeOfDisplayedItems(IPropertyChanges<?> changes, Class<?> clazz) {
        String dataTypeID;
        return IModuleData.class.isAssignableFrom(clazz) && (dataTypeID = this.getDataTypeIDForPropertyChanges(changes)) != null && this.getModelController().getDataTypesHelper().getDocumentationDataTypes().contains(dataTypeID) && this.getModelController().getUIDataTypesHelper().isToBeShownInDataView(dataTypeID);
    }

    private String getDataTypeIDForPropertyChanges(IPropertyChanges<?> propertyChanges) {
        IModuleData anyItem = null;
        if (propertyChanges.getCreatedElements() != null && !propertyChanges.getCreatedElements().isEmpty()) {
            anyItem = (IModuleData)propertyChanges.getCreatedElements().iterator().next();
        }
        if (propertyChanges.getModifiedElements() != null && !propertyChanges.getModifiedElements().isEmpty()) {
            anyItem = (IModuleData)propertyChanges.getModifiedElements().iterator().next();
        }
        if (propertyChanges.getDeletedElements() != null && !propertyChanges.getDeletedElements().isEmpty()) {
            anyItem = (IModuleData)propertyChanges.getDeletedElements().iterator().next();
        }
        if (anyItem != null) {
            return anyItem.getTypeID();
        }
        return null;
    }

    protected IStructuredSelection sortOutSelection(IStructuredSelection selection) {
        IModelController modelController = this.getModelController();
        if (modelController != null) {
            List selectionList = selection.toList();
            List<IModuleData> filteredList = modelController.filterSelection(selectionList);
            StructuredSelection filteredSelection = new StructuredSelection(filteredList);
            return filteredSelection;
        }
        return StructuredSelection.EMPTY;
    }

    protected Collection<?> getAllRelevantItemsForSearch(String newProjectUID) {
        return this.getModelController(newProjectUID).getAllVisibleItems();
    }

    protected Collection<?> postProcessSearchResult(Collection<?> searchResult) {
        if (searchResult != ISearchCallback.SEARCH_RESULT_ALL) {
            IModelController modelController = this.getModelController();
            if (modelController != null) {
                HashSet<? extends IModuleData> completedSearchResult = new HashSet<IModuleData>();
                for (Object filteredItem : searchResult) {
                    IModuleData filteredModuleDataItem;
                    if (!(filteredItem instanceof IModuleData) || !modelController.itemExists((filteredModuleDataItem = (IModuleData)filteredItem).getTypeID(), filteredModuleDataItem.getUID())) continue;
                    completedSearchResult.add(filteredModuleDataItem);
                    completedSearchResult.addAll(modelController.getAllAscendants(filteredModuleDataItem));
                }
                return completedSearchResult;
            }
            return Collections.emptySet();
        }
        return ISearchCallback.SEARCH_RESULT_ALL;
    }

    public void callbackAfterRefreshOfViewer() {
        super.callbackAfterRefreshOfViewer();
        if (this.getCurrentlyAssociatedProject() != null) {
            IProjectionMgr projectionManager = this.getModelController().getProjectionManager();
            if (projectionManager != null) {
                projectionManager.updateProjections(null);
            }
            ProjectMgr.getProjectMgr().getProjectAgent(this.getCurrentlyAssociatedProject()).getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)new PropertyChanges(null, null, null), IFilterItem.class);
        }
    }

    protected final CockpitTreeDataViewProvider<IModuleData> createCockpitTreeDataViewProvider() {
        this.dataViewProvider = this.createStandardTreeDataViewProvider();
        return this.dataViewProvider;
    }

    protected abstract StandardTreeDataViewProvider createStandardTreeDataViewProvider();

    private IModelController getModelController() {
        return this.getModelController(this.getCurrentlyAssociatedProject());
    }

    private final IModelController getModelController(String projectUID) {
        if (projectUID != null) {
            return this.dataViewProvider.getProjectAssociationManager().getModelController(projectUID);
        }
        return null;
    }

    private List<IDiscreteAttributeHandler> retrieveDiscreteAttributeHandlers() {
        ListMap attributeHandlers = new ListMap();
        attributeHandlers.addAll(this.dataViewProvider.getDiscreteAttributeHandlers());
        attributeHandlers.addAll(this.getAttributeHandlersForCustomProperties());
        ArrayList<IDiscreteAttributeHandler> attributeHandlerList = new ArrayList<IDiscreteAttributeHandler>();
        for (String dataTypeID : this.dataViewProvider.getDataTypesHelper().getDocumentationDataTypes()) {
            for (IDiscreteAttributeHandler handler : attributeHandlers.get((Object)dataTypeID)) {
                attributeHandlerList.add(handler);
            }
        }
        return attributeHandlerList;
    }

    private ListMap<String, IDiscreteAttributeHandler> getAttributeHandlersForCustomProperties() {
        if (this.getModelController() != null) {
            ListMap custumPropertyAttributeHandlers = new ListMap();
            IModuleUserDefinedAttributeTypesManager customPropertiesManager = this.getModelController().getProjectAgent().getModuleUserDefinedAttributeTypesManager();
            for (String dataTypeID : this.dataViewProvider.getDataTypesHelper().getDocumentationCustomPropertyDataTypes()) {
                for (IAttributeType attributeType : customPropertiesManager.getSortedAttributeTypes(dataTypeID)) {
                    if (!(attributeType.getDataType() instanceof DataTypeBoolean) && !(attributeType.getDataType() instanceof DataTypeEnumerationSingle)) continue;
                    custumPropertyAttributeHandlers.add((Object)dataTypeID, (Object)new AttributeHandlerForCustomProperties((IModuleProjectSwitchListenerManager)this, (IModelControllerProvider)this.dataViewProvider.getProjectAssociationManager(), attributeType, dataTypeID, true));
                }
            }
            return custumPropertyAttributeHandlers;
        }
        return new ListMap();
    }
}

