/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes;

import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.ModuleLib2Plugin;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.IDiscreteAttributeHandler;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class DiscreteValueAction
extends Action {
    private final IDiscreteAttributeHandler handler;
    private final int index;
    private final DiscreteValue value;
    private final Shell shell;
    private final IStructuredSelection selection;

    public DiscreteValueAction(IDiscreteAttributeHandler handler, int index, DiscreteValue value, String projectLanguage, boolean isCurrentValue, Shell shell, IStructuredSelection selection, boolean licenseAvailable) {
        assert (handler != null) : "handler must not be null";
        this.handler = handler;
        this.index = index;
        this.value = value;
        this.shell = shell;
        this.selection = selection;
        this.setText(value.getName(new Locale(projectLanguage)));
        if (licenseAvailable) {
            this.setImageDescriptor(value.getImage());
        } else if (value.getImage() != null) {
            DecoratedImageDescriptor decoratedImage = new DecoratedImageDescriptor(value.getImage());
            ImageDescriptor decorator = ModuleLib2Plugin.getImageDescriptor("license_restriction.gif");
            decoratedImage.addDecorator(decorator, 3);
            this.setImageDescriptor((ImageDescriptor)decoratedImage);
        } else {
            this.setImageDescriptor(ModuleLib2Plugin.getImageDescriptor("license_restriction_16x16.gif"));
        }
        this.setEnabled(licenseAvailable);
        this.setChecked(isCurrentValue);
    }

    public void run() {
        for (Object element : this.selection.toList()) {
            IStatus canChange = this.handler.canChangeValue(element, this.index);
            if (canChange.isOK()) continue;
            MessageDialog.openConfirm((Shell)this.shell, (String)Messages.getString("DiscreteValueAction.ErrMsgTitle"), (String)canChange.getMessage());
            return;
        }
        this.handler.changeMultipleValues(new Runnable(){

            @Override
            public void run() {
                for (Object element : DiscreteValueAction.this.selection.toList()) {
                    DiscreteValueAction.this.handler.changeValue(element, DiscreteValueAction.this.index, DiscreteValueAction.this.value);
                }
            }
        });
    }
}

