/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes;

import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AbstractModuleAttributeHandler;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.DiscreteValueWithObject;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.DisplayRepresentationComparator;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.localisation.LabelProviderUnlocalisedString;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public abstract class AttributeHandlerForLinkedModuleDataAttributes
extends AbstractModuleAttributeHandler {
    private final ILinkType linkType;
    private final Comparator<IModuleData> comparator;
    private final boolean allowEmptyAttributeValue;
    private List<DiscreteValueWithObject> lastReturnedValueRange = null;
    public static final Comparator<IModuleData> DISPLAY_REPRESENTATION_COMPARATOR = new DisplayRepresentationComparator();

    public AttributeHandlerForLinkedModuleDataAttributes(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, String attributeTypeID, String attributeName, String dataTypeID, ILinkType linkType, Comparator<IModuleData> comparator, boolean allowEmptyAttributeValue) {
        this(projectSwitchListenerManager, modelControllerProvider, attributeTypeID, attributeName, dataTypeID, linkType, comparator, allowEmptyAttributeValue, true);
    }

    public AttributeHandlerForLinkedModuleDataAttributes(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, String attributeTypeID, String attributeName, String dataTypeID, ILinkType linkType, Comparator<IModuleData> comparator, boolean allowEmptyAttributeValue, boolean checkPermission) {
        super(projectSwitchListenerManager, modelControllerProvider, attributeTypeID, attributeName, dataTypeID, checkPermission);
        this.linkType = linkType;
        this.allowEmptyAttributeValue = allowEmptyAttributeValue;
        this.comparator = comparator;
    }

    @Override
    public void changeValue(final Object domainItem, int index, final DiscreteValue value) {
        final IModelController modelCtrl = this.getModelController();
        modelCtrl.executeTransaction(new Runnable(){

            @Override
            public void run() {
                IModuleData newValue;
                Set<? extends EOLink> currentLinks = modelCtrl.getLinksForModuleDataItem((IModuleData)domainItem, AttributeHandlerForLinkedModuleDataAttributes.this.linkType.getUID());
                if (!currentLinks.isEmpty()) {
                    if (!$assertionsDisabled && currentLinks.size() != 1) {
                        throw new AssertionError();
                    }
                    AttributeHandlerForLinkedModuleDataAttributes.this.getModelController().deleteLink((EOLink)currentLinks.iterator().next());
                }
                if ((newValue = ((DiscreteValueWithObject)value).getLinkedObject()) != null && modelCtrl.itemExists(newValue.getTypeID(), newValue.getUID())) {
                    modelCtrl.createLink(newValue.getUID(), (IModuleData)domainItem, AttributeHandlerForLinkedModuleDataAttributes.this.linkType.getUID());
                }
                modelCtrl.itemPropertiesModified((IModuleData)domainItem, null);
            }
        });
    }

    @Override
    public List<? extends DiscreteValue> getValueRange() {
        IModelController modelController = this.getModelController();
        if (modelController != null) {
            ArrayList<? extends IModuleData> objects = new ArrayList<IModuleData>(this.getModelController().getAllItems(this.linkType.getLinkableObjectTypeID()));
            if (this.comparator != null) {
                Collections.sort(objects, this.comparator);
            }
            ArrayList<DiscreteValueWithObject> valueRange = new ArrayList<DiscreteValueWithObject>(objects.size() + 1);
            if (this.allowEmptyAttributeValue) {
                valueRange.add(new DiscreteValueWithObject((ILabelProvider)new LabelProviderUnlocalisedString(""), null));
            }
            for (IModuleData iModuleData : objects) {
                valueRange.add(new DiscreteValueWithObject((ILabelProvider)new LabelProviderUnlocalisedString(this.getText(iModuleData)), this.getImage(iModuleData), iModuleData));
            }
            this.lastReturnedValueRange = valueRange;
            return valueRange;
        }
        this.lastReturnedValueRange = Collections.emptyList();
        return Collections.emptyList();
    }

    @Override
    public int getCurrentValueIndex(Object item) {
        assert (item instanceof IModuleData);
        if (!(item instanceof IModuleData)) {
            return -1;
        }
        if (this.lastReturnedValueRange == null) {
            return -1;
        }
        Set<? extends EOLink> currentLinks = this.getModelController().getLinksForModuleDataItem((IModuleData)item, this.linkType.getUID());
        if (!currentLinks.isEmpty()) {
            String linkedAttributeItemUID = ((EOLink)currentLinks.iterator().next()).getLinkableObjectUID();
            int index = 0;
            for (DiscreteValueWithObject value : this.lastReturnedValueRange) {
                IModuleData linkedAttributeItemAtIndex = value.getLinkedObject();
                if (linkedAttributeItemAtIndex != null && linkedAttributeItemAtIndex.getUID().equals(linkedAttributeItemUID)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
        return this.allowEmptyAttributeValue ? 0 : -1;
    }

    protected abstract String getText(IModuleData var1);

    protected abstract IIconResource getImage(IModuleData var1);
}

