/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui;

import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.IDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractCopyManager;
import com.arcway.cockpit.modulelib2.client.messages.transfer.EOTemporaryFileForCopyAndPaste;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class CustomPropertyTempFileStore {
    private final Map<EOTemporaryFileForCopyAndPaste, EOTemporaryFileForCopyAndPaste> tempFilesForFileCustomProperties = new HashMap<EOTemporaryFileForCopyAndPaste, EOTemporaryFileForCopyAndPaste>();

    public EOTemporaryFileForCopyAndPaste copyCustomPropertyToTempFileStore(FileID fileDescriptor, IDataTypeWithFile fileCustomPropertyTypeDataType, IModelController modelController) {
        String loggerMessage = "Couldn't create temporary copy of custom property file to be copied.";
        FileMetaInformationItem metaInformation = ((ProjectAgent)modelController.getProjectAgent()).getFilesManager().getFileMetaInformation(fileDescriptor);
        EOTemporaryFileForCopyAndPaste tempFileDescriptor = new EOTemporaryFileForCopyAndPaste(modelController.getProjectUID(), fileDescriptor.getFileUID(), metaInformation.getOriginalFileName());
        try {
            IModuleProjectAgent projectAgent = modelController.getProjectAgent();
            if (projectAgent != null && projectAgent.isOpened() && !this.tempFilesForFileCustomProperties.containsKey((Object)tempFileDescriptor)) {
                File tempFile = fileCustomPropertyTypeDataType.getFileCopy((Object)fileDescriptor);
                tempFileDescriptor.setTemporaryFile(tempFile.getAbsolutePath());
                this.tempFilesForFileCustomProperties.put(tempFileDescriptor, tempFileDescriptor);
            }
        }
        catch (ServerNotAvailableException e) {
            AbstractCopyManager.logger.warn("Couldn't create temporary copy of custom property file to be copied.");
        }
        catch (EXServerException e) {
            AbstractCopyManager.logger.warn("Couldn't create temporary copy of custom property file to be copied.");
        }
        catch (LoginCanceledException e) {
            AbstractCopyManager.logger.info("User cancelled login.", (Throwable)e);
        }
        catch (UnknownServerException e) {
            AbstractCopyManager.logger.warn("Couldn't create temporary copy of custom property file to be copied.");
        }
        catch (ExPrematureEndOfTransfer e) {
            AbstractCopyManager.logger.warn("Couldn't create temporary copy of custom property file to be copied.");
        }
        tempFileDescriptor = this.tempFilesForFileCustomProperties.get((Object)tempFileDescriptor);
        return tempFileDescriptor;
    }
}

