/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.CreateCustomPropertyDialog;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.EditCustomPropertyValueRangeDialogue;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.EnumValueReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.ExistingAttributeReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.IListManagementDialogueCreator;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.TargetAttributeDescription;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeAndEnumerationValueCreator;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription_forEnumValueMapping;
import com.arcway.lib.java.collections.ICollection_;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Shell;

public class TargetAttributeAndEnumerationValueCreator
implements ITargetAttributeAndEnumerationValueCreator<String, ExistingAttributeReference, Integer, EnumValueReference> {
    private final IModelController modelController;
    private final IModuleDataTypeDescription dataType;
    private final IListManagementDialogueCreator listManagementDialogueCreator;

    public TargetAttributeAndEnumerationValueCreator(IModelController modelController, IModuleDataTypeDescription dataType, IListManagementDialogueCreator listManagementDialogueCreator) {
        this.modelController = modelController;
        this.dataType = dataType;
        this.listManagementDialogueCreator = listManagementDialogueCreator;
    }

    public boolean hasAttributeCreationPermission() {
        ModuleDataTypeDescriptionForFrame cockpitDataType;
        IModuleUserDefinedAttributeTypesManager typesManager = this.modelController.getProjectAgent().getModuleUserDefinedAttributeTypesManager();
        return typesManager.checkAttributeTypesModificationPermission((ICockpitDataType)(cockpitDataType = this.dataType.getModuleDataTypeDescriptionForFrame())) == null;
    }

    public boolean canCreateTargetAttributeForDataTypes(ICollection_<Integer> targetDataTypes) {
        return !this.getPossibleCustomPropertyDataTypes(targetDataTypes).isEmpty();
    }

    public ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference> createTargetAttributeForDataTypes(ICollection_<Integer> targetDataTypes, Shell shell) {
        IAttributeType newAttributeType;
        TargetAttributeDescription newTargetAttribute = null;
        CreateCustomPropertyDialog customPropertyDialog = new CreateCustomPropertyDialog(this.dataType.getModuleDataTypeDescriptionForFrame(), this.getPossibleCustomPropertyDataTypes(targetDataTypes), this.modelController.getProjectAgent(), shell);
        if (customPropertyDialog.open() == 0 && (newAttributeType = customPropertyDialog.getNewAttribute()) != null) {
            IAttributeTypeDataType newAttributeDataType = newAttributeType.getDataType();
            newTargetAttribute = new TargetAttributeDescription(new ExistingAttributeReference(newAttributeType.getAttributeTypeID().getUID(), 2, newAttributeType), TargetAttributeDescription.getExistingAttributeDataTypeIDForCustomPropertyDataType(newAttributeDataType), false, newAttributeType.getDisplayName());
        }
        return newTargetAttribute;
    }

    private List<IAttributeTypeDataType> getPossibleCustomPropertyDataTypes(ICollection_<Integer> targetDataTypes) {
        HashSet<IAttributeTypeDataType> possibleCustomPropertyDataTypes = new HashSet<IAttributeTypeDataType>();
        for (Integer existingAttributeDataTypeID : targetDataTypes) {
            possibleCustomPropertyDataTypes.addAll(TargetAttributeDescription.getCustomPropertyDataTypesForExistingAttributeDataTypeID(existingAttributeDataTypeID));
        }
        ArrayList<IAttributeTypeDataType> possibleCustomPropertyDataTypes_sorted = new ArrayList<IAttributeTypeDataType>(possibleCustomPropertyDataTypes);
        Collections.sort(possibleCustomPropertyDataTypes_sorted, new Comparator<IAttributeTypeDataType>(){

            @Override
            public int compare(IAttributeTypeDataType o1, IAttributeTypeDataType o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
        return possibleCustomPropertyDataTypes_sorted;
    }

    public boolean createNewEnumValue(ITargetAttributeDescription_forEnumValueMapping<EnumValueReference> targetAttribute_, Shell shell) {
        TargetAttributeDescription targetAttribute = (TargetAttributeDescription)targetAttribute_;
        int enumType = targetAttribute.getEnumerationType();
        TitleAreaDialog dialogue = null;
        if (enumType == 1) {
            dialogue = this.listManagementDialogueCreator.createListManagementDialogue(targetAttribute.getKey().getLinkedModuleDataDataTypeID(), this.modelController, shell);
        } else if (enumType == 2) {
            dialogue = new EditCustomPropertyValueRangeDialogue(targetAttribute.getKey().getAttributeType(), this.modelController.getProjectAgent().getModuleUserDefinedAttributeTypesManager(), this.modelController, shell);
        } else {
            assert (false);
            return false;
        }
        return dialogue.open() == 0;
    }
}

