/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.MappableDataPotDescription;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.AttributeMappingPageSettings;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.AttributeMappingPersistencyHelper;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.EnumValueReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.ExistingAttributeReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.IListManagementDialogueCreator;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.SourceAttributeDescription;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.TargetAttributeAndEnumerationValueCreator;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.TargetAttributeDescription;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.AttributeMappingWidget;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingChangedListener;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingPersistencyHelper;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingWidgetSettings;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeAndEnumerationValueCreator;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.memento.ArcwayMementoHelper;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AttributeMappingPage
extends WizardPage {
    private static final String PAGE_TITLE = Messages.getString("AttributeMappingPage.title");
    private static final String PAGE_INSTRUCTION_PREFIX = Messages.getString("AttributeMappingPage.instruction");
    private static final String MEMENTO_ID_ROOT = "com.arcway.cockpit.modulelib2";
    private static final List<String> NON_MAPPABLE_EXISTING_ATTRIBUTES = new LinkedList<String>(AbstractModuleData.ADMINISTRATIVE_MODULE_DATA_ATTRIBUTES);
    private final String pageID;
    private final IModuleDataTypeDescription dataType;
    private final IModelController modelController;
    private final String description;
    private final AttributeMappingWidget<Object, String, String, ExistingAttributeReference, Integer, EnumValueReference> attributeMappingWidget;

    public AttributeMappingPage(String pageID, IModuleDataTypeDescription dataType, List<MappableDataPotDescription> mappableDataPots, IMap_<String, ISet_<Integer>> allowedMappings_, IMap_<String, IMap_<Integer, String>> warningsForMappings, boolean mustMapAllDataPots, IModelController modelController, IListManagementDialogueCreator listManagementDialogueCreator) {
        super("attributemappingpage-" + dataType.getTypeID(), PAGE_TITLE, null);
        this.pageID = pageID;
        this.dataType = dataType;
        this.modelController = modelController;
        String datatypeName = dataType.getTypeName(Locale.getDefault());
        this.description = String.valueOf(PAGE_INSTRUCTION_PREFIX) + datatypeName;
        this.setDescription(this.description);
        ArrayList_ sourceAttributeDescriptions = new ArrayList_(mappableDataPots.size());
        for (MappableDataPotDescription dataPot : mappableDataPots) {
            sourceAttributeDescriptions.add((Object)new SourceAttributeDescription(dataPot));
        }
        ArrayList_ existingAttributes = new ArrayList_();
        this.retrieveExistingAttributes(dataType, modelController.getProjectAgent(), (IListRW_<ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference>>)existingAttributes);
        IArcwayMemento configurationsMemento = modelController.getProjectAgent().getLocalSettings(MEMENTO_ID_ROOT);
        IArcwayMemento configurationForPage = configurationsMemento.getChild(pageID);
        AttributeMappingPersistencyHelper persistenyHelper = new AttributeMappingPersistencyHelper(modelController.getPlatformAccessAgent());
        IAttributeMappingChangedListener changeListener = new IAttributeMappingChangedListener(){

            public void attributeMappingChanged() {
                AttributeMappingPage.this.updateCompletionStatusAndErrorMessage();
            }
        };
        HashMap_ allowedMappings = new HashMap_(allowedMappings_, IHasher_.EQUALS_HASHER);
        AttributeMappingPageSettings settings = new AttributeMappingPageSettings(dataType, (IMap_<String, ISet_<Integer>>)allowedMappings, warningsForMappings, mustMapAllDataPots);
        TargetAttributeAndEnumerationValueCreator targetAttributeAndEnumerationValueCreator = new TargetAttributeAndEnumerationValueCreator(modelController, dataType, listManagementDialogueCreator);
        this.attributeMappingWidget = new AttributeMappingWidget((IList_)sourceAttributeDescriptions, (IList_)existingAttributes, configurationForPage, (IAttributeMappingPersistencyHelper)persistenyHelper, changeListener, (IAttributeMappingWidgetSettings)settings, (ITargetAttributeAndEnumerationValueCreator)targetAttributeAndEnumerationValueCreator);
    }

    private void retrieveExistingAttributes(IModuleDataTypeDescription dataType_, IModuleProjectAgent projectAgent, IListRW_<ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference>> existingAttributes_) {
        existingAttributes_.add((Object)new TargetAttributeDescription(new ExistingAttributeReference(3, dataType_.getTypeID(), this.modelController), 10, false, ObjectTypeCategoryLabels.LABEL_CATEGORY));
        IModuleData dummyInstance = dataType_.getNewInstance();
        for (String simpleAttributeID : dataType_.getSimpleAttributeIDs()) {
            IModuleDataAttribute attribute;
            int dataTypeID;
            if (NON_MAPPABLE_EXISTING_ATTRIBUTES.contains(simpleAttributeID) || (dataTypeID = TargetAttributeDescription.getExistingAttributeDataTypeIDForModuleDataAttribute(attribute = dummyInstance.getAttribute(simpleAttributeID))) == -1) continue;
            existingAttributes_.add((Object)new TargetAttributeDescription(new ExistingAttributeReference(simpleAttributeID, (Integer)1, attribute, this.modelController.getProjectLanguage()), dataTypeID, dataType_.isMandatoryAttribute(simpleAttributeID) && !simpleAttributeID.equals(dataType_.getIDAttribute()) && dataTypeID != 10, dataType_.getAttributeName(simpleAttributeID)));
        }
        for (String linkedAttributeID : dataType_.getLinkedModuleDataAttributeIDs()) {
            existingAttributes_.add((Object)new TargetAttributeDescription(new ExistingAttributeReference(linkedAttributeID, (Integer)1, this.dataType.getModuleDataTypeIDForLinkedModuleDataAttribute(linkedAttributeID), this.modelController), 9, dataType_.isMandatoryAttribute(linkedAttributeID), dataType_.getAttributeName(linkedAttributeID)));
        }
        for (String linkedAttributeID : dataType_.getLinkedFrameDataAttributeIDs()) {
            existingAttributes_.add((Object)new TargetAttributeDescription(new ExistingAttributeReference(linkedAttributeID, (Integer)1, this.dataType.getFrameDataTypeIDForLinkedFrameDataAttribute(linkedAttributeID), this.modelController.getPlatformAccessAgent()), 12, dataType_.isMandatoryAttribute(linkedAttributeID), dataType_.getAttributeName(linkedAttributeID)));
        }
        for (IAttributeType attributeType : projectAgent.getModuleUserDefinedAttributeTypesManager().getAttributeTypesForModuleData(dataType_.getTypeID())) {
            int dataTypeID = TargetAttributeDescription.getExistingAttributeDataTypeIDForCustomPropertyDataType(attributeType.getDataType());
            if (dataTypeID == -1) continue;
            existingAttributes_.add((Object)new TargetAttributeDescription(new ExistingAttributeReference(attributeType.getAttributeTypeID().getUID(), 2, attributeType), dataTypeID, false, attributeType.getDisplayName()));
        }
        Collections.sort(existingAttributes_.asJavaList(), new Comparator<ITargetAttributeDescription<?, ?, ?>>(){

            @Override
            public int compare(ITargetAttributeDescription<?, ?, ?> o1, ITargetAttributeDescription<?, ?, ?> o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    public void createControl(Composite parent) {
        Composite marginComposite = new Composite(parent, 0);
        GridLayout marginLayout = new GridLayout();
        marginLayout.marginTop = 5;
        marginLayout.marginBottom = 5;
        marginLayout.marginLeft = 5;
        marginLayout.marginRight = 5;
        marginComposite.setLayout((Layout)marginLayout);
        this.attributeMappingWidget.createControl(marginComposite);
        this.setControl((Control)marginComposite);
        this.updateCompletionStatusAndErrorMessage();
    }

    public boolean isPageComplete() {
        return (Boolean)this.attributeMappingWidget.isAttributeMappingComplete().getComponent1();
    }

    public void performFinish() {
        IArcwayMemento configurationsStore = this.modelController.getProjectAgent().getLocalSettings(MEMENTO_ID_ROOT);
        IArcwayMemento configurationForPage = ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)configurationsStore, (String)this.pageID);
        this.attributeMappingWidget.save(configurationForPage);
    }

    private void updateCompletionStatusAndErrorMessage() {
        ThreeTuple completionStatusAndErrorMessage = this.attributeMappingWidget.isAttributeMappingComplete();
        this.setPageComplete((Boolean)completionStatusAndErrorMessage.getComponent1());
        this.setErrorMessage((String)completionStatusAndErrorMessage.getComponent2());
        this.setMessage((String)completionStatusAndErrorMessage.getComponent3(), 2);
    }

    public IMap_<Object, ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference>> getAttributeMapping() {
        return this.attributeMappingWidget.getAttributeMapping();
    }

    public IMap_<Object, EnumValueMapping<String, EnumValueReference>> getEnumerationMappings() {
        return this.attributeMappingWidget.getEnumerationMappings();
    }
}

