/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project.permissions;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IDataFacade;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleFacade;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.PermissionOperationDescription;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProvider;

public abstract class AbstractPermissionTemplateProvider
implements IProjectPermissionsGroup {
    protected final IDataTypesHelper dataTypesHelper;

    public AbstractPermissionTemplateProvider(IDataTypesHelper dataTypesHelper_) {
        this.dataTypesHelper = dataTypesHelper_;
    }

    public abstract Collection<ModulePermissionTemplate> getTemplates(IFrameProjectAgent var1);

    public IPermissionTemplateCategory getCategory(IFrameProjectAgent projectAgent, CockpitPermissionTemplate template) {
        return new IPermissionTemplateCategory(){

            public String getID() {
                return "module.IMPLEMENT_ME";
            }

            public String getDisplayName() {
                return "Implement me!!";
            }
        };
    }

    public int getPositionInDialog() {
        return 99;
    }

    public boolean definesAttributePermissionsFor(ICockpitDataType dataType) {
        return this.dataTypesHelper.getAllTrueDataTypes().contains(dataType.getCockpitDataTypeID());
    }

    protected static Collection<ModulePermissionTemplate> getAttributeModificationTemplates(IModuleProjectAgent projectAgent, ModuleDataTypeDescriptionForFrame moduleDataType, String permissionOperandTypeID) {
        ArrayList<ModulePermissionTemplate> templates = new ArrayList<ModulePermissionTemplate>();
        Collection<String> fixedAttributeTypesWithDefaultpermission = moduleDataType.getAllPermissionRelevantFixedAttributeTypesWithDefaultPermission(projectAgent.getProjectUID());
        for (String attributeTypeID : fixedAttributeTypesWithDefaultpermission) {
            Object template = new ModulePermissionTemplate((CockpitPermissionTemplate)projectAgent.getModuleUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeTypeID, (IModuleDataTypeDescriptionForFrame)moduleDataType, permissionOperandTypeID), Arrays.asList(new PermissionOperationDescription("ModifyAttribute", AbstractPermissionMgr.createOperationsAffectedItemIDForAttribute(moduleDataType.getCockpitDataTypeID(), attributeTypeID))));
            templates.add((ModulePermissionTemplate)((Object)template));
        }
        Collection<String> fixedAttributeTypesWithoutDefaultpermission = moduleDataType.getAllPermissionRelevantFixedAttributeTypesWithoutDefaultPermission(projectAgent.getProjectUID());
        for (String attributeTypeID : fixedAttributeTypesWithoutDefaultpermission) {
            ModulePermissionTemplate template = new ModulePermissionTemplate((CockpitPermissionTemplate)projectAgent.getModuleUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeTypeID, (IModuleDataTypeDescriptionForFrame)moduleDataType, permissionOperandTypeID), Arrays.asList(new PermissionOperationDescription("ModifyAttribute", AbstractPermissionMgr.createOperationsAffectedItemIDForAttribute(moduleDataType.getCockpitDataTypeID(), attributeTypeID))));
            template.setGrantByDefault(false);
            templates.add(template);
        }
        List customAttributeTypes = projectAgent.getModuleUserDefinedAttributeTypesManager().getSortedAttributeTypes(moduleDataType.getCockpitDataTypeID());
        for (IAttributeType attributeType : customAttributeTypes) {
            ModulePermissionTemplate template = new ModulePermissionTemplate((CockpitPermissionTemplate)projectAgent.getModuleUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeType, permissionOperandTypeID), Arrays.asList(new PermissionOperationDescription("ModifyAttribute", AbstractPermissionMgr.createOperationsAffectedItemIDForAttribute(moduleDataType.getCockpitDataTypeID(), attributeType.getAttributeTypeID().getUID()))));
            templates.add(template);
        }
        return templates;
    }

    protected static abstract class AbstractTemplateLabelProvider
    implements ILabelProvider {
        private final IFrameProjectAgent projectAgent;
        private final IDataTypesHelper dataTypesHelper;

        public AbstractTemplateLabelProvider(IFrameProjectAgent p_projectAgent, IDataTypesHelper p_dataTypesHelper) {
            this.projectAgent = p_projectAgent;
            this.dataTypesHelper = p_dataTypesHelper;
        }

        protected String getAttributePermissionTemplateLabel(AttributeModificationPermissionTemplate template) {
            IAttributeType attributeType = this.projectAgent.getModuleUserDefinedAttributeTypesManager().getUserDefinedAttributeType(template.getAttributeTypeID());
            if (attributeType != null) {
                String name = attributeType.getDisplayName();
                IModuleDataTypeDescription typeDescription = this.dataTypesHelper.getTypeDescription(template.getCockpitDataTypeID());
                name = "\"" + name + "\"" + Messages.getString("AbstractPermissionTemplateProvider.of") + typeDescription.getTypeName(Locale.getDefault());
                return name;
            }
            return null;
        }
    }

    protected static abstract class AbstractTreeContentProvider
    implements IPermissionOperandTreeContentProvider {
        private final IModuleProjectAgent projectAgent;
        private final String fullModuleID;
        private IModelController modelController;

        public AbstractTreeContentProvider(IModuleProjectAgent p_projectAgent, String p_fullModuleID) {
            this.projectAgent = p_projectAgent;
            this.fullModuleID = p_fullModuleID;
            this.modelController = null;
        }

        protected IModelController getModelController() {
            if (this.modelController == null) {
                ModuleFacade moduleFacade = (ModuleFacade)this.projectAgent.getModuleController().getModule(this.fullModuleID);
                IDataFacade dataFacade = (IDataFacade)moduleFacade.getModuleDataFacade();
                this.modelController = dataFacade.getModelController();
            }
            return this.modelController;
        }

        protected IModuleProjectAgent getProjectAgent() {
            return this.projectAgent;
        }
    }
}

