/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.client.base.datamanager.IDataHandler_DataWithID;
import com.arcway.cockpit.client.base.datamanager.IObjectKey;
import com.arcway.cockpit.client.base.datamanager.Key_UID;
import com.arcway.cockpit.frame.shared.message.IncompatibleDataTypeException;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class DataHandler_ModuleData
implements IDataHandler_DataWithID<IModuleData, String, String, String, EOModuleData> {
    private static final ILogger LOGGER = Logger.getLogger(DataHandler_ModuleData.class);
    private final String projectUID;
    private final IClientDataFactory eoFactory;

    public DataHandler_ModuleData(String projectUID, IClientDataFactory eoFactory) {
        assert (projectUID != null);
        assert (eoFactory != null);
        this.projectUID = projectUID;
        this.eoFactory = eoFactory;
    }

    public String getUIDForItem(IModuleData item) {
        return item.getUID();
    }

    public String getUIDStringForItem(IModuleData item) {
        return this.getUIDForItem(item);
    }

    public String getUIDStringForUID(String itemID) {
        return itemID;
    }

    public IObjectKey getObjectKeyForUID(String itemID) {
        return new Key_UID(itemID);
    }

    public String getDataTypeForItem(IModuleData item) {
        return item.getTypeID();
    }

    public Class<? extends IModuleData> getClassForDataTypeID(String dataTypeID) {
        return this.eoFactory.getClassForDataTypeID(dataTypeID);
    }

    public String getIDForItem(IModuleData item) {
        String idAttributeID = item.getTypeDescription().getIDAttribute();
        if (idAttributeID != null) {
            return item.getAttribute(idAttributeID).getUniqueStringRepresentation();
        }
        return null;
    }

    public void setInitialModificationAttributes(IModuleData item, long creationTimestamp, String creator) {
        item.getModificationTime().setValue(new Long(creationTimestamp));
        item.getCreationTime().setValue(new Long(creationTimestamp));
        item.setModificationCount(0);
        item.setCommitCount(0);
        item.getCreator().setValue(creator);
        item.getModifier().setValue(creator);
    }

    public void setNewModificationAttributes(IModuleData item, long modificationTimestamp, String modifier) {
        item.getModificationTime().setValue(modificationTimestamp);
        item.getModifier().setValue(modifier);
    }

    public void copyAllAttributes(IModuleData source, IModuleData target) {
        try {
            target.copyDataFrom((AbstractModuleData)source, false);
        }
        catch (IncompatibleDataTypeException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public IModuleData getCloneOfObject(IModuleData item) {
        return item.copy(true);
    }

    public boolean mergingHasEffect(IModuleData baseItem, IModuleData itemToMerge) {
        return baseItem.mergingHasEffect(itemToMerge);
    }

    public IModuleData merge(IModuleData baseItem, IModuleData itemToMerge) {
        return baseItem.merge(itemToMerge);
    }

    public EOModuleData getEOForItem(IModuleData item) {
        return item.createEncodableObject();
    }

    public IModuleData getItemForEO(EOModuleData eoItem) {
        return this.eoFactory.convertFromEO(eoItem, this.projectUID);
    }
}

