/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.crossmodulelinks;

import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class CrossModuleLinksLinkedDataAccessFacade
implements ILinkedDataAccessFacade {
    private final String virtualDataTypeID;
    private final Map<String, AbstractDataMgr> map_cockpitTypeID_dataManager;
    private final boolean allModuleDataTypesAllowed;

    public CrossModuleLinksLinkedDataAccessFacade(String virtualDataTypeID, Map<String, AbstractDataMgr> map_cockpitTypeID_dataManager, boolean allModuleDataTypesAllowed) {
        this.virtualDataTypeID = virtualDataTypeID;
        this.map_cockpitTypeID_dataManager = map_cockpitTypeID_dataManager;
        this.allModuleDataTypesAllowed = allModuleDataTypesAllowed;
    }

    public String getDataTypeID() {
        return this.virtualDataTypeID;
    }

    public ILabelProvider getLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return ((IModuleData)element).getStatusDependentIcon().getImage();
            }

            public String getText(Object element) {
                return ((IModuleData)element).getDisplayRepresentation();
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void addListener(ILabelProviderListener listener) {
                throw new UnsupportedOperationException();
            }

            public void removeListener(ILabelProviderListener listener) {
                throw new UnsupportedOperationException();
            }

            public void dispose() {
            }
        };
    }

    public boolean isLinkedItemExistent(String UID, boolean checkOnServerState) {
        if (this.allModuleDataTypesAllowed) {
            return true;
        }
        for (Map.Entry<String, AbstractDataMgr> entry : this.map_cockpitTypeID_dataManager.entrySet()) {
            String cockpitTypeID = entry.getKey();
            AbstractDataMgr dataManager = entry.getValue();
            if (!(checkOnServerState ? dataManager.itemExistsOnServer(UID, cockpitTypeID) : dataManager.itemExists(UID, cockpitTypeID))) continue;
            return true;
        }
        return false;
    }

    public ICockpitProjectData getLinkedItem(String UID) {
        for (Map.Entry<String, AbstractDataMgr> entry : this.map_cockpitTypeID_dataManager.entrySet()) {
            String cockpitTypeID = entry.getKey();
            AbstractDataMgr dataManager = entry.getValue();
            IModuleData item = (IModuleData)dataManager.getItem(cockpitTypeID, UID);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public ICockpitProjectData getLinkedItemVersion(String UID, int version) {
        return null;
    }

    public boolean isCreationOfNewItemsPossible() {
        return false;
    }

    public ICockpitProjectData createNewItem() {
        return null;
    }
}

