/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.issuemodule1migrator.core;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.issuemodule1migrator.core.ISM1MigratorConstants;
import com.arcway.cockpit.issuemodule1migrator.core.messages.EOIssue;
import com.arcway.cockpit.issuemodule1migrator.core.messages.EONote;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ISM1MigratorCore {
    private static final ILogger logger = Logger.getLogger(ISM1MigratorCore.class);
    private final Collection<EOLink_V0> newLinks = new EOList();
    private final Collection<EOLink_V0> linksToBeDeleted = new EOList();
    private final Collection<EOModuleData_V0> migratedIssues = new EOList();
    private final Collection<EOModuleData_V0> migratedIssueNotes = new EOList();
    private EOModuleData_V0 defaultIssueSet = new EOModuleData_V0();

    public void migrateData(Collection<EOIssue> eoIssues, Collection<EONote> eoIssueNotes, Collection<EOLink_V0> oldIssueModelElementLinks, Collection<EOLink_V0> oldIssueNoteIssueLinks, String projectUID) {
        this.defaultIssueSet = this.createDefaultIssueSet(projectUID);
        HashMap<String, EOModuleData_V0> eoIssueUID2newIssue = new HashMap<String, EOModuleData_V0>();
        int counterForID = 0;
        DecimalFormat df = new DecimalFormat("00000");
        for (EOIssue eoIssue : eoIssues) {
            String counterAsFormatedString = df.format(++counterForID);
            EOModuleData_V0 newIssue = this.migrateIssue(eoIssue, projectUID, counterAsFormatedString);
            this.migratedIssues.add(newIssue);
            eoIssueUID2newIssue.put(eoIssue.getUID(), newIssue);
            this.createDefaultIssueIssueSetLink(eoIssue, eoIssueUID2newIssue, projectUID);
        }
        HashMap<String, EOModuleData_V0> eoIssueNoteUID2newIssueNote = new HashMap<String, EOModuleData_V0>();
        for (EONote eoIssueNote : eoIssueNotes) {
            EOModuleData_V0 newIssueNote = this.migrateIssueNote(eoIssueNote, projectUID);
            this.migratedIssueNotes.add(newIssueNote);
            eoIssueNoteUID2newIssueNote.put(eoIssueNote.getUID(), newIssueNote);
        }
        if (oldIssueModelElementLinks != null) {
            this.migrateIssueModelElementLinks(eoIssueUID2newIssue, oldIssueModelElementLinks, projectUID);
            this.linksToBeDeleted.addAll(oldIssueModelElementLinks);
        }
        if (oldIssueNoteIssueLinks != null) {
            this.migrateIssueIssueNoteLink(eoIssueNoteUID2newIssueNote, eoIssueUID2newIssue, oldIssueNoteIssueLinks, projectUID);
            this.linksToBeDeleted.addAll(oldIssueNoteIssueLinks);
        }
    }

    private EOModuleData_V0 migrateIssue(EOIssue eoIssue, String projectUID, String issueID) {
        EOModuleData_V0 newIssue = new EOModuleData_V0();
        newIssue.setUid(UUIDGenerator.getUniqueID());
        newIssue.setProjectUID(projectUID);
        newIssue.setDatatypeUID("com.arcway.cockpit.genericmodule.issuemodule2.issue");
        newIssue.addAttribute("title", eoIssue.getTitle());
        newIssue.addAttribute("description", eoIssue.getText());
        java.sql.Date dueDate = eoIssue.getDueDate();
        String dueDateAsString = dueDate != null ? Long.toString(dueDate.getTime()) : null;
        newIssue.addAttribute("duedate", dueDateAsString);
        newIssue.addAttribute("responsible", eoIssue.getOwnerName());
        String priority = ISM1MigratorConstants.ISSUE_PRIORITY_OLD2NEW_MAP.get(Short.toString(eoIssue.getPriority()));
        if (priority == null) {
            priority = "";
        }
        newIssue.addAttribute("priority", priority);
        String status = ISM1MigratorConstants.ISSUE_STATUS_OLD2NEW_MAP.get(Short.toString(eoIssue.getStatus()));
        if (status == null) {
            status = "";
        }
        newIssue.addAttribute("status", status);
        newIssue.addAttribute("abstractmoduledata_creator", eoIssue.getInitiatorName());
        newIssue.addAttribute("abstractmoduledata_modifier", eoIssue.getModifier());
        int modCount = eoIssue.getModCount() + 1;
        newIssue.addAttribute("abstractmoduledata_modificationCount", Integer.toString(modCount));
        newIssue.setModCount(modCount);
        Timestamp creationDate = eoIssue.getDateCreation();
        long lCreateDate = creationDate != null ? ((Date)creationDate).getTime() : System.currentTimeMillis();
        newIssue.addAttribute("abstractmoduledata_creationDate", Long.toString(lCreateDate));
        Timestamp modificationDate = eoIssue.getDateModification();
        long lModDate = modificationDate != null ? ((Date)modificationDate).getTime() : lCreateDate;
        newIssue.addAttribute("abstractmoduledata_modificationDate", Long.toString(lModDate));
        newIssue.setModTime(lModDate);
        newIssue.addAttribute("id", "OP_" + issueID);
        return newIssue;
    }

    private EOModuleData_V0 migrateIssueNote(EONote eoIssueNote, String projectUID) {
        EOModuleData_V0 newIssueNote = new EOModuleData_V0();
        newIssueNote.setUid(UUIDGenerator.getUniqueID());
        newIssueNote.setProjectUID(projectUID);
        newIssueNote.setDatatypeUID("com.arcway.cockpit.genericmodule.issuemodule2.issueNote");
        newIssueNote.addAttribute("category", eoIssueNote.getCategory());
        newIssueNote.addAttribute("description", eoIssueNote.getText());
        newIssueNote.addAttribute("abstractmoduledata_creator", eoIssueNote.getAuthorName());
        newIssueNote.addAttribute("abstractmoduledata_modifier", eoIssueNote.getModifier());
        int modCount = eoIssueNote.getModCount() + 1;
        newIssueNote.addAttribute("abstractmoduledata_modificationCount", Integer.toString(modCount));
        newIssueNote.setModCount(modCount);
        Timestamp creationDate = eoIssueNote.getDateCreation();
        long lCreatDate = creationDate != null ? ((Date)creationDate).getTime() : System.currentTimeMillis();
        newIssueNote.addAttribute("abstractmoduledata_creationDate", Long.toString(lCreatDate));
        Timestamp modificationDate = eoIssueNote.getDateModification();
        long lModDate = modificationDate != null ? ((Date)modificationDate).getTime() : lCreatDate;
        newIssueNote.addAttribute("abstractmoduledata_modificationDate", Long.toString(lModDate));
        newIssueNote.setModTime(lModDate);
        return newIssueNote;
    }

    private void createDefaultIssueIssueSetLink(EOIssue eoIssue, Map<String, EOModuleData_V0> eoIssueUID2newIssue, String projectUID) {
        EOModuleData_V0 newIssue = eoIssueUID2newIssue.get(eoIssue.getUID());
        EOLink_V0 link = new EOLink_V0(projectUID, this.defaultIssueSet.getUid(), newIssue.getUid(), "com.arcway.cockpit.genericmodule.issuemodule2", "hierarchylink-genericmodule-issuemodule2--issue--issueSet");
        this.newLinks.add(link);
    }

    private void migrateIssueIssueNoteLink(Map<String, EOModuleData_V0> eoIssueNoteUID2newIssueNote, Map<String, EOModuleData_V0> eoIssueUID2newIssue, Collection<EOLink_V0> oldIssueNoteIssueLinks, String projectUID) {
        for (EOLink_V0 oldIssueNoteIssueLink : oldIssueNoteIssueLinks) {
            EOModuleData_V0 newIssueNote = eoIssueNoteUID2newIssueNote.get(oldIssueNoteIssueLink.getModuleDataUID());
            EOModuleData_V0 newIssue = eoIssueUID2newIssue.get(oldIssueNoteIssueLink.getLinkableObjectUID());
            if (newIssueNote != null && newIssue != null) {
                EOLink_V0 IssueNoteIssueLink = new EOLink_V0(projectUID, newIssue.getUid(), newIssueNote.getUid(), "com.arcway.cockpit.genericmodule.issuemodule2", "hierarchylink-genericmodule-issuemodule2--issueNote--issue");
                this.newLinks.add(IssueNoteIssueLink);
                continue;
            }
            logger.warn("Link error -> EOModuleData not found: " + oldIssueNoteIssueLink.toString());
        }
    }

    private void migrateIssueModelElementLinks(Map<String, EOModuleData_V0> eoIssueUID2newIssue, Collection<EOLink_V0> oldIssueModelElementLinks, String projectUID) {
        for (EOLink_V0 oldIssueModelElementLink : oldIssueModelElementLinks) {
            EOModuleData_V0 newIssue = eoIssueUID2newIssue.get(oldIssueModelElementLink.getModuleDataUID());
            if (newIssue != null) {
                EOLink_V0 newIssueModelElementLink = new EOLink_V0(projectUID, oldIssueModelElementLink.getLinkableObjectUID(), newIssue.getUid(), "com.arcway.cockpit.genericmodule.issuemodule2", "modelelementlink-genericmodule-issuemodule2--issue");
                this.newLinks.add(newIssueModelElementLink);
                continue;
            }
            logger.warn("Link error -> EOModuleData not found: " + oldIssueModelElementLink.toString());
        }
    }

    private EOModuleData_V0 createDefaultIssueSet(String projectUID) {
        EOModuleData_V0 newIssueSet = new EOModuleData_V0();
        newIssueSet.setUid(UUIDGenerator.getUniqueID());
        newIssueSet.setProjectUID(projectUID);
        newIssueSet.setDatatypeUID("com.arcway.cockpit.genericmodule.issuemodule2.issueSet");
        newIssueSet.addAttribute("name", ISM1MigratorConstants.DEFAULT_ISSUE_SET_NAME);
        newIssueSet.addAttribute("description", ISM1MigratorConstants.DEFAULT_ISSUE_SET_DESCRIPTION);
        newIssueSet.addAttribute("abstractmoduledata_creator", ISM1MigratorConstants.DEFAULT_ISSUE_SET_WORKER);
        newIssueSet.addAttribute("abstractmoduledata_modifier", ISM1MigratorConstants.DEFAULT_ISSUE_SET_WORKER);
        int modCount = 1;
        newIssueSet.addAttribute("abstractmoduledata_modificationCount", Integer.toString(modCount));
        newIssueSet.setModCount(modCount);
        long currentDate = System.currentTimeMillis();
        newIssueSet.addAttribute("abstractmoduledata_creationDate", Long.toString(currentDate));
        newIssueSet.addAttribute("abstractmoduledata_modificationDate", Long.toString(currentDate));
        newIssueSet.setModTime(currentDate);
        return newIssueSet;
    }

    public Collection<EOModuleData_V0> getIssueSets() {
        EOList issueSets = new EOList();
        issueSets.add(this.defaultIssueSet);
        return issueSets;
    }

    public Collection<EOModuleData_V0> getMigratedIssues() {
        return this.migratedIssues;
    }

    public Collection<EOModuleData_V0> getMigratedIssueNotes() {
        return this.migratedIssueNotes;
    }

    public Collection<EOLink_V0> getNewLinks() {
        return this.newLinks;
    }

    public Collection<EOLink_V0> getLinksToBeDeleted() {
        return this.linksToBeDeleted;
    }
}

