/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RequiredPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleSpecificExtensions
extends AbstractModuleSpecificationPart {
    private final String extensionDeclaration;
    private final Map<String, RequiredPlugin> requiredPluginMap;
    private final List<RequiredPlugin> requiredPluginList;

    public ModuleSpecificExtensions(String extensionDeclaration, List<RequiredPlugin> requiredPluginList) {
        this.extensionDeclaration = extensionDeclaration;
        this.requiredPluginMap = new HashMap<String, RequiredPlugin>();
        this.requiredPluginList = new ArrayList<RequiredPlugin>();
        int requiredPluginListCounter = 1;
        for (RequiredPlugin part : requiredPluginList) {
            part.setIndex(requiredPluginListCounter);
            String partID = part.getID();
            this.requiredPluginMap.put(partID, part);
            this.requiredPluginList.add(part);
            ++requiredPluginListCounter;
        }
    }

    public String getExtensionDeclaration() {
        return this.extensionDeclaration;
    }

    public List<RequiredPlugin> getRequiredPluginList() {
        return this.requiredPluginList;
    }

    public RequiredPlugin getRequiredPlugin(String id) {
        return this.requiredPluginMap.get(id);
    }

    public RequiredPlugin getRequiredPlugin(int index) {
        return this.getRequiredPluginList().get(index);
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getRequiredPluginList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "ModuleSpecificExtensions";
    }
}

