/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RequiredModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleDataSpecification
extends AbstractModuleSpecificationPart {
    private final Map<String, RequiredModule> requiredModuleMap = new HashMap<String, RequiredModule>();
    private final List<RequiredModule> requiredModuleList = new ArrayList<RequiredModule>();
    private final Map<String, ObjectType> objectTypeMap;
    private final List<ObjectType> objectTypeList;
    private final Map<String, RelationType> relationTypeMap;
    private final List<RelationType> relationTypeList;

    public ModuleDataSpecification(List<RequiredModule> requiredModuleList, List<ObjectType> objectTypeList, List<RelationType> relationTypeList) {
        int requiredModuleListCounter = 1;
        for (RequiredModule part : requiredModuleList) {
            part.setIndex(requiredModuleListCounter);
            String partID = part.getID();
            this.requiredModuleMap.put(partID, part);
            this.requiredModuleList.add(part);
            ++requiredModuleListCounter;
        }
        this.objectTypeMap = new HashMap<String, ObjectType>();
        this.objectTypeList = new ArrayList<ObjectType>();
        int objectTypeListCounter = 1;
        for (ObjectType part : objectTypeList) {
            part.setIndex(objectTypeListCounter);
            String partID = part.getID();
            this.objectTypeMap.put(partID, part);
            this.objectTypeList.add(part);
            ++objectTypeListCounter;
        }
        this.relationTypeMap = new HashMap<String, RelationType>();
        this.relationTypeList = new ArrayList<RelationType>();
        int relationTypeListCounter = 1;
        for (RelationType part : relationTypeList) {
            ((AbstractModuleSpecificationPart)((Object)part)).setIndex(relationTypeListCounter);
            String partID = part.getID();
            this.relationTypeMap.put(partID, part);
            this.relationTypeList.add(part);
            ++relationTypeListCounter;
        }
    }

    public List<RequiredModule> getRequiredModuleList() {
        return this.requiredModuleList;
    }

    public RequiredModule getRequiredModule(String id) {
        return this.requiredModuleMap.get(id);
    }

    public RequiredModule getRequiredModule(int index) {
        return this.getRequiredModuleList().get(index);
    }

    public List<ObjectType> getObjectTypeList() {
        return this.objectTypeList;
    }

    public ObjectType getObjectType(String id) {
        return this.objectTypeMap.get(id);
    }

    public ObjectType getObjectType(int index) {
        return this.getObjectTypeList().get(index);
    }

    public List<RelationType> getRelationTypeList() {
        return this.relationTypeList;
    }

    public RelationType getRelationType(String id) {
        return this.relationTypeMap.get(id);
    }

    public RelationType getRelationType(int index) {
        return this.getRelationTypeList().get(index);
    }

    public <T extends RelationType> List<T> getRelationTypeListOfType(Class<T> type) {
        ArrayList<RelationType> list = new ArrayList<RelationType>(this.relationTypeMap.size());
        for (RelationType child : this.relationTypeMap.values()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            list.add((RelationType)type.cast(child));
        }
        ModuleDataSpecification.sortSpecificationPartList(list);
        return list;
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getRequiredModuleList());
        children.addAll(this.getObjectTypeList());
        children.addAll(this.getRelationTypeList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "ModuleDataSpecification";
    }
}

