/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CMRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrossModuleRelationType
extends AbstractModuleSpecificationPart
implements RelationType {
    private final String relationTypeID;
    private final String relationTypeName;
    private final Map<String, CMRelationParticipant> cMRelationParticipantMap;
    private final List<CMRelationParticipant> cMRelationParticipantList;

    public CrossModuleRelationType(String relationTypeID, String relationTypeName, List<CMRelationParticipant> cMRelationParticipantList) {
        this.relationTypeID = relationTypeID;
        this.relationTypeName = relationTypeName;
        this.cMRelationParticipantMap = new HashMap<String, CMRelationParticipant>();
        this.cMRelationParticipantList = new ArrayList<CMRelationParticipant>();
        int cMRelationParticipantListCounter = 1;
        for (CMRelationParticipant part : cMRelationParticipantList) {
            part.setIndex(cMRelationParticipantListCounter);
            String partID = part.getID();
            this.cMRelationParticipantMap.put(partID, part);
            this.cMRelationParticipantList.add(part);
            ++cMRelationParticipantListCounter;
        }
    }

    public String getRelationTypeID() {
        return this.relationTypeID;
    }

    public String getRelationTypeName() {
        return this.relationTypeName;
    }

    public List<CMRelationParticipant> getCMRelationParticipantList() {
        return this.cMRelationParticipantList;
    }

    public CMRelationParticipant getCMRelationParticipant(String id) {
        return this.cMRelationParticipantMap.get(id);
    }

    public CMRelationParticipant getCMRelationParticipant(int index) {
        return this.getCMRelationParticipantList().get(index);
    }

    @Override
    public String getID() {
        return this.relationTypeID;
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getCMRelationParticipantList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "CrossModuleRelationType";
    }
}

