/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.relationgraph;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.lib.relationviews.Draw2DTextExtendCalculator;
import com.arcway.cockpit.frame.client.lib.relationviews.GraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationGraphProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.ITextExtendCalculator;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.dependencynet.DependencyNetGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.dependencynet.IDependencyModel;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.gui.relationgraph.RelationGraphDependencyModel;
import com.arcway.cockpit.genericmodule.client.gui.relationgraph.RelationGraphLayoutProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.gui.relationviews.AbstractModuleDataRelationView;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

public class RelationGraphView
extends AbstractModuleDataRelationView {
    private DependencyNetGraphBuilder graphBuilder;
    private String moduleID;
    private ModuleDataSpecification moduleDataSpecification;
    private ModuleDataRelationType relationType;
    private String linkTypeID;
    private ObjectType linkStartObjectType;
    private String linkStartDataTypeID;
    private ObjectType linkEndObjectType;
    private String linkEndDataTypeID;

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.moduleDataSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID).getModuleDataSpecification();
        com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationGraphView graphViewSpec = (com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationGraphView)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
        this.relationType = (ModuleDataRelationType)this.moduleDataSpecification.getRelationType(graphViewSpec.getModuleDataRelationTypeID());
        this.linkStartObjectType = this.moduleDataSpecification.getObjectType(this.relationType.getMDRelationParticipant(0).getObjectTypeIDOfParticipant());
        this.linkEndObjectType = this.moduleDataSpecification.getObjectType(this.relationType.getMDRelationParticipant(1).getObjectTypeIDOfParticipant());
        this.linkTypeID = GMLinkTypeHelper_Shared.getDefault(this.moduleID).getRelationLinkTypeID(this.relationType.getRelationTypeID());
        this.linkStartDataTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.linkStartObjectType.getObjectTypeID());
        this.linkEndDataTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.linkEndObjectType.getObjectTypeID());
    }

    public void handleDispose() {
    }

    public void handleModelRefresh(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        block10: {
            block11: {
                EOLink link;
                block9: {
                    assert (GenericModuleData.class.isAssignableFrom(clazz) || EOLink.class.isAssignableFrom(clazz) || ObjectTypeCategory.class.isAssignableFrom(clazz));
                    if (!GenericModuleData.class.isAssignableFrom(clazz)) break block9;
                    if (changes.getDeletedElements() != null) {
                        for (Object deletedObject : changes.getDeletedElements()) {
                            GenericModuleData deletedItem = (GenericModuleData)((Object)deletedObject);
                            if (deletedItem != this.getCurrentItem()) continue;
                            this.clearCurrentItem();
                            return;
                        }
                    }
                    if (changes.getModifiedElements() == null) break block10;
                    for (Object modifiedObject : changes.getModifiedElements()) {
                        GenericModuleData modifiedItem = (GenericModuleData)((Object)modifiedObject);
                        if (!modifiedItem.getTypeID().equals(this.linkStartDataTypeID) && !modifiedItem.getTypeID().equals(this.linkEndDataTypeID)) continue;
                        this.refreshCurrentItem();
                        return;
                    }
                    break block10;
                }
                if (!EOLink.class.isAssignableFrom(clazz)) break block11;
                if (changes.getDeletedElements() != null) {
                    for (Object deletedObject : changes.getDeletedElements()) {
                        link = (EOLink)deletedObject;
                        if (!link.getLinkTypeID().equals(this.linkTypeID)) continue;
                        this.refreshCurrentItem();
                        return;
                    }
                }
                if (changes.getCreatedElements() == null) break block10;
                for (Object deletedObject : changes.getCreatedElements()) {
                    link = (EOLink)deletedObject;
                    if (!link.getLinkTypeID().equals(this.linkTypeID)) continue;
                    this.refreshCurrentItem();
                    return;
                }
                break block10;
            }
            if (ObjectTypeCategory.class.isAssignableFrom(clazz)) {
                for (Object modifiedObject : changes.getModifiedElements()) {
                    ObjectTypeCategory modifiedCategory = (ObjectTypeCategory)modifiedObject;
                    if (!modifiedCategory.getCockpitDataTypeID().equals(this.linkStartDataTypeID) && !modifiedCategory.getCockpitDataTypeID().equals(this.linkEndDataTypeID)) continue;
                    this.refreshCurrentItem();
                }
            }
        }
    }

    protected IModuleData translateItem(IModuleData data) {
        GenericModuleData item;
        if (data instanceof GenericModuleData && (item = (GenericModuleData)data).getGenericModuleID().equals(this.moduleID) && (item.getTypeID().equals(this.linkStartDataTypeID) || item.getTypeID().equals(this.linkEndDataTypeID))) {
            return data;
        }
        return null;
    }

    protected String getEmptyViewMessage() {
        if (this.linkStartDataTypeID.equals(this.linkEndDataTypeID)) {
            return NLS.bind((String)Messages.getString("RelationGraphView.ErrorMsg.NoItemSelected-OneType"), (Object)new LabelProvider(this.linkStartObjectType.getObjectTypeName()).getLabel(Locale.getDefault()));
        }
        return NLS.bind((String)Messages.getString("RelationGraphView.ErrorMsg.NoItemSelected-TwoTypes"), (Object)new LabelProvider(this.linkStartObjectType.getObjectTypeName()).getLabel(Locale.getDefault()), (Object)new LabelProvider(this.linkEndObjectType.getObjectTypeName()).getLabel(Locale.getDefault()));
    }

    protected void handleProjectSwitch_Before(String newProjectUID) {
    }

    protected void handleProjectSwitch_After(String newProjectUID) {
    }

    protected IRelationViewGraphBuilder getGraphBuilder(LabelCreator labelCreator) {
        if (this.graphBuilder == null) {
            this.graphBuilder = new DependencyNetGraphBuilder((IDependencyModel)new RelationGraphDependencyModel(this.moduleID, this.linkTypeID, this.linkStartDataTypeID, this.linkEndDataTypeID), labelCreator);
        }
        return this.graphBuilder;
    }

    protected ProjectMgr getProjectManager() {
        return GenericModulePlugin.getDefault().getProjectManager(this.moduleID);
    }

    protected Collection<Class<?>> getDataTypesWhichCauseRefresh() {
        return Arrays.asList(GenericModuleData.class, EOLink.class, ObjectTypeCategory.class);
    }

    protected String getHelpContextID() {
        return null;
    }

    protected IGraphNodeLayoutProvider createFigureLayoutProvider() {
        Draw2DTextExtendCalculator textExtendCalculator = new Draw2DTextExtendCalculator();
        RelationGraphLayoutProvider relationGraphProvider = new RelationGraphLayoutProvider(this.moduleID);
        return new GraphNodeLayoutProvider((ITextExtendCalculator)textExtendCalculator, (IRelationGraphProvider)relationGraphProvider);
    }
}

