/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.dataview;

import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.AbstractDataViewColumnComparator;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.gui.AttributeUIHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationLabelHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.AttributeColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Column;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ColumnProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CustomPropertyColumns;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MELinkColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.TableTreeDataView;
import com.arcway.cockpit.genericmodule.client.messages.AttributeHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IFixColumnDescriptionProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class GMFixColumnSpecificationProvider
implements IFixColumnDescriptionProvider {
    private final String moduleID;
    private final List<ColumnProvider> columnSpecs;
    private final ModuleDataSpecification moduleDataSpecification;
    private final GMLinkTypeHelper_Shared linkTypeHelper;

    public GMFixColumnSpecificationProvider(String moduleID, ModuleSpecification moduleSpecification, TableTreeDataView dataViewSpecification) {
        this.moduleID = moduleID;
        this.columnSpecs = dataViewSpecification.getColumnProviderList();
        this.moduleDataSpecification = moduleSpecification.getModuleDataSpecification();
        this.linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(moduleID);
    }

    public Collection<IColumnDescription> getColumnDescriptions() {
        ArrayList<IColumnDescription> columnDescriptions = new ArrayList<IColumnDescription>(this.columnSpecs.size());
        int index = 0;
        for (ColumnProvider columnProvider : this.columnSpecs) {
            if (columnProvider instanceof CustomPropertyColumns) {
                index = 2000;
            } else if (columnProvider instanceof Column) {
                Column column = (Column)columnProvider;
                columnDescriptions.add((IColumnDescription)new ColumnDescription(column.getColumnID(), SpecificationLabelHelper.getLabel(column.getColumnName()), SpecificationLabelHelper.getLabel(column.getColumnDescription()), column.getColumnWidth(), index, !column.isInvisibleByDefault(), 1, index, (IDataViewColumnComparator)new DataViewColumnComparator(column)));
            }
            ++index;
        }
        return columnDescriptions;
    }

    private static final Collection<ICockpitProjectData> getLinkedModelElements(GenericModuleData item, String cockpitTypeID, IModelController modelController) {
        String linkTypeID = GMLinkTypeHelper_Shared.getDefault(item.getGenericModuleID()).getModelElementLinkTypeID(cockpitTypeID);
        return modelController.getLinkableObjects((IModuleData)item, linkTypeID);
    }

    private class DataViewColumnComparator
    extends AbstractDataViewColumnComparator {
        private final Column column;

        public DataViewColumnComparator(Column column) {
            this.column = column;
        }

        public int compare(Object o1, Object o2) {
            assert (o1 instanceof GenericModuleData && o2 instanceof GenericModuleData);
            GenericModuleData gmd1 = (GenericModuleData)((Object)o1);
            GenericModuleData gmd2 = (GenericModuleData)((Object)o2);
            if (gmd1.getTypeID().equals(gmd2.getTypeID())) {
                ObjectType objectType = GMFixColumnSpecificationProvider.this.moduleDataSpecification.getObjectType(ClientDataFactory_TypesHelper.getShortTypeID(gmd1.getTypeID()));
                ColumnContent columnContent = this.column.getColumnContent(objectType.getObjectTypeID());
                if (columnContent instanceof AttributeColumnContent) {
                    String attributeID = ((AttributeColumnContent)columnContent).getAttributeID();
                    String attributeDataType = null;
                    Object attribute1 = null;
                    Object attribute2 = null;
                    Attribute attribute = objectType.getAttribute(attributeID);
                    if (attribute instanceof IDAttribute) {
                        attributeDataType = "datatype_mda_string_single";
                        attribute1 = gmd1.getAttribute(attributeID);
                        attribute2 = gmd2.getAttribute(attributeID);
                    }
                    if (attribute instanceof SimpleAttribute) {
                        attributeDataType = ((SimpleAttribute)attribute).getAttributeDataType();
                        attribute1 = gmd1.getAttribute(attributeID);
                        attribute2 = gmd2.getAttribute(attributeID);
                    }
                    if (attribute instanceof EnumerationAttribute) {
                        attributeDataType = "datatype_meta_enumeration";
                        attribute1 = gmd1.getAttribute(attributeID);
                        attribute2 = gmd2.getAttribute(attributeID);
                    }
                    if (attribute instanceof LinkedModuleDataAttribute) {
                        attributeDataType = "datatype_meta_linkedmoduledata";
                        String linkTypeID = GMFixColumnSpecificationProvider.this.linkTypeHelper.getAttributeLinkTypeID_forShortTypeID(objectType.getObjectTypeID(), attributeID);
                        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(GMFixColumnSpecificationProvider.this.moduleID).getModelController(gmd1.getProjectUID());
                        Collection linkedAttribute1Collection = modelController.getLinkableObjects((IModuleData)gmd1, linkTypeID);
                        if (linkedAttribute1Collection.size() == 1) {
                            attribute1 = linkedAttribute1Collection.iterator().next();
                        } else assert (linkedAttribute1Collection.isEmpty());
                        Collection linkedAttribute2Collection = modelController.getLinkableObjects((IModuleData)gmd2, linkTypeID);
                        if (linkedAttribute2Collection.size() == 1) {
                            attribute2 = linkedAttribute2Collection.iterator().next();
                        } else assert (linkedAttribute2Collection.isEmpty());
                    }
                    if (attribute instanceof LinkedFrameDataAttribute) {
                        attributeDataType = "datatype_virtual_linkedframedata";
                        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(GMFixColumnSpecificationProvider.this.moduleID).getModelController(gmd1.getProjectUID());
                        IExpiringFrontendLabel label1 = modelController.getPlatformAccessAgent().getLabelOfLinkedFrameDataItem((IModuleData)gmd1, attributeID);
                        attribute1 = label1 != null ? label1.getText() : null;
                        IExpiringFrontendLabel label2 = modelController.getPlatformAccessAgent().getLabelOfLinkedFrameDataItem((IModuleData)gmd2, attributeID);
                        String string = attribute2 = label2 != null ? label2.getText() : null;
                    }
                    if (attribute instanceof CalculatedAttribute) {
                        attributeDataType = AttributeHelper.getDataTypeOfCalculatedAttribute(((CalculatedAttribute)attribute).getCalculationTypeID());
                        attribute1 = gmd1.getAttribute(attributeID);
                        attribute2 = gmd2.getAttribute(attributeID);
                    }
                    assert (attributeDataType != null) : "Unknown attribute id for data view column in data view sorter.";
                    Comparator<Object> comparator = AttributeUIHelper.getComparator(attributeDataType);
                    return comparator.compare(attribute1, attribute2);
                }
                if (columnContent instanceof MELinkColumnContent) {
                    MELinkColumnContent meLinkColumnContent = (MELinkColumnContent)columnContent;
                    IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(GMFixColumnSpecificationProvider.this.moduleID).getModelController(gmd1.getProjectUID());
                    Collection linkedItems1 = GMFixColumnSpecificationProvider.getLinkedModelElements(gmd1, gmd1.getTypeID(), modelController);
                    Collection linkedItems2 = GMFixColumnSpecificationProvider.getLinkedModelElements(gmd2, gmd2.getTypeID(), modelController);
                    if (meLinkColumnContent.getMELinkPresentationType().equals("link-yesno") || meLinkColumnContent.getMELinkPresentationType().equals("link-icon")) {
                        if (linkedItems1.isEmpty() && !linkedItems2.isEmpty()) {
                            return -1;
                        }
                        if (!linkedItems1.isEmpty() && linkedItems2.isEmpty()) {
                            return 1;
                        }
                        return 0;
                    }
                    if (meLinkColumnContent.getMELinkPresentationType().equals("link-number")) {
                        return linkedItems1.size() - linkedItems2.size();
                    }
                    if (meLinkColumnContent.getMELinkPresentationType().equals("link-list")) {
                        return 0;
                    }
                    assert (false);
                    return 0;
                }
                return 0;
            }
            ObjectType objectType1 = GMFixColumnSpecificationProvider.this.moduleDataSpecification.getObjectType(ClientDataFactory_TypesHelper.getShortTypeID(gmd1.getTypeID()));
            ObjectType objectType2 = GMFixColumnSpecificationProvider.this.moduleDataSpecification.getObjectType(ClientDataFactory_TypesHelper.getShortTypeID(gmd2.getTypeID()));
            int index1 = GMFixColumnSpecificationProvider.this.moduleDataSpecification.getObjectTypeList().indexOf(objectType1);
            int index2 = GMFixColumnSpecificationProvider.this.moduleDataSpecification.getObjectTypeList().indexOf(objectType2);
            return index1 - index2;
        }
    }
}

