/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.dataview;

import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ModuleActionDelegate;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.search.ICockpitSearchStringGenerator;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataView;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMModifyItems;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMSearch;
import com.arcway.cockpit.genericmodule.client.gui.actions.ActionAdministrateAttributeObjects;
import com.arcway.cockpit.genericmodule.client.gui.actions.ActionDelegateCopy;
import com.arcway.cockpit.genericmodule.client.gui.actions.ActionDelegateDelete;
import com.arcway.cockpit.genericmodule.client.gui.actions.ActionDelegatePaste;
import com.arcway.cockpit.genericmodule.client.gui.dataview.DataView;
import com.arcway.cockpit.genericmodule.client.gui.dataview.DataViewLabelProvider;
import com.arcway.cockpit.genericmodule.client.gui.dataview.GMFixColumnSpecificationProvider;
import com.arcway.cockpit.genericmodule.client.gui.dataview.SearchStringGenerator;
import com.arcway.cockpit.genericmodule.client.gui.dnd.CopyDragNDropSupport;
import com.arcway.cockpit.genericmodule.client.gui.dnd.EditorDragSupport;
import com.arcway.cockpit.genericmodule.client.gui.dnd.MoveDragNDropSupport;
import com.arcway.cockpit.genericmodule.client.gui.dnd.NaturalOrderDragNDropSupport;
import com.arcway.cockpit.genericmodule.client.gui.dnd.RelationDragNDropSupport;
import com.arcway.cockpit.genericmodule.client.gui.filters.GenericModuleFilters;
import com.arcway.cockpit.genericmodule.client.infrastructure.SpecificationConstantsHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationLabelHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.TableTreeDataView;
import com.arcway.cockpit.genericmodule.client.messages.AttributeHelper;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForCategories;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForDiscreteValues;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForLinkedFrameDataAttributes;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForLinkedModuleDataAttributes;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.IDiscreteAttributeHandler;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IFixColumnDescriptionProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IModuleFixColumnProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataView;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewProvider;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ICopyDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.IMoveDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ItemEditorDragSupport;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.lib.java.EitherOr;
import com.arcway.lib.java.collectionmaps.ListMap;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IWorkbenchPart;

public class GMDataViewProvider
extends StandardTreeDataViewProvider {
    private final String moduleID;
    private final ModuleSpecification moduleSpecification;
    private final IDataTypesHelper dataTypesHelper;
    private final DataView dataView_;
    private ActionDelegateDelete actionDelegateDelete;
    private Collection<ActionAdministrateAttributeObjects> attributeObjectAdministrationActions;
    private GenericModuleFilters filterFactory;
    private ListMap<String, IDiscreteAttributeHandler> attributeHandlers;
    private final MoveDragNDropSupport moveDnDSupport;
    private final EditorDragSupport editorDragSupport;
    private final RelationDragNDropSupport relationDnDSupport;
    private final CopyDragNDropSupport copyDnDSupport;
    private final NaturalOrderDragNDropSupport naturalOrderDnDSupport;
    private final ItemEditorDragSupport itemEditorDragSupport;

    public GMDataViewProvider(DataView dataView, String moduleID, ModuleSpecification moduleSpecification, TableTreeDataView dataViewSpec) {
        super((StandardTreeDataView)dataView, GMDataTypesHelper.getDefault(moduleID).getDocumentationCustomPropertyDataTypes(), (IFixColumnDescriptionProvider)new GMFixColumnSpecificationProvider(moduleID, moduleSpecification, dataViewSpec), (IModuleFixColumnProvider)new DataViewLabelProvider(moduleID, dataViewSpec));
        assert (dataView != null) : "dataView must not be null";
        this.moduleID = moduleID;
        this.moduleSpecification = moduleSpecification;
        this.dataTypesHelper = GMDataTypesHelper.getDefault(moduleID);
        this.dataView_ = dataView;
        this.moveDnDSupport = new MoveDragNDropSupport(moduleID, null);
        this.editorDragSupport = new EditorDragSupport(moduleID, moduleSpecification.getModuleDataSpecification(), null);
        this.relationDnDSupport = new RelationDragNDropSupport(moduleID, moduleSpecification.getModuleDataSpecification(), null);
        this.copyDnDSupport = new CopyDragNDropSupport(moduleID, moduleSpecification.getModuleDataSpecification(), null);
        this.naturalOrderDnDSupport = new NaturalOrderDragNDropSupport(moduleID, null, (TreeDataView<?>)dataView, (IMoveDragNDropExecuter)this.moveDnDSupport, (ICopyDragNDropExecuter)this.copyDnDSupport);
        this.itemEditorDragSupport = new ItemEditorDragSupport((IProjectAgentProvider)GenericModulePlugin.getDefault().getProjectManager(moduleID), null);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.moveDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.copyDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.naturalOrderDnDSupport);
        dataView.registerProjectSwitchListener(this.relationDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.editorDragSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.itemEditorDragSupport);
        this.createActions();
        this.createAttributeHandlers();
    }

    public ModuleActionDelegate getDeleteActionDelegate() {
        return this.actionDelegateDelete;
    }

    public DragSource[] createDragSources() {
        DragSource[] allSources = new DragSource[]{this.moveDnDSupport.getDragSource(), this.copyDnDSupport.getDragSource(), this.relationDnDSupport.getDragSource(), this.editorDragSupport.getDragSource(), this.naturalOrderDnDSupport.getDragSource(), this.itemEditorDragSupport.getDragSource()};
        return allSources;
    }

    public DropTarget[] createDropTargets() {
        DropTarget[] allTargets = new DropTarget[]{this.moveDnDSupport.getDropTarget(), this.copyDnDSupport.getDropTarget(), this.relationDnDSupport.getDropTarget(), this.naturalOrderDnDSupport.getDropTarget()};
        return allTargets;
    }

    public List<IFilterItem> createFilterItems() {
        this.filterFactory = new GenericModuleFilters(this.moduleID, this.moduleSpecification, this.dataView_.getVisibleObjectTypes(), (IModuleProjectSwitchListenerManager)this.dataView_);
        return this.filterFactory.createFilters(true);
    }

    public void dispose() {
        this.filterFactory.dispose();
    }

    public KeyListener createKeyListener() {
        return null;
    }

    public List<EitherOr<IAction, IContributionItem>> getAdditionalViewMenuActions() {
        ArrayList<EitherOr<IAction, IContributionItem>> viewMenuActions = new ArrayList<EitherOr<IAction, IContributionItem>>(super.getAdditionalViewMenuActions());
        for (ActionAdministrateAttributeObjects action : this.attributeObjectAdministrationActions) {
            viewMenuActions.add((EitherOr<IAction, IContributionItem>)new EitherOr.Either((Object)action));
        }
        return viewMenuActions;
    }

    private void createActions() {
        this.actionDelegateDelete = new ActionDelegateDelete();
        this.actionDelegateDelete.setInitializationData(this.moduleID);
        this.attributeObjectAdministrationActions = new HashSet<ActionAdministrateAttributeObjects>();
        GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(this.moduleID);
        for (ObjectType objectType : this.moduleSpecification.getModuleDataSpecification().getObjectTypeList()) {
            Collection<String> linkTypes = linkTypeHelper.getAttributeLinkTypes_forShortTypeID(objectType.getObjectTypeID());
            if (linkTypes == null || linkTypes.isEmpty()) continue;
            ActionAdministrateAttributeObjects action = new ActionAdministrateAttributeObjects(this.moduleID, objectType, linkTypes);
            action.setText(String.valueOf(Messages.getString("DataViewProvider.AdministrateAttributeObjects.Label.Pre")) + " " + SpecificationLabelHelper.getLabel(objectType.getObjectTypeName()) + " " + Messages.getString("DataViewProvider.AdministrateAttributeObjects.Label.Post"));
            if (objectType.getObjectTypeIcon() != null && objectType.getObjectTypeIcon().length() > 0) {
                action.setImageDescriptor(ResourceManager.getDefault().getImageDescriptor(this.moduleID, objectType.getObjectTypeIcon()));
            }
            action.setToolTipText(String.valueOf(Messages.getString("DataViewProvider.AdministrateAttributeObjects.Tooltip.Pre")) + " " + SpecificationLabelHelper.getLabel(objectType.getObjectTypeName()) + " " + Messages.getString("DataViewProvider.AdministrateAttributeObjects.Tooltip.Post"));
            action.setContainingPart((IWorkbenchPart)this.dataView_);
            this.attributeObjectAdministrationActions.add(action);
        }
    }

    public String getHelpContextId() {
        return null;
    }

    public String getFilterDialogueTitle() {
        return this.filterFactory.getFilterTitle();
    }

    public String getFilterDialogueDescription() {
        return this.filterFactory.getFilterDescription();
    }

    public boolean hasIncrementalSearch() {
        return true;
    }

    public Map<String, ICockpitSearchStringGenerator<IModuleData>> getSearchStringGenerators() {
        HashMap<String, ICockpitSearchStringGenerator<IModuleData>> searchStringGenerators = new HashMap<String, ICockpitSearchStringGenerator<IModuleData>>();
        for (ObjectType objectType : this.moduleSpecification.getModuleDataSpecification().getObjectTypeList()) {
            searchStringGenerators.put(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID()), (ICockpitSearchStringGenerator<IModuleData>)new SearchStringGenerator(this.moduleID, objectType));
        }
        return searchStringGenerators;
    }

    public String getFullModuleID() {
        return ModuleIdentification.getFullModuleID(this.moduleID);
    }

    public ModuleActionDelegate getCopyActionDelegate() {
        return new ActionDelegateCopy(this.moduleID, this.moduleSpecification.getModuleDataSpecification());
    }

    public ModuleActionDelegate getPasteActionDelegate() {
        return new ActionDelegatePaste(this.moduleID, this.moduleSpecification.getModuleDataSpecification());
    }

    public ListMap<String, IDiscreteAttributeHandler> getDiscreteAttributeHandlers() {
        return this.attributeHandlers;
    }

    private void createAttributeHandlers() {
        GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(this.moduleID);
        this.attributeHandlers = new ListMap();
        for (ObjectType objectType : this.moduleSpecification.getModuleDataSpecification().getObjectTypeList()) {
            String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID());
            if (!objectType.isDisableObjectTypeCategories()) {
                this.attributeHandlers.add((Object)cockpitTypeID, (Object)new AttributeHandlerForCategories((IModuleProjectSwitchListenerManager)this.dataView_, (IModelControllerProvider)GenericModulePlugin.getDefault().getProjectManager(this.moduleID), cockpitTypeID, true));
            }
            for (Attribute attribute : objectType.getAttributeList()) {
                AbstractModuleSpecificationPart lAttribute;
                if (attribute instanceof EnumerationAttribute) {
                    EnumerationAttribute eAttribute = (EnumerationAttribute)attribute;
                    DiscreteValue[] valueRange = AttributeHelper.createModuleDataAttributeDiscrete(eAttribute, this.moduleID).getValueRange();
                    this.attributeHandlers.add((Object)cockpitTypeID, (Object)new AttributeHandlerForDiscreteValues((IModuleProjectSwitchListenerManager)this.dataView_, (IModelControllerProvider)GenericModulePlugin.getDefault().getProjectManager(this.moduleID), eAttribute.getAttributeID(), new LabelProvider(eAttribute.getAttributeName()).getLabel(Locale.getDefault()), cockpitTypeID, valueRange, true));
                }
                if (attribute instanceof LinkedModuleDataAttribute) {
                    lAttribute = (LinkedModuleDataAttribute)attribute;
                    this.attributeHandlers.add((Object)cockpitTypeID, (Object)new AttributeHandlerForLinkedModuleDataAttributes((IModuleProjectSwitchListenerManager)this.dataView_, (IModelControllerProvider)GenericModulePlugin.getDefault().getProjectManager(this.moduleID), ((LinkedModuleDataAttribute)lAttribute).getAttributeID(), new LabelProvider(((LinkedModuleDataAttribute)lAttribute).getAttributeName()).getLabel(Locale.getDefault()), cockpitTypeID, linkTypeHelper.getModuleDataAttributeLinkType(objectType.getObjectTypeID(), ((LinkedModuleDataAttribute)lAttribute).getAttributeID()), AttributeHandlerForLinkedModuleDataAttributes.DISPLAY_REPRESENTATION_COMPARATOR, true, true){

                        protected String getText(IModuleData object) {
                            return object.getDisplayRepresentation();
                        }

                        protected IIconResource getImage(IModuleData object) {
                            return null;
                        }
                    });
                }
                if (!(attribute instanceof LinkedFrameDataAttribute)) continue;
                lAttribute = (LinkedFrameDataAttribute)attribute;
                this.attributeHandlers.add((Object)cockpitTypeID, (Object)new AttributeHandlerForLinkedFrameDataAttributes((IModuleProjectSwitchListenerManager)this.dataView_, (IModelControllerProvider)GenericModulePlugin.getDefault().getProjectManager(this.moduleID), ((LinkedFrameDataAttribute)lAttribute).getAttributeID(), new LabelProvider(((LinkedFrameDataAttribute)lAttribute).getAttributeName()).getLabel(Locale.getDefault()), cockpitTypeID, SpecificationConstantsHelper.getCockpitDataTypeIDForLinkedFrameObjectType(((LinkedFrameDataAttribute)lAttribute).getFrameObjectTypeID()), AttributeHandlerForLinkedFrameDataAttributes.REPOSITORYOBJECT_LABEL_COMPARATOR, true, true));
            }
        }
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForSearch() {
        return ClientFunctionLicenseTypeGMSearch.getInstance(this.moduleID);
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForChangeValueActions() {
        return ClientFunctionLicenseTypeGMModifyItems.getInstance(this.moduleID);
    }

    public final Collection<ActionAdministrateAttributeObjects> getAttributeObjectAdministrationActions() {
        return this.attributeObjectAdministrationActions;
    }

    protected boolean isObjectTypeCategoryColumnNeeded() {
        for (String visibleObjectTypeID : this.dataView_.getVisibleObjectTypes()) {
            IModuleDataTypeDescription typeDescription = this.dataTypesHelper.getTypeDescription(visibleObjectTypeID);
            if (!typeDescription.isSupportingCategories()) continue;
            return true;
        }
        return false;
    }

    protected Collection<Class<?>> getAdditionalClassesThatTriggerRefresh() {
        return Collections.emptySet();
    }

    protected ProjectMgr getProjectAssociationManager() {
        return GenericModulePlugin.getDefault().getProjectManager(this.moduleID);
    }

    protected IDataTypesHelper getDataTypesHelper() {
        return this.dataTypesHelper;
    }
}

