/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core;

import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.AbstractClientDataFactory;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClientDataFactory
extends AbstractClientDataFactory {
    private final String moduleID;
    private final Set<String> trueDataTypeIDs_AsSet;
    private final Map<String, ObjectType> map_shortTypeID_objectTypeDefinition;

    public ClientDataFactory(String moduleID, ModuleDataSpecification moduleDataSpecification) {
        this.moduleID = moduleID;
        ArrayList<String> trueDataTypeIDs = new ArrayList<String>(moduleDataSpecification.getObjectTypeList().size());
        HashMap<String, ObjectType> objectTypeMap = new HashMap<String, ObjectType>();
        for (ObjectType objectType : moduleDataSpecification.getObjectTypeList()) {
            String dataTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID());
            trueDataTypeIDs.add(dataTypeID);
            objectTypeMap.put(objectType.getObjectTypeID(), objectType);
        }
        this.trueDataTypeIDs_AsSet = Collections.unmodifiableSet(new HashSet(trueDataTypeIDs));
        this.map_shortTypeID_objectTypeDefinition = Collections.unmodifiableMap(objectTypeMap);
    }

    public IModuleData convertFromEO(EOModuleData item) {
        String shortTypeID = ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID());
        ObjectType objectType = this.map_shortTypeID_objectTypeDefinition.get(shortTypeID);
        if (objectType != null) {
            return new GenericModuleData(item, this.moduleID, objectType);
        }
        assert (false);
        return null;
    }

    public Class<? extends IModuleData> getClassForDataTypeID(String dataTypeId) {
        if (this.trueDataTypeIDs_AsSet.contains(dataTypeId)) {
            return GenericModuleData.class;
        }
        return null;
    }
}

