/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.cockpit.frame.shared.message.EOFileID;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategoryID;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.lib.java.Assert;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOInteger;
import de.plans.lib.xml.primitiveTypes.EOLong;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;

public class EOObjectTypeCategory
extends EOGenericCockpitDatabaseData {
    public static final String XML_NAME = "frame.ObjectTypeCategory";
    private static final String XML_TAG_ATTR_PROJECT_UID = "projectUID";
    private static final String XML_ROLE_ATTR_HUMANREADABLEID = "humanReadableID";
    private static final String XML_ROLE_ATTR_COCKPIT_TYPE_ID = "cockpitTypeID";
    private static final String XML_ROLE_ATTR_DISPLAYNAME = "displayname";
    private static final String XML_ROLE_ATTR_ATTRIBUTELIST = "attribute_list";
    private static final String XML_ROLE_ATTR_SORTPOSITION = "sort_position";
    private static final String XML_ROLE_ATTR_MOD_COUNT = "modCount";
    private static final String XML_ROLE_ATTR_MOD_TIME = "modTime";
    private EOObjectTypeCategoryID uID;
    private EOString humanReadableID;
    private String projectUID;
    private EOString cockpitDataTypeID;
    private EOInteger sortPosition;
    private EOString displayname;
    private EOFileID icon;
    private EOList<EOAttributeTypeID> attributeList;
    private EOInteger modCount;
    private EOLong modTime;

    public EOObjectTypeCategory(EOObjectTypeCategoryID uID, String humanReadableID, String projectUID, String cockpitDataTypeID, int sortPosition, String displayname, EOFileID icon, Collection<EOAttributeTypeID> attributeList, Timestamp modTime, int modCount) {
        super(XML_NAME);
        this.uID = uID;
        this.humanReadableID = new EOString(humanReadableID, XML_ROLE_ATTR_HUMANREADABLEID);
        this.projectUID = projectUID;
        this.displayname = new EOString(displayname, XML_ROLE_ATTR_DISPLAYNAME);
        this.icon = icon;
        this.attributeList = new EOList(attributeList.size());
        this.attributeList.setRole(XML_ROLE_ATTR_ATTRIBUTELIST);
        this.attributeList.addAll(attributeList);
        this.sortPosition = new EOInteger(sortPosition, XML_ROLE_ATTR_SORTPOSITION);
        this.cockpitDataTypeID = new EOString(cockpitDataTypeID, XML_ROLE_ATTR_COCKPIT_TYPE_ID);
        this.modCount = new EOInteger(modCount, XML_ROLE_ATTR_MOD_COUNT);
        this.modTime = new EOLong(modTime.getTime(), XML_ROLE_ATTR_MOD_TIME);
    }

    public EOObjectTypeCategory() {
        super(XML_NAME);
    }

    public EOObjectTypeCategory(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    public String getUID() {
        return this.uID.getObjectTypeCategoryID();
    }

    public EOObjectTypeCategoryID getUIDAsObject() {
        return this.uID;
    }

    public void setUID(EOObjectTypeCategoryID objectTypeCategoryID) {
        this.uID = objectTypeCategoryID;
    }

    public String getHumanReadableID() {
        return this.humanReadableID.getString();
    }

    public void setHumanReadableID(String humanReadableID) {
        assert (Assert.checkArgumentBeeingNotNull((Object)humanReadableID));
        this.humanReadableID = new EOString(humanReadableID, XML_ROLE_ATTR_HUMANREADABLEID);
    }

    @Override
    public String getProjectUID() {
        return this.projectUID;
    }

    @Override
    public void setProjectUID(String projectUID) {
        this.projectUID = projectUID;
    }

    public String getCockpitDataTypeID() {
        return this.cockpitDataTypeID.getString();
    }

    public void setCockpitDataTypeID(String cockpitDataTypeID) {
        this.cockpitDataTypeID = new EOString(cockpitDataTypeID, XML_ROLE_ATTR_COCKPIT_TYPE_ID);
    }

    public String getDisplayName() {
        return this.displayname.getString();
    }

    public void setDisplayName(String newDisplayName) {
        this.displayname = new EOString(newDisplayName, XML_ROLE_ATTR_DISPLAYNAME);
    }

    public EOFileID getIcon() {
        return this.icon;
    }

    public void setIcon(EOFileID icon) {
        this.icon = icon;
    }

    public Collection<EOAttributeTypeID> getAttributeList() {
        ArrayList<EOAttributeTypeID> attributeList_ = new ArrayList<EOAttributeTypeID>(this.attributeList.size());
        attributeList_.addAll((Collection<EOAttributeTypeID>)this.attributeList);
        return attributeList_;
    }

    public int getSortPosition() {
        return this.sortPosition.getInteger();
    }

    @Override
    public int getModCount() {
        return this.modCount.getInteger();
    }

    @Override
    public void setModCount(int modCount) {
        this.modCount = new EOInteger(modCount, XML_ROLE_ATTR_MOD_COUNT);
    }

    public Timestamp getModTime() {
        return new Timestamp(this.modTime.getValue());
    }

    public void setModTime(Timestamp modTime) {
        this.modTime = new EOLong(modTime.getTime(), XML_ROLE_ATTR_MOD_TIME);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, XML_TAG_ATTR_PROJECT_UID, this.projectUID);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        if (!name.equals(XML_TAG_ATTR_PROJECT_UID)) {
            return false;
        }
        this.projectUID = value;
        return true;
    }

    @Override
    protected boolean hasChildren() {
        return true;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.uID.writeXMLBody(writeContext, depth);
        this.humanReadableID.writeXMLBody(writeContext, depth);
        this.cockpitDataTypeID.writeXMLBody(writeContext, depth);
        this.displayname.writeXMLBody(writeContext, depth);
        this.icon.writeXMLBody(writeContext, depth);
        this.attributeList.writeXMLBody(writeContext, depth);
        this.sortPosition.writeXMLBody(writeContext, depth);
        this.modCount.writeXMLBody(writeContext, depth);
        this.modTime.writeXMLBody(writeContext, depth);
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOObjectTypeCategoryID) {
            this.uID = (EOObjectTypeCategoryID)newChild;
            return true;
        }
        if (newChild instanceof EOString) {
            EOString eoString = (EOString)newChild;
            String role = eoString.getRole();
            if (role.equals(XML_ROLE_ATTR_HUMANREADABLEID)) {
                this.humanReadableID = eoString;
            } else if (role.equals(XML_ROLE_ATTR_DISPLAYNAME)) {
                this.displayname = eoString;
            } else if (role.equals(XML_ROLE_ATTR_COCKPIT_TYPE_ID)) {
                this.cockpitDataTypeID = eoString;
            } else {
                return false;
            }
            return true;
        }
        if (newChild instanceof EOInteger) {
            EOInteger eoInteger = (EOInteger)newChild;
            String role = eoInteger.getRole();
            if (role.equals(XML_ROLE_ATTR_MOD_COUNT)) {
                this.modCount = eoInteger;
            } else if (role.equals(XML_ROLE_ATTR_SORTPOSITION)) {
                this.sortPosition = eoInteger;
            } else {
                return false;
            }
            return true;
        }
        if (newChild instanceof EOLong) {
            EOLong eoLong = (EOLong)newChild;
            if (eoLong.getRole().equals(XML_ROLE_ATTR_MOD_TIME)) {
                this.modTime = eoLong;
                return true;
            }
            return false;
        }
        if (newChild instanceof EOFileID) {
            EOFileID fileID;
            this.icon = fileID = (EOFileID)newChild;
            return true;
        }
        if (newChild instanceof EOList) {
            EOList eoList = (EOList)newChild;
            if (eoList.getRole().equals(XML_ROLE_ATTR_ATTRIBUTELIST)) {
                this.attributeList = eoList;
                return true;
            }
            return false;
        }
        return false;
    }
}

