/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.lib.java.Assert;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EOCurrentCommitVersions
extends EOEncodableObject {
    public static final String XML_TAG = "currentCommitVersions";
    private Map<String, List<String>> projectUID2CommitUIDs = new HashMap<String, List<String>>();

    public EOCurrentCommitVersions(Map<String, List<String>> projectUID2CommitUIDs) {
        super(XML_TAG);
        Assert.checkArgumentBeeingNotNull(projectUID2CommitUIDs);
        this.projectUID2CommitUIDs = projectUID2CommitUIDs;
    }

    public EOCurrentCommitVersions(XMLContext xmlContext) {
        super(XML_TAG, xmlContext);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        return false;
    }

    protected final void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (Map.Entry<String, List<String>> entry : this.projectUID2CommitUIDs.entrySet()) {
            String projectUID = entry.getKey();
            List<String> commitUIDs = entry.getValue();
            for (String commitUID : commitUIDs) {
                EOString stringAsEO = new EOString(commitUID, projectUID);
                stringAsEO.writeXMLBody(writeContext, depth);
            }
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success;
        if (newChild instanceof EOString) {
            EOString childAsEOString = (EOString)newChild;
            String projectUID = childAsEOString.getRole();
            String commitUID = childAsEOString.getString();
            if (this.projectUID2CommitUIDs.containsKey(projectUID)) {
                List<String> commitUIDs = this.projectUID2CommitUIDs.get(projectUID);
                commitUIDs.add(commitUID);
            } else {
                ArrayList<String> commitUIDs = new ArrayList<String>();
                commitUIDs.add(commitUID);
                this.projectUID2CommitUIDs.put(projectUID, commitUIDs);
            }
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public List<String> getCommitUIDs(String projectUID) {
        return this.projectUID2CommitUIDs.get(projectUID);
    }

    public Map<String, List<String>> getProjectUID2CommitUIDs() {
        return this.projectUID2CommitUIDs;
    }
}

