/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.frame;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeBoolean;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDouble;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEOUser;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationMultiple;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationNEW;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationSingle;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeInteger;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeLanguage;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeReportOutputTemplateType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeURL;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.ValueRangeDefinerEnumeration;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.AbstractDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.DataTypeFile;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.DataTypeImage;
import com.arcway.cockpit.frame.client.project.core.locking.LockTypeDescriptionProvider;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.AbstractFrontendDataTypeEnumeration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTBoolean;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDateUTC64Bitmsec;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFile;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFloat64BitIEEE754;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeString;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeText;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTInteger32Bit;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTLocale;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTURL;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.clientadapter.implementation.adapter.frame.RepositoryFileID;
import com.arcway.repository.clientadapter.implementation.adapter.reporttemplates.DataManagerAdapterReportOutputTemplate;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.IIDSampleAndLock;
import com.arcway.repository.clientadapter.interFace.ILock;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.IIDSampleAndLockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.AbstractEXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTCounter64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import com.arcway.repository.lib.high.registration.data.lib.RDTFloat64BitIEEE754;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger32Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTLocale;
import com.arcway.repository.lib.high.registration.data.lib.RDTMultipleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.RDTURL;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class FrameDataConverter {
    public static final String ENUMERATION_PREFIX = "e";

    public static final EXPermissionDenied convertEXCockpitPermissionDenied(EXCockpitPermissionDenied cockpitEXPermissionDenied) {
        return new EXPermissionDenied(cockpitEXPermissionDenied.getLocalizedUserHints(), (Exception)cockpitEXPermissionDenied);
    }

    public static final EXLockDenied convertEXCockpitLockDenied(EXCockpitLockDenied cockpitEXLockDenied) {
        EXLockDenied convertedException;
        EOLock[] conflictingLocks = cockpitEXLockDenied.getConflictingLocks();
        if (conflictingLocks != null) {
            String[] details = cockpitEXLockDenied.getLocalizedOtherReasons();
            HashSet_ conflictingLockInformation = new HashSet_(conflictingLocks.length, AbstractEXLockDenied.ConflictingLockInformation.EQUAL_LOCK_INFORMATION_HASHER);
            int i = 0;
            while (i < conflictingLocks.length) {
                EOLock conflictingLock = conflictingLocks[i];
                String detail = details == null || i >= details.length ? null : details[i];
                String username = conflictingLock.getUserName();
                String clientname = conflictingLock.getClientName();
                String lockTypeID = conflictingLock.getLockTypeID();
                String lockedItemType = conflictingLock.getLockedItemType();
                String localizedLockType = LockTypeDescriptionProvider.getLocalizedLockTypeDescription(lockTypeID);
                if (localizedLockType == null) {
                    localizedLockType = lockTypeID;
                }
                if (lockTypeID.equals("link_lock_linkable_object") || lockTypeID.equals("link_lock_module_data")) {
                    localizedLockType = String.valueOf(localizedLockType) + " (" + lockedItemType + ")";
                }
                AbstractEXLockDenied.ConflictingLockInformation lockInformation = new AbstractEXLockDenied.ConflictingLockInformation(username, clientname, localizedLockType, detail);
                conflictingLockInformation.add((Object)lockInformation);
                ++i;
            }
            convertedException = new EXLockDenied((ISet_)conflictingLockInformation);
        } else {
            convertedException = new EXLockDenied(cockpitEXLockDenied.getLocalizedOtherReasons());
        }
        return convertedException;
    }

    public static final ILockDeprecated convertLock(final ILock cockpitLock) {
        Assert.checkArgumentBeeingNotNull((Object)cockpitLock);
        return new ILockDeprecated(){

            public void release() {
                cockpitLock.release();
            }
        };
    }

    public static final IIDSampleAndLockDeprecated convertSampleAndLock(final IIDSampleAndLock cockpitSampleAndLock) {
        Assert.checkArgumentBeeingNotNull((Object)cockpitSampleAndLock);
        return new IIDSampleAndLockDeprecated(){

            public IRepositoryData getIDSample() {
                return cockpitSampleAndLock.getIDSample();
            }

            public ILockDeprecated getTemporaryLock() {
                ILock lock = cockpitSampleAndLock.getTemporaryLock();
                ILockDeprecated lockDeprecated = lock == null ? null : FrameDataConverter.convertLock(lock);
                return lockDeprecated;
            }
        };
    }

    public static final ILockDeprecated convertLocks(final ILock[] cockpitLocks) {
        Assert.checkArgumentBeeingNotNull((Object)cockpitLocks);
        return new ILockDeprecated(){

            public void release() {
                ILock[] iLockArray = cockpitLocks;
                int n = cockpitLocks.length;
                int n2 = 0;
                while (n2 < n) {
                    ILock element = iLockArray[n2];
                    element.release();
                    ++n2;
                }
            }
        };
    }

    public static DataTypeIDWithParameters convertCockpitAttributeTypeDataTypeToRepositoryDataType(IFrameProjectAgent projectAgent, IAttributeTypeDataType sourceAttributeTypeDataType, IValueRange sourceValueRange) {
        To.makeNotNull((Object)sourceValueRange);
        DataTypeIDWithParameters dataTypeWithParameters = new DataTypeIDWithParameters();
        if (sourceAttributeTypeDataType instanceof DataTypeBoolean) {
            dataTypeWithParameters.repositoryDataTypeID = RDTBoolean.DATA_TYPE_ID;
            dataTypeWithParameters.repositoryDataTypeParameters = RDTBoolean.Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE;
            dataTypeWithParameters.frontendDataTypeParameters = FDTBoolean.Parameters.YES_NO;
        } else if (sourceAttributeTypeDataType instanceof DataTypeInteger) {
            dataTypeWithParameters.repositoryDataTypeID = RDTInteger32Bit.DATA_TYPE_ID;
            dataTypeWithParameters.repositoryDataTypeParameters = RDTInteger32Bit.Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE;
            dataTypeWithParameters.frontendDataTypeParameters = FDTInteger32Bit.Parameters.DEFAULTS;
        } else if (sourceAttributeTypeDataType instanceof DataTypeDouble) {
            dataTypeWithParameters.repositoryDataTypeID = RDTFloat64BitIEEE754.DATA_TYPE_ID;
            dataTypeWithParameters.repositoryDataTypeParameters = RDTFloat64BitIEEE754.Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE;
            dataTypeWithParameters.frontendDataTypeParameters = FDTFloat64BitIEEE754.Parameters.DEFAULTS;
        } else if (sourceAttributeTypeDataType instanceof DataTypeDate) {
            dataTypeWithParameters.repositoryDataTypeID = RDTDateUTC64Bitmsec.DATA_TYPE_ID;
            dataTypeWithParameters.repositoryDataTypeParameters = RDTDateUTC64Bitmsec.Parameters.PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_ONLY;
            dataTypeWithParameters.frontendDataTypeParameters = FDTDateUTC64Bitmsec.Parameters.DEFAULTS;
        } else if (sourceAttributeTypeDataType instanceof DataTypeEnumerationSingle) {
            DataTypeEnumerationSingle typedSourceAttributeTypeDataType = (DataTypeEnumerationSingle)sourceAttributeTypeDataType;
            dataTypeWithParameters.repositoryDataTypeID = RDTSingleChoice.DATA_TYPE_ID;
            IList_<Tuple<String, String>> enumerationKeys = FrameDataConverter.getEnumerationKeys(typedSourceAttributeTypeDataType, sourceValueRange);
            IMapRW_<String, IFrontendLabel> enumerationLabels = FrameDataConverter.getEnumerationLabels(typedSourceAttributeTypeDataType, sourceValueRange);
            dataTypeWithParameters.repositoryDataTypeParameters = RDTSingleChoice.SingleChoiceParameters.PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE(enumerationKeys);
            dataTypeWithParameters.frontendDataTypeParameters = AbstractFrontendDataTypeEnumeration.Parameters.DEFAULTS(enumerationLabels);
        } else if (sourceAttributeTypeDataType instanceof DataTypeEnumerationMultiple) {
            DataTypeEnumerationMultiple typedSourceAttributeTypeDataType = (DataTypeEnumerationMultiple)sourceAttributeTypeDataType;
            dataTypeWithParameters.repositoryDataTypeID = RDTMultipleChoice.DATA_TYPE_ID;
            IList_<Tuple<String, String>> enumerationKeys = FrameDataConverter.getEnumerationKeys(typedSourceAttributeTypeDataType, sourceValueRange);
            IMapRW_<String, IFrontendLabel> enumerationLabels = FrameDataConverter.getEnumerationLabels(typedSourceAttributeTypeDataType, sourceValueRange);
            dataTypeWithParameters.repositoryDataTypeParameters = RDTMultipleChoice.MultipleChoiceParameters.DEFAULTS(enumerationKeys);
            dataTypeWithParameters.frontendDataTypeParameters = AbstractFrontendDataTypeEnumeration.Parameters.DEFAULTS(enumerationLabels);
        } else if (sourceAttributeTypeDataType instanceof DataTypeString) {
            if (sourceAttributeTypeDataType instanceof DataTypeText) {
                dataTypeWithParameters.repositoryDataTypeID = RDTFreeText.DATA_TYPE_ID;
                dataTypeWithParameters.repositoryDataTypeParameters = RDTFreeText.Parameters.PARAMETERS__IS_SET_ALWAYS__POTENTIALLY_EMPTY;
                dataTypeWithParameters.frontendDataTypeParameters = FDTFreeText.Parameters.DEFAULTS;
            } else {
                dataTypeWithParameters.repositoryDataTypeID = RDTFreeString.DATA_TYPE_ID;
                dataTypeWithParameters.repositoryDataTypeParameters = RDTFreeString.Parameters.PARAMETERS__IS_SET_ALWAYS__POTENTIALLY_EMPTY;
                dataTypeWithParameters.frontendDataTypeParameters = FDTFreeString.Parameters.DEFAULTS;
            }
        } else if (sourceAttributeTypeDataType instanceof DataTypeURL) {
            dataTypeWithParameters.repositoryDataTypeID = RDTURL.DATA_TYPE_ID;
            dataTypeWithParameters.repositoryDataTypeParameters = RDTURL.Parameters.PARAMETERS__IS_SET_POTENTIALLY;
            dataTypeWithParameters.frontendDataTypeParameters = FDTURL.Parameters.DEFAULTS;
        } else if (sourceAttributeTypeDataType instanceof DataTypeLanguage) {
            dataTypeWithParameters.repositoryDataTypeID = RDTLocale.DATA_TYPE_ID;
            dataTypeWithParameters.repositoryDataTypeParameters = RDTLocale.Parameters.PARAMETERS__IS_SET_POTENTIALLY__LANUGAGE;
            dataTypeWithParameters.frontendDataTypeParameters = FDTLocale.Parameters.DEFAULTS;
        } else {
            if (sourceAttributeTypeDataType instanceof DataTypeEOUser) {
                throw new UnsupportedOperationException();
            }
            if (sourceAttributeTypeDataType instanceof DataTypeFile) {
                dataTypeWithParameters.repositoryDataTypeID = RDTFile.DATA_TYPE_ID;
                dataTypeWithParameters.repositoryDataTypeParameters = RDTFile.Parameters.PARAMETERS__IS_SET_POTENTIALLY__ALLOW_ALL_FILENAME_POSTFIXES;
                dataTypeWithParameters.frontendDataTypeParameters = FDTFile.Parameters.PARAMETERS__SHOW_FILENAME_ONLY;
            } else {
                if (sourceAttributeTypeDataType instanceof DataTypeImage) {
                    dataTypeWithParameters.repositoryDataTypeID = RDTFile.DATA_TYPE_ID;
                    dataTypeWithParameters.repositoryDataTypeParameters = RDTFile.Parameters.PARAMETERS__IS_SET_POTENTIALLY__ALLOW_IMAGE_FILENAME_POSTFIXES;
                    dataTypeWithParameters.frontendDataTypeParameters = FDTFile.Parameters.PARAMETERS__SHOW_FILECONTENT_AS_IMAGE;
                    throw new UnsupportedOperationException();
                }
                if (sourceAttributeTypeDataType instanceof DataTypeReportOutputTemplateType) {
                    dataTypeWithParameters.repositoryDataTypeID = RDTSingleChoice.DATA_TYPE_ID;
                    dataTypeWithParameters.repositoryDataTypeParameters = DataManagerAdapterReportOutputTemplate.createRepositoryDataTypeParametersForReportOutputType(projectAgent);
                    dataTypeWithParameters.frontendDataTypeParameters = DataManagerAdapterReportOutputTemplate.createFrontendDataTypeParametersForReportOutputType(projectAgent);
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
        }
        return dataTypeWithParameters;
    }

    private static IList_<Tuple<String, String>> getEnumerationKeys(DataTypeEnumerationNEW dataTypeEnumeration, IValueRange valueRange) {
        ValueRangeDefinerEnumeration valueRangeDefiner = dataTypeEnumeration.getValueRangeHelper();
        List<EnumerationEntry> allowedValues = valueRangeDefiner.getAllowedValues(valueRange);
        ArrayList_ enumerationKeys = new ArrayList_(allowedValues.size());
        for (EnumerationEntry enumerationEntry : allowedValues) {
            String elementID = ENUMERATION_PREFIX + enumerationEntry.getID();
            enumerationKeys.add((Object)new Tuple((Object)elementID, (Object)dataTypeEnumeration.getBaseDataType().getValueAsSingleLineString(enumerationEntry.getValue(), valueRange, ",", Locale.getDefault())));
        }
        return enumerationKeys;
    }

    private static IMapRW_<String, IFrontendLabel> getEnumerationLabels(DataTypeEnumerationNEW dataTypeEnumeration, IValueRange valueRange) {
        IAttributeTypeDataType elementDataType = dataTypeEnumeration.getBaseDataType();
        ValueRangeDefinerEnumeration valueRangeDefiner = dataTypeEnumeration.getValueRangeHelper();
        List<EnumerationEntry> allowedValues = valueRangeDefiner.getAllowedValues(valueRange);
        HashMap_ enumerationLabels = new HashMap_(allowedValues.size(), IHasher_.EQUALS_HASHER);
        for (EnumerationEntry enumerationEntry : allowedValues) {
            String elementLabel;
            String elementID = ENUMERATION_PREFIX + enumerationEntry.getID();
            Object value = enumerationEntry.getValue();
            if (elementDataType instanceof DataTypeString) {
                elementLabel = (String)value;
            } else if (elementDataType instanceof DataTypeInteger) {
                int intValue = (Integer)value;
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setGroupingUsed(false);
                numberFormat.setMaximumFractionDigits(0);
                numberFormat.setMinimumFractionDigits(0);
                elementLabel = numberFormat.format(intValue);
            } else {
                throw new UnsupportedOperationException();
            }
            IStreamResource icon16x16 = null;
            FrontendLabel labelDeclaration = new FrontendLabel(elementLabel, icon16x16);
            enumerationLabels.put((Object)elementID, (Object)labelDeclaration);
        }
        return enumerationLabels;
    }

    public static IRepositoryData convertCockpitValueToRepositoryDataSample(IAttributeTypeDataType sourceAttributeTypeDataType, Object sourceValue, IRepositoryDataTypeID targetDataTypeID) {
        Assert.checkArgumentBeeingNotNull((Object)sourceAttributeTypeDataType);
        Assert.checkArgumentBeeingNotNull((Object)targetDataTypeID);
        if (sourceAttributeTypeDataType instanceof DataTypeBoolean) {
            Boolean typedSourceValue = (Boolean)sourceValue;
            if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTBoolean.DATA_TYPE_ID)) {
                return RDTBoolean.getInstance().createData(typedSourceValue);
            }
        } else if (sourceAttributeTypeDataType instanceof DataTypeInteger) {
            Integer typedSourceValue = (Integer)sourceValue;
            if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTInteger32Bit.DATA_TYPE_ID)) {
                return RDTInteger32Bit.getInstance().createData(typedSourceValue);
            }
            if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTInteger64Bit.DATA_TYPE_ID)) {
                Long longValue = typedSourceValue == null ? null : Long.valueOf(typedSourceValue.longValue());
                return RDTInteger64Bit.getInstance().createData(longValue);
            }
            if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTCounter64Bit.DATA_TYPE_ID)) {
                Long longValue = typedSourceValue == null ? null : Long.valueOf(typedSourceValue.longValue());
                return RDTCounter64Bit.getInstance().createData(longValue);
            }
        } else if (sourceAttributeTypeDataType instanceof DataTypeDouble) {
            Double typedSourceValue = (Double)sourceValue;
            if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTFloat64BitIEEE754.DATA_TYPE_ID)) {
                return RDTFloat64BitIEEE754.getInstance().createData(typedSourceValue);
            }
        } else if (sourceAttributeTypeDataType instanceof DataTypeDate) {
            Date date;
            String typedSourceValue = (String)sourceValue;
            if (typedSourceValue != null && typedSourceValue.length() > 0) {
                try {
                    long ms = Long.valueOf(typedSourceValue);
                    date = new Date(ms);
                }
                catch (NumberFormatException e) {
                    date = null;
                }
            } else {
                date = null;
            }
            if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTDateUTC64Bitmsec.DATA_TYPE_ID)) {
                return RDTDateUTC64Bitmsec.getInstance().createData(date);
            }
        } else {
            if (sourceAttributeTypeDataType instanceof DataTypeEnumerationSingle) {
                String selectedEntryID;
                DataTypeEnumerationSingle dataTypeEnumerationSingle = (DataTypeEnumerationSingle)sourceAttributeTypeDataType;
                List<EnumerationEntry> selectedEnumerationEntries = dataTypeEnumerationSingle.getEnumerationEntries(sourceValue);
                Iterator i = selectedEnumerationEntries.iterator();
                if (i.hasNext()) {
                    EnumerationEntry selectedEntry = (EnumerationEntry)i.next();
                    selectedEntryID = ENUMERATION_PREFIX + selectedEntry.getID();
                } else {
                    selectedEntryID = null;
                }
                RDTSingleChoice typedDataType = RDTSingleChoice.getInstance();
                IRepositoryData repositoryData = typedDataType.createData(selectedEntryID);
                return repositoryData;
            }
            if (sourceAttributeTypeDataType instanceof DataTypeEnumerationMultiple) {
                DataTypeEnumerationMultiple dataTypeEnumerationMultiple = (DataTypeEnumerationMultiple)sourceAttributeTypeDataType;
                List<EnumerationEntry> selectedEnumerationEntries = dataTypeEnumerationMultiple.getEnumerationEntries(sourceValue);
                HashSet<String> selectedEntryIDs = new HashSet<String>(selectedEnumerationEntries.size());
                int index = 0;
                for (EnumerationEntry selectedEntry : selectedEnumerationEntries) {
                    selectedEntryIDs.add(ENUMERATION_PREFIX + selectedEntry.getID());
                    ++index;
                }
                return RDTMultipleChoice.getInstance().createData(selectedEntryIDs);
            }
            if (sourceAttributeTypeDataType instanceof DataTypeString) {
                String typedSourceValue = (String)sourceValue;
                if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTUID.DATA_TYPE_ID)) {
                    return RDTUID.getInstance().createData(typedSourceValue);
                }
                if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTDisplayName.DATA_TYPE_ID)) {
                    return RDTDisplayName.getInstance().createData(typedSourceValue);
                }
                if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTFreeString.DATA_TYPE_ID)) {
                    return RDTFreeString.getInstance().createData(typedSourceValue);
                }
                if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTFreeText.DATA_TYPE_ID)) {
                    return RDTFreeText.getInstance().createData(typedSourceValue);
                }
            } else if (sourceAttributeTypeDataType instanceof DataTypeURL) {
                URL url;
                String typedSourceValue = (String)sourceValue;
                if (typedSourceValue == null || typedSourceValue.trim().length() == 0) {
                    url = null;
                } else {
                    try {
                        url = new URL(typedSourceValue);
                    }
                    catch (MalformedURLException e) {
                        try {
                            url = new URL("http://" + typedSourceValue);
                        }
                        catch (MalformedURLException e1) {
                            url = null;
                        }
                    }
                }
                if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTURL.DATA_TYPE_ID)) {
                    return RDTURL.getInstance().createData(url);
                }
            } else if (sourceAttributeTypeDataType instanceof DataTypeLanguage) {
                String typedSourceValue = (String)sourceValue;
                Locale locale = typedSourceValue != null && typedSourceValue.length() > 0 ? new Locale(typedSourceValue) : null;
                if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTLocale.DATA_TYPE_ID)) {
                    return RDTLocale.getInstance().createData(locale);
                }
            } else if (!(sourceAttributeTypeDataType instanceof DataTypeEOUser)) {
                if (sourceAttributeTypeDataType instanceof AbstractDataTypeWithFile) {
                    FileID typedSourceValue = (FileID)sourceValue;
                    if (IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)targetDataTypeID, (Object)RDTFile.DATA_TYPE_ID)) {
                        RepositoryFileID repositoryFileID = typedSourceValue.equals(FileID.NO_FILE) ? null : new RepositoryFileID(typedSourceValue);
                        return RDTFile.getInstance().createData((IRepositoryFileID)repositoryFileID);
                    }
                } else if (sourceAttributeTypeDataType instanceof DataTypeReportOutputTemplateType) {
                    String reportOutputType;
                    String selectedEntryID = reportOutputType = (String)sourceValue;
                    return RDTSingleChoice.getInstance().createData(selectedEntryID);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public static IRepositoryData convertCockpitAttributeToRepositoryData(IAttributeTypeDataType sourceAttributeTypeDataType, IValueRange sourceValueRange, Object sourceValue, IRepositoryDataType targetDataType, IRepositoryDataTypeParameters targetDataTypeParameters) {
        Assert.checkArgumentBeeingNotNull((Object)sourceAttributeTypeDataType);
        Assert.checkArgumentBeeingNotNull((Object)targetDataType);
        Assert.checkArgumentBeeingNotNull((Object)targetDataTypeParameters);
        To.makeNotNull((Object)sourceValueRange);
        Assert.checkArgumentBeeingNotNull((Object)sourceAttributeTypeDataType);
        IRepositoryDataTypeID targetDataTypeID = targetDataType.getRepositoryDataTypeID();
        try {
            IRepositoryData repositoryData = FrameDataConverter.convertCockpitValueToRepositoryDataSample(sourceAttributeTypeDataType, sourceValue, targetDataTypeID);
            targetDataType.snapAndCheckData(repositoryData, targetDataTypeParameters);
            return repositoryData;
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object convertRepositoryDataToCockpitAttribute(IRepositoryData sourceRepositoryData, IAttributeTypeDataType targetCockpitDataType, IValueRange targetCockpitValueRange) {
        To.makeNotNull((Object)targetCockpitValueRange);
        IRepositoryDataType sourceRepositoryDataType = sourceRepositoryData.getDataType();
        if (targetCockpitDataType instanceof DataTypeBoolean) {
            if (!(sourceRepositoryDataType instanceof RDTBoolean)) throw new UnsupportedOperationException();
            RDTBoolean typedTargetDataType = (RDTBoolean)sourceRepositoryDataType;
            Boolean typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
            return typedSourceValue;
        }
        if (targetCockpitDataType instanceof DataTypeInteger) {
            if (sourceRepositoryDataType instanceof RDTInteger32Bit) {
                RDTInteger32Bit typedTargetDataType = (RDTInteger32Bit)sourceRepositoryDataType;
                Integer typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
                return typedSourceValue;
            }
            if (sourceRepositoryDataType instanceof RDTInteger64Bit) {
                RDTInteger64Bit typedTargetDataType = (RDTInteger64Bit)sourceRepositoryDataType;
                Long typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
                if (typedSourceValue == null) return null;
                return typedSourceValue.intValue();
            }
            if (!(sourceRepositoryDataType instanceof RDTCounter64Bit)) throw new UnsupportedOperationException();
            RDTCounter64Bit typedTargetDataType = (RDTCounter64Bit)sourceRepositoryDataType;
            Long typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
            return typedSourceValue.intValue();
        }
        if (targetCockpitDataType instanceof DataTypeDouble) {
            if (!(sourceRepositoryDataType instanceof RDTFloat64BitIEEE754)) throw new UnsupportedOperationException();
            RDTFloat64BitIEEE754 typedTargetDataType = (RDTFloat64BitIEEE754)sourceRepositoryDataType;
            Double typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
            return typedSourceValue;
        }
        if (targetCockpitDataType instanceof DataTypeDate) {
            if (!(sourceRepositoryDataType instanceof RDTDateUTC64Bitmsec)) throw new UnsupportedOperationException();
            RDTDateUTC64Bitmsec typedTargetDataType = (RDTDateUTC64Bitmsec)sourceRepositoryDataType;
            Date typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
            if (typedSourceValue == null) return "";
            Long l = typedSourceValue.getTime();
            return l.toString();
        }
        if (targetCockpitDataType instanceof DataTypeEnumerationSingle) {
            List selectedEnumerationEntries;
            DataTypeEnumerationSingle dataTypeEnumerationMultiple = (DataTypeEnumerationSingle)targetCockpitDataType;
            ValueRangeDefinerEnumeration valueRangeDefinerEnumeration = dataTypeEnumerationMultiple.getValueRangeHelper();
            List<EnumerationEntry> allowedValues = valueRangeDefinerEnumeration.getAllowedValues(targetCockpitValueRange);
            RDTSingleChoice rdt = RDTSingleChoice.getInstance();
            String selectedEntryID = rdt.dataToValue(sourceRepositoryData);
            if (selectedEntryID != null) {
                selectedEnumerationEntries = new ArrayList(1);
                EnumerationEntry selectedEntry = null;
                for (EnumerationEntry currentEnumerationEntry : allowedValues) {
                    if (!currentEnumerationEntry.getID().equals(selectedEntryID.substring(ENUMERATION_PREFIX.length()))) continue;
                    selectedEntry = currentEnumerationEntry;
                }
                Assert.checkArgumentBeeingNotNull(selectedEntry);
                selectedEnumerationEntries.add(selectedEntry);
                return selectedEnumerationEntries;
            } else {
                selectedEnumerationEntries = Collections.emptyList();
            }
            return selectedEnumerationEntries;
        }
        if (targetCockpitDataType instanceof DataTypeEnumerationMultiple) {
            List selectedEnumerationEntries;
            DataTypeEnumerationMultiple dataTypeEnumerationMultiple = (DataTypeEnumerationMultiple)targetCockpitDataType;
            ValueRangeDefinerEnumeration valueRangeDefinerEnumeration = dataTypeEnumerationMultiple.getValueRangeHelper();
            List<EnumerationEntry> allowedValues = valueRangeDefinerEnumeration.getAllowedValues(targetCockpitValueRange);
            RDTMultipleChoice rdt = RDTMultipleChoice.getInstance();
            Set selectedEntryIDsAsArray = rdt.dataToValue(sourceRepositoryData);
            if (selectedEntryIDsAsArray != null) {
                selectedEnumerationEntries = new ArrayList(selectedEntryIDsAsArray.size());
                for (String selectedEntryID : selectedEntryIDsAsArray) {
                    EnumerationEntry selectedEntry = null;
                    for (EnumerationEntry currentEnumerationEntry : allowedValues) {
                        if (!currentEnumerationEntry.getID().equals(selectedEntryID.substring(ENUMERATION_PREFIX.length()))) continue;
                        selectedEntry = currentEnumerationEntry;
                    }
                    Assert.checkArgumentBeeingNotNull(selectedEntry);
                    selectedEnumerationEntries.add(selectedEntry);
                }
                return selectedEnumerationEntries;
            } else {
                selectedEnumerationEntries = Collections.emptyList();
            }
            return selectedEnumerationEntries;
        }
        if (targetCockpitDataType instanceof DataTypeString) {
            if (sourceRepositoryDataType instanceof RDTUID) {
                RDTUID typedTargetDataType = (RDTUID)sourceRepositoryDataType;
                String typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
                return typedSourceValue;
            }
            if (sourceRepositoryDataType instanceof RDTDisplayName) {
                RDTDisplayName typedTargetDataType = (RDTDisplayName)sourceRepositoryDataType;
                String typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
                return typedSourceValue;
            }
            if (sourceRepositoryDataType instanceof RDTFreeString) {
                RDTFreeString typedTargetDataType = (RDTFreeString)sourceRepositoryDataType;
                String typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
                return typedSourceValue;
            }
            if (!(sourceRepositoryDataType instanceof RDTFreeText)) throw new UnsupportedOperationException();
            RDTFreeText typedTargetDataType = (RDTFreeText)sourceRepositoryDataType;
            String typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
            return typedSourceValue;
        }
        if (targetCockpitDataType instanceof DataTypeURL) {
            if (!(sourceRepositoryDataType instanceof RDTURL)) throw new UnsupportedOperationException();
            RDTURL typedTargetDataType = (RDTURL)sourceRepositoryDataType;
            URL typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
            if (typedSourceValue == null) return "";
            return typedSourceValue.toExternalForm();
        }
        if (targetCockpitDataType instanceof DataTypeLanguage) {
            if (!(sourceRepositoryDataType instanceof RDTLocale)) throw new UnsupportedOperationException();
            RDTLocale typedTargetDataType = (RDTLocale)sourceRepositoryDataType;
            Locale typedSourceValue = typedTargetDataType.dataToValue(sourceRepositoryData);
            if (typedSourceValue == null) return null;
            return typedSourceValue.getLanguage();
        }
        if (targetCockpitDataType instanceof DataTypeEOUser) {
            throw new UnsupportedOperationException();
        }
        if (targetCockpitDataType instanceof AbstractDataTypeWithFile) {
            if (!(sourceRepositoryDataType instanceof RDTFile)) throw new UnsupportedOperationException();
            RDTFile typedTargetDataType = (RDTFile)sourceRepositoryDataType;
            IRepositoryFileID typedSourceValue = typedTargetDataType.dataToFileID(sourceRepositoryData);
            if (typedSourceValue == null) return FileID.NO_FILE;
            return RepositoryFileID.convertRepositoryFileID(typedSourceValue).getFileID();
        }
        if (!(targetCockpitDataType instanceof DataTypeReportOutputTemplateType)) throw new UnsupportedOperationException();
        RDTSingleChoice rdt = RDTSingleChoice.getInstance();
        String selectedEntryID = rdt.dataToValue(sourceRepositoryData);
        return selectedEntryID;
    }

    public static class DataTypeIDWithParameters {
        public IRepositoryDataTypeID repositoryDataTypeID;
        public IRepositoryDataTypeParameters repositoryDataTypeParameters;
        public IFrontendDataTypeParameters frontendDataTypeParameters;
    }
}

