/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.frame;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import java.util.HashMap;
import java.util.Map;

public class AttributeTypeID2PropertyTypeMap {
    private final IAttributeTypeID[] attributeTypeIDs;
    private final IPropertyType[] propertyTypes;
    private final Map<AttributeTypeIDKey, IPropertyType> attributeTypeIDKey2propertyType = new HashMap<AttributeTypeIDKey, IPropertyType>();
    private final Map<PropertyTypeIDKey, IAttributeTypeID> propertyTypeIDKey2attributeTypeID = new HashMap<PropertyTypeIDKey, IAttributeTypeID>();
    private final Map<PropertyTypeIDKey, IPropertyType> propertyTypeIDKey2propertyType = new HashMap<PropertyTypeIDKey, IPropertyType>();

    public AttributeTypeID2PropertyTypeMap(IAttributeTypeID[] attributeTypeIDs, IPropertyType[] propertyTypes) {
        this.attributeTypeIDs = attributeTypeIDs;
        this.propertyTypes = propertyTypes;
        int i = 0;
        while (i < attributeTypeIDs.length) {
            AttributeTypeIDKey attributeTypeIDKey = new AttributeTypeIDKey(attributeTypeIDs[i]);
            this.attributeTypeIDKey2propertyType.put(attributeTypeIDKey, propertyTypes[i]);
            ++i;
        }
        i = 0;
        while (i < propertyTypes.length) {
            PropertyTypeIDKey propertyTypeIDKey = new PropertyTypeIDKey(propertyTypes[i].getPropertyTypeID());
            this.propertyTypeIDKey2propertyType.put(propertyTypeIDKey, propertyTypes[i]);
            this.propertyTypeIDKey2attributeTypeID.put(propertyTypeIDKey, attributeTypeIDs[i]);
            ++i;
        }
    }

    public IAttributeTypeID[] getAttributeTypeIDs() {
        return this.attributeTypeIDs;
    }

    public IPropertyType[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public IAttributeTypeID getAttributeTypeIDByPropertyTypeID(IRepositoryPropertyTypeID propertyTypeID) {
        return this.propertyTypeIDKey2attributeTypeID.get(new PropertyTypeIDKey(propertyTypeID));
    }

    public IPropertyType getPropertyTypeByPropertyTypeID(IRepositoryPropertyTypeID propertyTypeID) {
        return this.propertyTypeIDKey2propertyType.get(new PropertyTypeIDKey(propertyTypeID));
    }

    public IPropertyType getPropertyTypeByAttributeTypeID(IAttributeTypeID attributeTypeID) {
        return this.attributeTypeIDKey2propertyType.get(new AttributeTypeIDKey(attributeTypeID));
    }

    private class AttributeTypeIDKey {
        private final IAttributeTypeID attributeTypeID;

        private AttributeTypeIDKey(IAttributeTypeID attributeTypeID) {
            this.attributeTypeID = attributeTypeID;
        }

        public int hashCode() {
            return this.attributeTypeID.getUID().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AttributeTypeIDKey)) {
                return false;
            }
            AttributeTypeIDKey attributeTypeIDKey = (AttributeTypeIDKey)obj;
            return attributeTypeIDKey.attributeTypeID.getUID().equals(this.attributeTypeID.getUID());
        }
    }

    private class PropertyTypeIDKey {
        private final IRepositoryPropertyTypeID propertyTypeID;

        private PropertyTypeIDKey(IRepositoryPropertyTypeID propertyTypeID) {
            this.propertyTypeID = propertyTypeID;
        }

        public int hashCode() {
            return this.propertyTypeID.toCanonicalString().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PropertyTypeIDKey)) {
                return false;
            }
            PropertyTypeIDKey propertyTypeIDKey = (PropertyTypeIDKey)obj;
            return propertyTypeIDKey.propertyTypeID.toCanonicalString().equals(this.propertyTypeID.toCanonicalString());
        }
    }
}

