/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.project.IFrameCockpitController;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.arrays.ArrayUtils;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.Collections_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.IListenerCaller;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.IRepositoryPlatformController;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterInterface;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkspace;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameDataConverter;
import com.arcway.repository.clientadapter.implementation.adapter.locks.ILockManager;
import com.arcway.repository.clientadapter.implementation.adapter.project.ObjectTypeDeclarationSnapshot;
import com.arcway.repository.clientadapter.implementation.adapter.project.ObjectTypeDeclarationWorkspace;
import com.arcway.repository.clientadapter.implementation.adapter.project.PlatformAdapterModuleProject;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IDataManagerRootAdapter;
import com.arcway.repository.clientadapter.interFace.IObjectTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.clientadapter.interFace.IRelationContribution;
import com.arcway.repository.clientadapter.interFace.IRelationContributionForPermissionCheck;
import com.arcway.repository.clientadapter.lib.RelationContribution;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsCockpitData;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsSnapshot;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsWorkspace;
import com.arcway.repository.cockpitadapter.EOCommitInformation;
import com.arcway.repository.cockpitadapter.EOUserInformation;
import com.arcway.repository.cockpitadapter.EOWorkspaceInformation;
import com.arcway.repository.cockpitadapter.locks.EOCrossLinkLock;
import com.arcway.repository.cockpitadapter.locks.EODataLock;
import com.arcway.repository.cockpitadapter.locks.EODataLockA;
import com.arcway.repository.cockpitadapter.locks.EODataLockMS;
import com.arcway.repository.cockpitadapter.locks.EODataLockMX;
import com.arcway.repository.cockpitadapter.locks.EODataLockN;
import com.arcway.repository.cockpitadapter.locks.EODataLockS;
import com.arcway.repository.cockpitadapter.locks.EODataLockX;
import com.arcway.repository.cockpitadapter.locks.EOOccurrenceLinkLock;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.implementation.lock.CrossLinkRepositoryRelationLockSample;
import com.arcway.repository.implementation.lock.OccurrenceRepositoryRelationLockSample;
import com.arcway.repository.implementation.lock.RepositoryAttributeSetLockSample;
import com.arcway.repository.implementation.lock.RepositoryIDLockSample;
import com.arcway.repository.implementation.lock.RepositoryObjectLockSample;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.lock.AbstractCrossLinkRepositoryRelationLockSample;
import com.arcway.repository.interFace.data.lock.AbstractOccurrenceRepositoryRelationLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryAttributeSetLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryIDLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryObjectLockSample;
import com.arcway.repository.interFace.data.lock.RepositoryObjectLockType;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ICrossLinkRepositoryRelationsReferenceForPermissionCheck;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.PermissionCheckRelationContribution;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.implementation.workstation.IRepositoryWorkstationListener;
import com.arcway.repository.interFace.implementation.workstation.IRepositoryWorkstationRO;
import com.arcway.repository.interFace.implementation.workstation.RepositoryWorkstationConnectionState;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerListener;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.declaration.type.object.BaseRepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.relation.BaseOccurrenceRepositoryRelationTypeDeclaration;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.OccurrenceRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.RDTUserReference;
import com.arcway.repository.lib.high.registration.data.lib.UserReference;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PlatformAdapterWorkstation
implements IRepositoryWorkstationRO,
IRepositoryPlatformController {
    private static final ILogger logger = Logger.getLogger(PlatformAdapterWorkstation.class);
    private static final DataTypeString DATA_TYPE_STRING = DataTypeString.getInstanceString();
    private static final ISet_<IRepositoryPropertyTypeID> OBJECTID_PROPERTYTYPEIDS;
    private static final ISet_<IRepositoryPropertyTypeID> SNAPSHOTID_PROPERTYTYPEIDS;
    private IRepositoryTypeManagerRO repositoryTypeManager;
    private final IFrameProjectAgent projectAgent;
    private final ListenerManager<IRepositoryWorkstationListener> listenerManager = new ListenerManager();
    private final PlatformAdapterWorkspace repositoryWorkspace;
    private final IHasher_<IRepositoryObjectSample> workspaceInformationHasher;
    private final ListenerKey typeManagerListenerKey = new ListenerKey();
    private final IRepositoryTypeManagerListener typeManagerListener = new IRepositoryTypeManagerListener(){

        public void dispose() {
            PlatformAdapterWorkstation.this.shutdown();
        }
    };

    static {
        HashSet_ idPropertyTypeIDs = new HashSet_(1, IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        idPropertyTypeIDs.add((Object)COTIDsCockpitData.PROPERTY_TYPE_ID_UID);
        OBJECTID_PROPERTYTYPEIDS = idPropertyTypeIDs;
        idPropertyTypeIDs = new HashSet_(1, IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        idPropertyTypeIDs.add((Object)COTIDsSnapshot.PROPERTY_TYPE_ID_UID);
        SNAPSHOTID_PROPERTYTYPEIDS = idPropertyTypeIDs;
    }

    public PlatformAdapterWorkstation(IFrameProjectAgent projectAgent) {
        Assert.checkArgumentBeeingNotNull((Object)projectAgent);
        this.projectAgent = projectAgent;
        this.workspaceInformationHasher = new IHasher_<IRepositoryObjectSample>(){

            public int getHashCode(IRepositoryObjectSample iRepositoryObjectSample) {
                EOWorkspaceInformation workspaceInformation = PlatformAdapterWorkstation.this.createEOWorkspaceInformation(iRepositoryObjectSample);
                return workspaceInformation.getWorkspaceUID().hashCode();
            }

            public boolean isEqual(IRepositoryObjectSample iRepositoryObjectSample1, IRepositoryObjectSample iRepositoryObjectSample2) {
                EOWorkspaceInformation workspaceInformation1 = PlatformAdapterWorkstation.this.createEOWorkspaceInformation(iRepositoryObjectSample1);
                EOWorkspaceInformation workspaceInformation2 = PlatformAdapterWorkstation.this.createEOWorkspaceInformation(iRepositoryObjectSample2);
                return workspaceInformation1.getWorkspaceUID().equals(workspaceInformation2.getWorkspaceUID());
            }
        };
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workstation " + To.string((Object)this) + ": setting up");
        }
        this.repositoryWorkspace = new PlatformAdapterWorkspace(this);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workstation " + To.string((Object)this) + ": set up");
        }
    }

    public void setRepositoryTypeManager(IRepositoryTypeManagerRO repositoryTypeManager) {
        this.repositoryTypeManager = repositoryTypeManager;
        repositoryTypeManager.getListenerManager().addListener(this.typeManagerListenerKey, (IDisposeListener)this.typeManagerListener);
    }

    public IRepositoryWorkspaceRO createRepositoryWorkspace() {
        return this.repositoryWorkspace;
    }

    public void registerWorkspace(PlatformAdapterWorkspace repositoryWorkspaceToRegister) {
        Assert.checkState((this.repositoryWorkspace == null || this.repositoryWorkspace == repositoryWorkspaceToRegister ? 1 : 0) != 0, (String)"cannot deal with more than one workspace");
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Workstation " + To.string((Object)this) + ": register workspace" + To.string((Object)repositoryWorkspaceToRegister));
        }
    }

    public void unregisterWorkspace(PlatformAdapterWorkspace repositoryWorkspaceToUnregister) {
        Assert.checkState((this.repositoryWorkspace == repositoryWorkspaceToUnregister ? 1 : 0) != 0, (String)"the destroyed workspace was not the created in this context");
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Workstation " + To.string((Object)this) + ": unregister workspace" + To.string((Object)repositoryWorkspaceToUnregister));
        }
    }

    public IRepositoryTypeManagerRO getTypeManagerRO() {
        return this.repositoryTypeManager;
    }

    public PlatformAdapterInterface getRepositoryInterfaceImplementation() {
        return this.repositoryWorkspace.getRepositoryInterfaceImplementation();
    }

    public void shutdown() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workstation " + To.string((Object)this) + ": shutting down");
        }
        this.listenerManager.dispose();
        if (this.repositoryTypeManager != null) {
            this.repositoryTypeManager.getListenerManager().removeListener(this.typeManagerListenerKey);
        }
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workstation " + To.string((Object)this) + ": shut down");
        }
    }

    public ListenerManager<IRepositoryWorkstationListener> getListenerManager() {
        return this.listenerManager;
    }

    public EOWorkspaceInformation createEOWorkspaceInformation(IRepositoryObjectSample workspaceInformation) {
        String workspaceUID = PlatformAdapterWorkstation.getWorkspaceUID(RepositorySamples.getWorkspaceID((IRepositoryObjectSample)workspaceInformation, (IRepositoryTypeManagerRO)this.getTypeManagerRO()));
        IRepositoryPropertySetSample properiesPropertySetSample = RepositorySamples.getPropertySetSampleForAttributeSet((IRepositoryObjectSample)workspaceInformation, (IRepositoryAttributeSetTypeID)COTIDsWorkspace.ATTRIBUTE_SET_TYPE_ID_PROPERTIES, (IRepositoryTypeManagerRO)this.getTypeManagerRO());
        String lastClientLocation = RDTUID.getInstance().dataToValue(properiesPropertySetSample.getPropertySample((IRepositoryPropertyTypeID)COTIDsWorkspace.PROPERTY_TYPE_ID_LAST_LOCATION).getValue());
        EOUserInformation lastUser = PlatformAdapterWorkstation.createUserInformation(properiesPropertySetSample.getPropertySample((IRepositoryPropertyTypeID)COTIDsWorkspace.PROPERTY_TYPE_ID_LAST_USER).getValue());
        EOWorkspaceInformation eoWorkspaceInformation = new EOWorkspaceInformation(workspaceUID, lastClientLocation, lastUser);
        return eoWorkspaceInformation;
    }

    private static String getWorkspaceUID(IRepositoryPropertySetSample workspaceInformationIDAttributeSet) {
        String workspaceUID = RDTUID.getInstance().dataToValue(workspaceInformationIDAttributeSet.getPropertySample((IRepositoryPropertyTypeID)COTIDsWorkspace.PROPERTY_TYPE_ID_UID).getValue());
        return workspaceUID;
    }

    public IRepositoryObjectSample createWorkspaceInformation(EOWorkspaceInformation workspaceInformation) {
        HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        try {
            RDTUID rtduid = RDTUID.getInstance();
            IRepositoryData uid = rtduid.createData(workspaceInformation.getWorkspaceUID());
            rtduid.snapAndCheckData(uid, PlatformAdapterModuleProject.DATA_TYPE_PARAMETERS_UID);
            propertySamples.put((Object)COTIDsWorkspace.PROPERTY_TYPE_ID_UID, (Object)new RepositoryPropertySample(uid));
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
        try {
            RDTFreeString rdtFreeString = RDTFreeString.getInstance();
            IRepositoryData lastClientInfo = rdtFreeString.createData(workspaceInformation.getLastClientInformation());
            rdtFreeString.snapAndCheckData(lastClientInfo, ObjectTypeDeclarationWorkspace.DATA_TYPE_PARAMETERS_LAST_LOCATION);
            propertySamples.put((Object)COTIDsWorkspace.PROPERTY_TYPE_ID_LAST_LOCATION, (Object)new RepositoryPropertySample(lastClientInfo));
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
        propertySamples.put((Object)COTIDsWorkspace.PROPERTY_TYPE_ID_LAST_USER, (Object)new RepositoryPropertySample(PlatformAdapterWorkstation.createUserData(workspaceInformation.getLastUserInformation(), ObjectTypeDeclarationWorkspace.DATA_TYPE_PARAMETERS_LAST_USER)));
        return PlatformAdapterWorkstation.createObjectSample((IRepositoryObjectTypeID)COTIDsWorkspace.OBJECT_TYPE_ID, (IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)propertySamples);
    }

    public ISet_<IRepositoryObjectSample> createWorkspaceInformations(Collection<EOWorkspaceInformation> eoWorkspaceInformations) {
        HashSet_ workspaceInformations = new HashSet_(eoWorkspaceInformations.size(), this.workspaceInformationHasher);
        for (EOWorkspaceInformation workspaceInformation : eoWorkspaceInformations) {
            workspaceInformations.add((Object)this.createWorkspaceInformation(workspaceInformation));
        }
        return workspaceInformations;
    }

    public String getCommitUID(IRepositoryObjectSample snapshotInformation) {
        IRepositoryPropertySetSample snapshotInformationIDAttributeSet = RepositorySamples.getSnapshotID((IRepositoryObjectSample)snapshotInformation, (IRepositoryTypeManagerRO)this.getTypeManagerRO());
        String commitUID = this.getCommitUID(snapshotInformationIDAttributeSet);
        return commitUID;
    }

    public String getCommitUID(IRepositoryPropertySetSample snapshotInformationIDAttributeSet) {
        String commitUID = RDTUID.getInstance().dataToValue(snapshotInformationIDAttributeSet.getPropertySample((IRepositoryPropertyTypeID)COTIDsSnapshot.PROPERTY_TYPE_ID_UID).getValue());
        return commitUID;
    }

    public String getObjectUID(IRepositoryPropertySetSample objectIDAttributeSet) {
        String objectUID = RDTUID.getInstance().dataToValue(objectIDAttributeSet.getPropertySample((IRepositoryPropertyTypeID)COTIDsCockpitData.PROPERTY_TYPE_ID_UID).getValue());
        return objectUID;
    }

    public IRepositoryPropertySetSample getObjectID(String cockpitDataUID) {
        RepositoryPropertySample propertySample;
        Assert.checkArgumentBeeingNotNull((Object)cockpitDataUID);
        try {
            RDTUID rtduid = RDTUID.getInstance();
            IRepositoryData uid = rtduid.createData(cockpitDataUID);
            rtduid.snapAndCheckData(uid, PlatformAdapterModuleProject.DATA_TYPE_PARAMETERS_UID);
            propertySample = new RepositoryPropertySample(uid);
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
        return new ObjectIDPropertySetSample((IRepositoryPropertySample)propertySample);
    }

    public IRepositoryPropertySetSample getSnapshotID(String commitUID) {
        IRepositoryPropertySetSample snapshotID;
        if (commitUID != null) {
            RepositoryPropertySample propertySample;
            try {
                RDTUID rtduid = RDTUID.getInstance();
                IRepositoryData repositoryDataUID = rtduid.createData(commitUID);
                rtduid.snapAndCheckData(repositoryDataUID, PlatformAdapterModuleProject.DATA_TYPE_PARAMETERS_UID);
                propertySample = new RepositoryPropertySample(repositoryDataUID);
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new RuntimeException(e);
            }
            catch (EXValueInvalid e) {
                throw new RuntimeException(e);
            }
            snapshotID = new IRepositoryPropertySetSample((IRepositoryPropertySample)propertySample){
                private final /* synthetic */ IRepositoryPropertySample val$propertySample;
                {
                    this.val$propertySample = iRepositoryPropertySample;
                }

                public IRepositoryPropertySample getPropertySample(IRepositoryPropertyTypeID repositoryPropertyTypeID) {
                    return this.val$propertySample;
                }

                public ICollection_<IRepositoryPropertySample> getPropertySamples() {
                    return Collections_.singletonList((Object)this.val$propertySample);
                }

                public ISet_<IRepositoryPropertyTypeID> getPropertyTypeIDs() {
                    return SNAPSHOTID_PROPERTYTYPEIDS;
                }
            };
        } else {
            snapshotID = null;
        }
        return snapshotID;
    }

    @Override
    public IRepositoryObjectSample createSnapshotInformation(EOCommitInformation commitInformation) {
        HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        try {
            RDTUID rtduid = RDTUID.getInstance();
            IRepositoryData repositoryDataUID = rtduid.createData(commitInformation.getCommitUID());
            rtduid.snapAndCheckData(repositoryDataUID, PlatformAdapterModuleProject.DATA_TYPE_PARAMETERS_UID);
            propertySamples.put((Object)COTIDsSnapshot.PROPERTY_TYPE_ID_UID, (Object)new RepositoryPropertySample(repositoryDataUID));
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
        try {
            RDTDateUTC64Bitmsec rtdDateUTC = RDTDateUTC64Bitmsec.getInstance();
            IRepositoryData repositoryDate = rtdDateUTC.createData(commitInformation.getCommitDate());
            rtdDateUTC.snapAndCheckData(repositoryDate, ObjectTypeDeclarationSnapshot.DATA_TYPE_PARAMETERS_MODIFICATION_DATE);
            propertySamples.put((Object)COTIDsSnapshot.PROPERTY_TYPE_ID_MODIFICATIONDATE, (Object)new RepositoryPropertySample(repositoryDate));
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
        try {
            RDTFreeText rtdFreeText = RDTFreeText.getInstance();
            IRepositoryData repositoryDataFreeText = rtdFreeText.createData(commitInformation.getCommitComment());
            rtdFreeText.snapAndCheckData(repositoryDataFreeText, ObjectTypeDeclarationSnapshot.DATA_TYPE_PARAMETERS_MODIFICATION_COMMENT);
            propertySamples.put((Object)COTIDsSnapshot.PROPERTY_TYPE_ID_MODIFICATIONCOMMENT, (Object)new RepositoryPropertySample(repositoryDataFreeText));
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
        propertySamples.put((Object)COTIDsSnapshot.PROPERTY_TYPE_ID_MODIFIER, (Object)new RepositoryPropertySample(PlatformAdapterWorkstation.createUserData(commitInformation.getCommitingUserInformation(), ObjectTypeDeclarationSnapshot.DATA_TYPE_PARAMETERS_MODIFIER)));
        return PlatformAdapterWorkstation.createObjectSample((IRepositoryObjectTypeID)COTIDsSnapshot.OBJECT_TYPE_ID, (IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample>)propertySamples);
    }

    public ICollectionRW_<IRepositoryObjectSample> createSnapshotInformations(Collection<EOCommitInformation> eoCommitInformations) {
        ArrayList_ snapshotInformations = new ArrayList_(eoCommitInformations.size());
        for (EOCommitInformation commitInformation : eoCommitInformations) {
            snapshotInformations.add((Object)this.createSnapshotInformation(commitInformation));
        }
        return snapshotInformations;
    }

    private static final IRepositoryData createUserData(EOUserInformation userInformation, IRepositoryDataTypeParameters dataTypeParameters) {
        UserReference userReference;
        if ("PSC-Server".equals(userInformation.getDirectoryType())) {
            userReference = UserReference.createPSCUser((String)userInformation.getDirectoryNameOrURL(), (String)userInformation.getLoginID(), (String)userInformation.getRealName());
        } else if ("LDAP".equals(userInformation.getDirectoryType())) {
            userReference = UserReference.createLDAPUser((String)userInformation.getDirectoryNameOrURL(), (String)userInformation.getDistinguishedName(), (String)userInformation.getLoginID(), (String)userInformation.getRealName());
        } else if ("Single-User".equals(userInformation.getDirectoryType())) {
            userReference = UserReference.createStandaloneUser((String)userInformation.getRealName());
        } else {
            throw new UnsupportedOperationException();
        }
        try {
            RDTUserReference rtdUserRef = RDTUserReference.getInstance();
            IRepositoryData repositoryDataUserRef = rtdUserRef.createData(userReference);
            rtdUserRef.snapAndCheckData(repositoryDataUserRef, dataTypeParameters);
            return repositoryDataUserRef;
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
    }

    private static final EOUserInformation createUserInformation(IRepositoryData userData) {
        String directoryType;
        RDTUserReference rdt = RDTUserReference.getInstance();
        UserReference userReference = rdt.dataToValue(userData);
        if ("LDAP".equals(userReference.getDirectoryType())) {
            directoryType = "LDAP";
        } else if ("PSC-Server".equals(userReference.getDirectoryType())) {
            directoryType = "PSC-Server";
        } else if ("Standalone".equals(userReference.getDirectoryType())) {
            directoryType = "Single-User";
        } else {
            throw new UnsupportedOperationException();
        }
        return new EOUserInformation(directoryType, userReference.getDirectoryNameOrURL(), userReference.getDistinguishedName(), userReference.getLoginID(), userReference.getRealName());
    }

    private static IRepositoryObjectSample createObjectSample(IRepositoryObjectTypeID objectTypeID, IMap_<IRepositoryPropertyTypeID, IRepositoryPropertySample> propertySamples) {
        RepositoryObjectSample repositoryObjectSample = new RepositoryObjectSample(objectTypeID, null, propertySamples);
        return repositoryObjectSample;
    }

    public IRepositoryAttributeSetTypeID getPropertiesAttributeSetTypeID() {
        return COTIDsCockpitData.ATTRIBUTE_SET_TYPE_ID_PROPERTIES;
    }

    public Collection<EOPlatformLock> createEOLocks(ISet_<AbstractRepositoryLockSample> lockSamples) {
        ArrayList<EOPlatformLock> eoLocks = new ArrayList<EOPlatformLock>(lockSamples.size());
        for (AbstractRepositoryLockSample lockSample : lockSamples) {
            EOPlatformLock eoLock = this.createEOLock(lockSample);
            eoLocks.add(eoLock);
        }
        return eoLocks;
    }

    public EOPlatformLock createEOLock(AbstractRepositoryLockSample lockSample) {
        final String commitUID = this.getCommitUID(lockSample.getBasedSnapshotID());
        final EOPlatformLock[] eoLock = new EOPlatformLock[1];
        if (lockSample instanceof AbstractRepositoryObjectLockSample) {
            AbstractRepositoryObjectLockSample objectLockSample = (AbstractRepositoryObjectLockSample)lockSample;
            final IRepositoryObjectTypeID objectTypeID = objectLockSample.getObjectTypeID();
            IRepositoryPropertySetSample objectID = objectLockSample.getObjectID();
            final String cockpitDataUID = this.getObjectUID(objectID);
            try {
                new RepositoryObjectLockType.Switch(objectLockSample.getLockType()){

                    public void caseExclusive() throws Exception {
                        eoLock[0] = new EODataLockX(commitUID, objectTypeID, cockpitDataUID);
                    }

                    public void caseMoveExclusive() throws Exception {
                        eoLock[0] = new EODataLockMX(commitUID, objectTypeID, cockpitDataUID);
                    }

                    public void caseMoveShared() throws Exception {
                        eoLock[0] = new EODataLockMS(commitUID, objectTypeID, cockpitDataUID);
                    }

                    public void caseShared() throws Exception {
                        eoLock[0] = new EODataLockS(commitUID, objectTypeID, cockpitDataUID);
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        } else if (lockSample instanceof AbstractRepositoryAttributeSetLockSample) {
            AbstractRepositoryAttributeSetLockSample attributeSetLockSample = (AbstractRepositoryAttributeSetLockSample)lockSample;
            IRepositoryObjectTypeID objectTypeID = attributeSetLockSample.getObjectTypeID();
            IRepositoryAttributeSetTypeID attributeSetTypeID = attributeSetLockSample.getAttributeSetTypeID();
            IRepositoryPropertySetSample objectID = attributeSetLockSample.getObjectID();
            String cockpitDataUID = this.getObjectUID(objectID);
            eoLock[0] = new EODataLockA(commitUID, objectTypeID, cockpitDataUID, attributeSetTypeID);
        } else if (lockSample instanceof AbstractRepositoryIDLockSample) {
            AbstractRepositoryIDLockSample idLockSample = (AbstractRepositoryIDLockSample)lockSample;
            IRepositoryObjectTypeID contextObjectTypeID = idLockSample.getContextObjectTypeID();
            IRepositoryPropertySetSample contextObjectID = idLockSample.getContextObjectID();
            IRepositoryObjectTypeID namedObjectTypeID = idLockSample.getObjectTypeID();
            IRepositoryPropertyTypeID namePropertyTypeID = idLockSample.getPropertyTypeID();
            IRepositoryData id = idLockSample.getID().getValue();
            String contextDataUID = this.getObjectUID(contextObjectID);
            String name = (String)FrameDataConverter.convertRepositoryDataToCockpitAttribute(id, DATA_TYPE_STRING, null);
            eoLock[0] = new EODataLockN(commitUID, contextObjectTypeID, contextDataUID, namedObjectTypeID, namePropertyTypeID, name);
        } else if (lockSample instanceof AbstractCrossLinkRepositoryRelationLockSample) {
            AbstractCrossLinkRepositoryRelationLockSample relationLockSample = (AbstractCrossLinkRepositoryRelationLockSample)lockSample;
            ICrossLinkRepositoryRelationReference relation = relationLockSample.getRelation();
            IRepositoryRelationTypeID relationTypeID = relation.getRelationTypeID();
            ArrayList_ roleIDs = new ArrayList_((ICollection_)relation.getRelationContributionRoleIDs());
            ArrayList_ cockpitDataUIDs = new ArrayList_(roleIDs.size());
            for (IRepositoryRelationContributionRoleID roleID : roleIDs) {
                cockpitDataUIDs.add((Object)this.getObjectUID(relation.getObjectID(roleID)));
            }
            eoLock[0] = new EOCrossLinkLock(commitUID, relationTypeID, (IList_)roleIDs, (IList_)cockpitDataUIDs);
        } else if (lockSample instanceof AbstractOccurrenceRepositoryRelationLockSample) {
            AbstractOccurrenceRepositoryRelationLockSample relationLockSample = (AbstractOccurrenceRepositoryRelationLockSample)lockSample;
            IOccurrenceRepositoryRelationReference relation = relationLockSample.getRelation();
            IRepositoryRelationTypeID relationTypeID = relation.getRelationTypeID();
            ArrayList_ roleIDs = new ArrayList_();
            ArrayList_ cockpitDataUIDs = new ArrayList_(roleIDs.size());
            IRepositoryRelationContributionRoleID roleID = BaseOccurrenceRepositoryRelationTypeDeclaration.RelationContributionTypes.ROLE_OCCURENCE;
            roleIDs.add((Object)roleID);
            cockpitDataUIDs.add((Object)this.getObjectUID(relation.getObjectIDofOccurrenceContainingObject()));
            roleID = BaseOccurrenceRepositoryRelationTypeDeclaration.RelationContributionTypes.ROLE_OCCURENCE_ID;
            roleIDs.add((Object)roleID);
            cockpitDataUIDs.add((Object)relation.getOccurrenceID());
            eoLock[0] = new EOOccurrenceLinkLock(commitUID, relationTypeID, (IList_)roleIDs, (IList_)cockpitDataUIDs);
        } else {
            throw new RuntimeException("unknown lock type");
        }
        return eoLock[0];
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractRepositoryLockSample createLock(EOPlatformLock eoLock) {
        void var9_24;
        String commitUID = eoLock.getCommitUID();
        IRepositoryPropertySetSample snapshotID = this.getSnapshotID(commitUID);
        if (eoLock instanceof EODataLock) {
            void var9_21;
            EODataLock eoDataLock = (EODataLock)eoLock;
            String cockpitDataUID = eoDataLock.getCockpitDataUID();
            IRepositoryPropertySetSample objectID = this.getObjectID(cockpitDataUID);
            IRepositoryObjectTypeID objectTypeID = eoDataLock.getObjectTypeID();
            if (eoLock instanceof EODataLockS) {
                RepositoryObjectLockType repositoryObjectLockType = RepositoryObjectLockType.SHARED;
            } else if (eoLock instanceof EODataLockMS) {
                RepositoryObjectLockType repositoryObjectLockType = RepositoryObjectLockType.MOVE_SHARED;
            } else if (eoLock instanceof EODataLockMX) {
                RepositoryObjectLockType repositoryObjectLockType = RepositoryObjectLockType.MOVE_EXCLUSIVE;
            } else if (eoLock instanceof EODataLockX) {
                RepositoryObjectLockType repositoryObjectLockType = RepositoryObjectLockType.EXCLUSIVE;
            } else {
                Object var9_20 = null;
            }
            if (var9_21 != null) {
                return new RepositoryObjectLockSample((RepositoryObjectLockType)var9_21, objectTypeID, objectID, snapshotID);
            }
            if (eoLock instanceof EODataLockA) {
                EODataLockA eoDataLockA = (EODataLockA)eoLock;
                IRepositoryAttributeSetTypeID attributeSetTypeID = eoDataLockA.getAttributeSetTypeID();
                return new RepositoryAttributeSetLockSample(objectTypeID, attributeSetTypeID, objectID, snapshotID);
            }
            if (!(eoLock instanceof EODataLockN)) throw new RuntimeException("unknown lock type");
            EODataLockN eoDataLockN = (EODataLockN)eoLock;
            IRepositoryObjectTypeID namedObjectTypeID = eoDataLockN.getNamedObjectTypeID();
            IRepositoryObjectType namedObjectType = this.getTypeManagerRO().getObjectType(namedObjectTypeID);
            IRepositoryPropertyTypeID namePropertyTypeID = eoDataLockN.getNamePropertyTypeID();
            IRepositoryPropertyType namePropertyType = namedObjectType.getAttributeSetType(namePropertyTypeID).getPropertyType(namePropertyTypeID);
            String name = eoDataLockN.getName();
            IRepositoryData idData = FrameDataConverter.convertCockpitAttributeToRepositoryData(DATA_TYPE_STRING, null, name, namePropertyType.getDataType(), namePropertyType.getDataTypeParameters());
            RepositoryPropertySample id = new RepositoryPropertySample(idData);
            return new RepositoryIDLockSample(objectTypeID, namePropertyTypeID, (IRepositoryPropertySample)id, objectTypeID, objectID, snapshotID);
        }
        if (eoLock instanceof EOCrossLinkLock) {
            EOCrossLinkLock eoLinkLock = (EOCrossLinkLock)eoLock;
            IRepositoryRelationTypeID relationTypeID = eoLinkLock.getRelationTypeID();
            IList_ roleIDs = eoLinkLock.getRoleIDs();
            IList_ cockpitDataUIDs = eoLinkLock.getCockpitDataUIDs();
            HashMap_ hashMap_ = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
            int i = 0;
            while (i < roleIDs.size()) {
                IRepositoryRelationContributionRoleID roleID = (IRepositoryRelationContributionRoleID)roleIDs.get(i);
                String cockpitDataUID = (String)cockpitDataUIDs.get(i);
                IRepositoryPropertySetSample objectID = this.getObjectID(cockpitDataUID);
                hashMap_.put((Object)roleID, (Object)objectID);
                ++i;
            }
            CrossLinkRepositoryRelationReference relationReference = new CrossLinkRepositoryRelationReference(relationTypeID, (IMap_)hashMap_);
            return new CrossLinkRepositoryRelationLockSample((ICrossLinkRepositoryRelationReference)relationReference, snapshotID);
        }
        if (!(eoLock instanceof EOOccurrenceLinkLock)) throw new RuntimeException("unknown lock type");
        EOOccurrenceLinkLock eoLinkLock = (EOOccurrenceLinkLock)eoLock;
        IRepositoryRelationTypeID relationTypeID = eoLinkLock.getRelationTypeID();
        IList_ roleIDs = eoLinkLock.getRoleIDs();
        IList_ cockpitDataUIDs = eoLinkLock.getCockpitDataUIDs();
        Object var9_23 = null;
        String occurenceID = null;
        int i = 0;
        while (i < roleIDs.size()) {
            IRepositoryRelationContributionRoleID roleID = (IRepositoryRelationContributionRoleID)roleIDs.get(i);
            String cockpitDataUID = (String)cockpitDataUIDs.get(i);
            if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID, (Object)BaseOccurrenceRepositoryRelationTypeDeclaration.RelationContributionTypes.ROLE_OCCURENCE)) {
                IRepositoryPropertySetSample objectID;
                IRepositoryPropertySetSample iRepositoryPropertySetSample = objectID = this.getObjectID(cockpitDataUID);
            } else if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID, (Object)BaseOccurrenceRepositoryRelationTypeDeclaration.RelationContributionTypes.ROLE_OCCURENCE_ID)) {
                occurenceID = cockpitDataUID;
            }
            ++i;
        }
        OccurrenceRepositoryRelationReference relationReference = new OccurrenceRepositoryRelationReference(relationTypeID, (IRepositoryPropertySetSample)var9_24, occurenceID);
        return new OccurrenceRepositoryRelationLockSample((IOccurrenceRepositoryRelationReference)relationReference, snapshotID);
    }

    public ISet_<AbstractRepositoryLockSample> createLocks(Collection<EOPlatformLock> eoLocks) {
        HashSet_ locks = new HashSet_(eoLocks.size(), AbstractRepositoryLockSample.IS_EQUIVALENT_LOCK_HASHER);
        for (EOPlatformLock eoLock : eoLocks) {
            locks.add((Object)this.createLock(eoLock));
        }
        return locks;
    }

    public IFrameCockpitController getCockpitController() {
        return this.projectAgent.getCockpitController();
    }

    public ILockManager getLockManager() {
        return this.getCockpitController().getLockManager();
    }

    public ICollection_<IRepositoryObjectSample> getAvailableWorkspaceInformations() {
        Collection<EOWorkspaceInformation> eoWorkspaceInformations = this.getCockpitController().getAvailableWorkspaceInformations();
        ISet_<IRepositoryObjectSample> workspaceInformations = this.createWorkspaceInformations(eoWorkspaceInformations);
        return workspaceInformations;
    }

    public RepositoryWorkstationConnectionState getConnectionState() {
        RepositoryWorkstationConnectionState connectionState = this.getCockpitController().isOnline() ? RepositoryWorkstationConnectionState.ONLINE : RepositoryWorkstationConnectionState.OFFLINE;
        return connectionState;
    }

    public ISet_<IRepositoryObjectSample> getLockingWorkspaceInformations(AbstractRepositoryLockSample lockSample) {
        EOPlatformLock eoLock = this.createEOLock(lockSample);
        Collection<String> workspaceUIDs = this.getLockManager().getLockingWorkspaceUIDs(eoLock);
        ArrayList<EOWorkspaceInformation> eoWorkspaceInformations = new ArrayList<EOWorkspaceInformation>(workspaceUIDs.size());
        for (String workspaceUID : workspaceUIDs) {
            eoWorkspaceInformations.add(this.getCockpitController().getWorkspaceInformation(workspaceUID));
        }
        ISet_<IRepositoryObjectSample> workspaceInformations = this.createWorkspaceInformations(eoWorkspaceInformations);
        return workspaceInformations;
    }

    public ISet_<AbstractRepositoryLockSample> getWorkspaceLocks(IRepositoryPropertySetSample workspaceID) {
        String workspaceUID = PlatformAdapterWorkstation.getWorkspaceUID(workspaceID);
        Collection<EOPlatformLock> eoLocks = this.getLockManager().getLocks(workspaceUID);
        ISet_<AbstractRepositoryLockSample> locks = this.createLocks(eoLocks);
        return locks;
    }

    @Override
    public void connectionModeChanged(boolean online) {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workstation " + To.string((Object)this) + ": changing connection mode");
        }
        final RepositoryWorkstationConnectionState newConnectionState = online ? RepositoryWorkstationConnectionState.ONLINE : RepositoryWorkstationConnectionState.OFFLINE;
        this.listenerManager.callListeners((IListenerCaller)new IListenerCaller<IRepositoryWorkstationListener>(){

            public void callListener(IRepositoryWorkstationListener listener) {
                listener.connectionStateChanged(newConnectionState);
            }
        });
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workstation " + To.string((Object)this) + ": connection mode changed");
        }
    }

    @Override
    public void workspaceListChanged() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workstation " + To.string((Object)this) + ": changing workspace list");
        }
        this.listenerManager.callListeners((IListenerCaller)new IListenerCaller<IRepositoryWorkstationListener>(){

            public void callListener(IRepositoryWorkstationListener listener) {
                listener.availableWorkspaceInformationsChanged();
            }
        });
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workstation " + To.string((Object)this) + ": workspace list changed");
        }
    }

    @Override
    public void workspaceLocksChanged(EOWorkspaceInformation eoWorkspaceInformation) {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workstation " + To.string((Object)this) + ": changing workspace locks");
        }
        final IRepositoryObjectSample workspaceInformation = this.createWorkspaceInformation(eoWorkspaceInformation);
        this.listenerManager.callListeners((IListenerCaller)new IListenerCaller<IRepositoryWorkstationListener>(){

            public void callListener(IRepositoryWorkstationListener listener) {
                listener.workspaceLocksChanged(workspaceInformation);
            }
        });
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workstation " + To.string((Object)this) + ": workspace locks changed");
        }
    }

    @Override
    public void concurrentLocalModifications() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workstation " + To.string((Object)this) + ": concurrent local modifications");
        }
        this.repositoryWorkspace.concurrentLocalModifications();
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workstation " + To.string((Object)this) + ": concurrent local modifications");
        }
    }

    @Override
    public void workspaceCommited(EOWorkspaceInformation workspaceInformation, EOCommitInformation commit) {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workstation " + To.string((Object)this) + ": commiting workspace");
        }
        this.repositoryWorkspace.workspaceCommited(workspaceInformation, commit);
        this.workspaceLocksChanged(workspaceInformation);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workstation " + To.string((Object)this) + ": workspace commited");
        }
    }

    @Override
    public void workspaceDiscarded() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workstation " + To.string((Object)this) + ": discarding workspace");
        }
        this.repositoryWorkspace.workspaceDiscarded();
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workstation " + To.string((Object)this) + ": workspace discarded");
        }
    }

    public List<ObjectTypeCategory> getAllObjectTypeCategoriesForObjectType(IRepositoryObjectType repObjectType) {
        assert (repObjectType.canBeInstanciated());
        if (!repObjectType.canBeInstanciated()) {
            return Collections.emptyList();
        }
        IDataManagerAdapter objectTypeDeclaration = this.getCockpitController().getPlatformAdapterModuleManager().getDataManagerAdapter(repObjectType);
        String cockpitTypeID = objectTypeDeclaration.getCockpitDataTypeID();
        return this.projectAgent.getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(cockpitTypeID);
    }

    public ObjectTypeCategory getObjectTypeCategory(IRepositoryObjectTypeCategoryID repObjectTypeCategoryID) {
        return this.projectAgent.getObjectTypeCategoriesManager().getCategory(ObjectTypeCategoryID.getObjectTypeCategoryID((String)repObjectTypeCategoryID.toCanonicalString()));
    }

    public IPropertyType[] getAllPropertyTypes(IRepositoryObjectType repositoryObjectType) {
        Object[] allPropertyTypes = new IPropertyType[]{};
        IRepositoryObjectType currentObjectType = repositoryObjectType;
        while (!IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)currentObjectType.getRepositoryObjectTypeID(), (Object)BaseRepositoryObjectTypeID.OBJECT_TYPE_ID)) {
            IObjectTypeDeclaration objectTypeDeclaration = this.getCockpitController().getPlatformAdapterModuleManager().getObjectTypeDeclaration(currentObjectType);
            allPropertyTypes = (IPropertyType[])ArrayUtils.concatenateArrays((Object[])objectTypeDeclaration.getFixPropertyTypes(), (Object[])allPropertyTypes, IPropertyType.class);
            currentObjectType = currentObjectType.getAbstractSuperObjectType();
        }
        return allPropertyTypes;
    }

    @Override
    public IRepositoryPropertySetSample getRepositoryObjectID(String cockpitDataUID) {
        return this.repositoryWorkspace.getWorkstationImplementation().getObjectID(cockpitDataUID);
    }

    @Override
    public String getCockpitDataUID(IRepositoryPropertySetSample repositoryObjectID) {
        return this.getObjectUID(repositoryObjectID);
    }

    @Override
    public IRepositoryObject findRepositoryObject(IRepositorySnapshotRO snapshot, ICockpitDataID cockpitDataID) throws EXNotReproducibleSnapshot {
        PlatformAdapterObject object = null;
        if (snapshot instanceof PlatformAdapterSnapshot) {
            PlatformAdapterSnapshot platformAdapterSnapshot = (PlatformAdapterSnapshot)snapshot;
            object = platformAdapterSnapshot.findObject(cockpitDataID);
        }
        return object;
    }

    @Override
    public ICockpitProjectData findCockpitProjectData(ICockpitDataID cockpitDataID) {
        IDataManagerAdapter dataManagerAdapter = this.getPlatformAdapterModuleManager().findDataManagerAdapter(cockpitDataID);
        ICockpitProjectData cockpitObject = dataManagerAdapter != null ? dataManagerAdapter.findData(cockpitDataID.getCockpitDataUID()) : null;
        return cockpitObject;
    }

    @Override
    public IAttributeOwnerRW findAttributeOwnerRW(ICockpitDataID cockpitDataID) {
        IAttributeOwnerRW attributeOwnerRW;
        IDataManagerAdapter dataManagerAdapter = this.getPlatformAdapterModuleManager().findDataManagerAdapter(cockpitDataID);
        if (dataManagerAdapter != null) {
            ICockpitProjectData cockpitObject = dataManagerAdapter.findData(cockpitDataID.getCockpitDataUID());
            attributeOwnerRW = dataManagerAdapter.getAttributeOwnerRW(cockpitObject);
        } else {
            attributeOwnerRW = null;
        }
        return attributeOwnerRW;
    }

    @Override
    public ICockpitProjectData getParentCockpitProjectData(ICockpitDataID childDataID) {
        ICockpitProjectData cockpitObject;
        IDataManagerAdapter dataManagerAdapter = this.getPlatformAdapterModuleManager().findDataManagerAdapter(childDataID);
        Assert.checkArgumentBeeingNotNull((Object)dataManagerAdapter);
        if (dataManagerAdapter instanceof IDataManagerRootAdapter) {
            cockpitObject = null;
        } else {
            ICockpitProjectData childCockpitObject = this.findCockpitProjectData(childDataID);
            ICockpitDataID cockpitDataID = dataManagerAdapter.getParentCockpitDataID(childCockpitObject);
            Assert.checkArgumentBeeingNotNull((Object)cockpitDataID);
            cockpitObject = this.findCockpitProjectData(cockpitDataID);
            Assert.checkArgumentBeeingNotNull((Object)cockpitObject);
        }
        return cockpitObject;
    }

    public PlatformAdapterModuleManager getPlatformAdapterModuleManager() {
        return this.getCockpitController().getPlatformAdapterModuleManager();
    }

    @Override
    public IRepositoryPropertySetSample allocateNewObjectID() {
        String cockpitDataUID = UUIDGenerator.getUniqueID();
        IRepositoryPropertySetSample newObjectID = this.getObjectID(cockpitDataUID);
        return newObjectID;
    }

    IRelationContribution[] getCockpitRelationContributions(ICrossLinkRepositoryRelationSample relationSample) {
        ISet_ relationContributionRoleIDs = relationSample.getRelationContributionRoleIDs();
        int index = 0;
        IRelationContribution[] relationContributions = new IRelationContribution[relationContributionRoleIDs.size()];
        for (IRepositoryRelationContributionRoleID relationContributionRoleID : relationContributionRoleIDs) {
            IRepositoryPropertySetSample objectID = relationSample.getObjectID(relationContributionRoleID);
            String referencedCockpitUID = this.getObjectUID(objectID);
            relationContributions[index] = new RelationContribution(relationContributionRoleID, referencedCockpitUID);
            ++index;
        }
        return relationContributions;
    }

    IRelationContribution[] getCockpitRelationContributions(ICrossLinkRepositoryRelationsReference relationsReference) {
        ISet_ relationContributionRoleIDs = relationsReference.getRoleID2ObjectIDMap().keySet();
        int index = 0;
        IRelationContribution[] relationContributions = new IRelationContribution[relationContributionRoleIDs.size()];
        for (IRepositoryRelationContributionRoleID relationContributionRoleID : relationContributionRoleIDs) {
            IRepositoryPropertySetSample objectID = (IRepositoryPropertySetSample)relationsReference.getRoleID2ObjectIDMap().getByKey((Object)relationContributionRoleID);
            String referencedCockpitUID = this.getObjectUID(objectID);
            relationContributions[index] = new RelationContribution(relationContributionRoleID, referencedCockpitUID);
            ++index;
        }
        return relationContributions;
    }

    IRelationContributionForPermissionCheck[] getCockpitRelationContributionsForPermissionCheck(ICrossLinkRepositoryRelationsReferenceForPermissionCheck relationsReference) {
        Map sourceRelationContributions = relationsReference.getRelationContributions();
        int index = 0;
        IRelationContributionForPermissionCheck[] targetRelationContributions = new IRelationContributionForPermissionCheck[sourceRelationContributions.size()];
        for (Map.Entry entry : sourceRelationContributions.entrySet()) {
            String cockpitDataTypeID;
            final IRepositoryRelationContributionRoleID relationContributionRoleID = (IRepositoryRelationContributionRoleID)entry.getKey();
            PermissionCheckRelationContribution sourceRelationContribution = (PermissionCheckRelationContribution)entry.getValue();
            IRepositoryObjectTypeID objectTypeID = sourceRelationContribution.getRepositoryObjectTypeIDOfPermissionOperandParent();
            IRepositoryPropertySetSample objectID = sourceRelationContribution.getRepositoryObjectIDOfPermissionOperandParentOrRelatedObject();
            if (objectTypeID == null) {
                cockpitDataTypeID = null;
            } else {
                IRepositoryObjectType repositoryObjectType = this.getTypeManagerRO().getObjectType(objectTypeID);
                cockpitDataTypeID = this.getCockpitController().getPlatformAdapterModuleManager().getDataManagerAdapter(repositoryObjectType).getCockpitDataTypeID();
            }
            final String referencedCockpitUID = this.getObjectUID(objectID);
            targetRelationContributions[index] = new IRelationContributionForPermissionCheck(){

                @Override
                public IRepositoryRelationContributionRoleID getRepositoryRelationContributionRoleID() {
                    return relationContributionRoleID;
                }

                @Override
                public String getDataTypeIDOfTheDatasAncestor() {
                    return cockpitDataTypeID;
                }

                @Override
                public String getCockpitDataUID() {
                    return referencedCockpitUID;
                }
            };
            ++index;
        }
        return targetRelationContributions;
    }

    @Override
    public IRepositoryObjectReference getRepositoryObjectReference(ICockpitProjectData cockpitData) {
        IDataManagerAdapter dataManagerAdapter = this.getRepositoryInterfaceImplementation().getDataManagerAdapter(cockpitData);
        IRepositoryObjectTypeID objectTypeID = dataManagerAdapter.getRepositoryObjectTypeID();
        IRepositoryPropertySetSample objectID = this.getObjectID(cockpitData.getUID());
        return new RepositoryObjectReference(objectTypeID, objectID);
    }

    private static class ObjectIDPropertySetSample
    implements IRepositoryPropertySetSample {
        private final IRepositoryPropertySample propertySample;
        private ICollection_<IRepositoryPropertySample> propertySampleSingletonList;

        public ObjectIDPropertySetSample(IRepositoryPropertySample propertySample) {
            this.propertySample = propertySample;
        }

        public IRepositoryPropertySample getPropertySample(IRepositoryPropertyTypeID repositoryPropertyTypeID) {
            return this.propertySample;
        }

        public ICollection_<IRepositoryPropertySample> getPropertySamples() {
            if (this.propertySampleSingletonList == null) {
                this.propertySampleSingletonList = Collections_.singletonList((Object)this.propertySample);
            }
            return this.propertySampleSingletonList;
        }

        public ISet_<IRepositoryPropertyTypeID> getPropertyTypeIDs() {
            return OBJECTID_PROPERTYTYPEIDS;
        }
    }
}

