/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterAttributeSet;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterItem;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterOccurrenceRelation;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameDataConverter;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IOccurrence;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryIDLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryObjectLockSample;
import com.arcway.repository.interFace.data.lock.RepositoryObjectLockType;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.item.IRepositoryItemType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IOccurrenceRepositoryRelationContributionType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;

public class PlatformAdapterObject
extends PlatformAdapterItem
implements IRepositoryObject,
ICockpitDataID,
IAdaptable {
    private final IDataManagerAdapter dataManagerAdapter;
    private final ICockpitProjectData cockpitData;
    private final Map<IRepositoryAttributeSetType, PlatformAdapterAttributeSet> allAttributeSets;
    private final ICockpitDataID cockpitDataID;
    private final IRepositoryObjectType repositoryOjectType;

    public PlatformAdapterObject(PlatformAdapterSnapshot snapshot, IDataManagerAdapter dataManagerAdapter, ICockpitProjectData relatedCockpitObject) {
        super(snapshot);
        Assert.checkArgumentBeeingNotNull((Object)dataManagerAdapter);
        Assert.checkArgumentBeeingNotNull((Object)relatedCockpitObject);
        this.dataManagerAdapter = dataManagerAdapter;
        this.cockpitData = relatedCockpitObject;
        this.cockpitDataID = new CockpitDataID(relatedCockpitObject);
        this.repositoryOjectType = this.getTypeManager().getObjectType(dataManagerAdapter.getRepositoryObjectTypeID());
        ICollection_ attributeSetTypes = this.repositoryOjectType.getAttributeSetTypes();
        this.allAttributeSets = new HashMap<IRepositoryAttributeSetType, PlatformAdapterAttributeSet>(attributeSetTypes.size());
        for (IRepositoryAttributeSetType currentAttributeSetType : attributeSetTypes) {
            PlatformAdapterAttributeSet attributeSet = new PlatformAdapterAttributeSet(this, currentAttributeSetType);
            this.allAttributeSets.put(currentAttributeSetType, attributeSet);
        }
    }

    private PlatformAdapterAttributeSet fetchParentAttributeSet() throws EXNotReproducibleSnapshot {
        PlatformAdapterAttributeSet parentAttributeSet;
        this.checkSnapshotIDIsStillCurrent();
        PlatformAdapterObject rootObjectID = this.getSnapshotImplementation().getRootObjectImplementation();
        if (rootObjectID.getCockpitDataTypeID().equals(this.getCockpitDataTypeID()) && rootObjectID.getCockpitDataUID().equals(this.getCockpitDataUID())) {
            parentAttributeSet = null;
        } else {
            ICockpitDataID parentCockpitDataID = this.dataManagerAdapter.getParentCockpitDataID(this.getCockpitData());
            Assert.checkArgumentBeeingNotNull((Object)parentCockpitDataID);
            PlatformAdapterObject parentObject = this.fetchObject(parentCockpitDataID);
            IRepositoryObjectType concreteParentObjectType = parentObject.getObjectType();
            IRepositoryObjectType concreteChildObjectType = this.getObjectType();
            IRepositoryAttributeSetType attributeSetType = concreteParentObjectType.getParentRelationContributionTypeOfChildObjectType(concreteChildObjectType).getRelatedAttributeSetType();
            IRepositoryAttributeSetType attributeSetTypeOfParent = concreteParentObjectType.getAttributeSetType(attributeSetType.getRepositoryAttributeSetTypeID());
            parentAttributeSet = parentObject.getAttributeSetImplementation(attributeSetTypeOfParent);
        }
        return parentAttributeSet;
    }

    IDataManagerAdapter getDataManagerAdapter() {
        return this.dataManagerAdapter;
    }

    public IRepositoryDeclarationItem getType() {
        return this.getItemType();
    }

    public IRepositoryItemType getItemType() {
        return this.getObjectType();
    }

    public IRepositoryObjectType getObjectType() {
        return this.repositoryOjectType;
    }

    public ICockpitProjectData getCockpitData() {
        return this.cockpitData;
    }

    public IRepositoryObjectTypeCategory getObjectTypeCategory() {
        ObjectTypeCategory category = this.dataManagerAdapter.getObjectTypeCategory(this.cockpitData);
        return category != null ? this.getSnapshotImplementation().fetchCategory(category) : null;
    }

    PlatformAdapterAttributeSet getParentAttributeSetImplementation() throws EXNotReproducibleSnapshot {
        return this.fetchParentAttributeSet();
    }

    public IRepositoryAttributeSet getParentAttributeSet() throws EXNotReproducibleSnapshot {
        return this.getParentAttributeSetImplementation();
    }

    PlatformAdapterAttributeSet getAttributeSetImplementation(IRepositoryAttributeSetType repositoryAttributeSetType) {
        PlatformAdapterAttributeSet attributeSet = this.allAttributeSets.get(this.getObjectType().findAttributeSetType(repositoryAttributeSetType.getRepositoryAttributeSetTypeID()));
        Assert.checkArgumentBeeingNotNull((Object)attributeSet);
        return attributeSet;
    }

    public IRepositoryAttributeSet getAttributeSet(IRepositoryAttributeSetType repositoryAttributeSetType) throws EXNotReproducibleSnapshot {
        return this.getAttributeSetImplementation(repositoryAttributeSetType);
    }

    public IRepositoryObjectSample sample() throws EXNotReproducibleSnapshot {
        return new RepositoryObjectSample((IRepositoryObject)this);
    }

    public void modifyObjectTypeCategory(IRepositoryObjectTypeCategoryID newCategoryID) throws EXLockDenied, EXPermissionDenied {
        try {
            String newCategoryID_asOldCockpitID = newCategoryID != null ? newCategoryID.toCanonicalString() : null;
            this.dataManagerAdapter.modifyCockpitDataObjectTypeCategory(this.cockpitData, newCategoryID_asOldCockpitID);
        }
        catch (EXCockpitLockDenied e) {
            throw FrameDataConverter.convertEXCockpitLockDenied(e);
        }
        catch (EXCockpitPermissionDenied e) {
            throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
        }
    }

    public void delete() throws EXLockDenied, EXPermissionDenied {
        try {
            this.dataManagerAdapter.deleteCockpitData(this.getCockpitData());
        }
        catch (EXCockpitLockDenied e) {
            throw FrameDataConverter.convertEXCockpitLockDenied(e);
        }
        catch (EXCockpitPermissionDenied e) {
            throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
        }
    }

    public IRepositoryPropertySetSample getSnapshotIDOfLastModification(final RepositoryObjectLockType lockType) {
        AbstractRepositoryObjectLockSample objectLockSample = new AbstractRepositoryObjectLockSample(){

            public RepositoryObjectLockType getLockType() {
                return lockType;
            }

            public IRepositoryPropertySetSample getObjectID() {
                String cockpitDataUID = PlatformAdapterObject.this.cockpitData.getUID();
                return PlatformAdapterObject.this.getWorkstationImplementation().getObjectID(cockpitDataUID);
            }

            public IRepositoryObjectTypeID getObjectTypeID() {
                return PlatformAdapterObject.this.getObjectType().getRepositoryObjectTypeID();
            }

            public IRepositoryPropertySetSample getBasedSnapshotID() {
                return RepositorySamples.getSnapshotID((IRepositoryObjectSample)PlatformAdapterObject.this.getSnapshotImplementation().getSnapshotInformation(), (IRepositoryTypeManagerRO)PlatformAdapterObject.this.getTypeManager());
            }
        };
        EOPlatformLock eoLock = this.getSnapshotImplementation().getWorkstationImplementation().createEOLock((AbstractRepositoryLockSample)objectLockSample);
        String commitUID = this.getLockManager().getCommitUID(eoLock);
        return this.getWorkstationImplementation().getSnapshotID(commitUID);
    }

    public IRepositoryPropertySetSample getSnapshotIDOfLastIDModification(final IRepositoryPropertyType propertyType, final IRepositoryPropertySample id) {
        AbstractRepositoryIDLockSample objectLockSample = new AbstractRepositoryIDLockSample(){

            public IRepositoryPropertySetSample getBasedSnapshotID() {
                return RepositorySamples.getSnapshotID((IRepositoryObjectSample)PlatformAdapterObject.this.getSnapshotImplementation().getSnapshotInformation(), (IRepositoryTypeManagerRO)PlatformAdapterObject.this.getTypeManager());
            }

            public IRepositoryPropertySetSample getContextObjectID() {
                String cockpitDataUID = PlatformAdapterObject.this.cockpitData.getUID();
                return PlatformAdapterObject.this.getWorkstationImplementation().getObjectID(cockpitDataUID);
            }

            public IRepositoryObjectTypeID getContextObjectTypeID() {
                return PlatformAdapterObject.this.getObjectType().getRepositoryObjectTypeID();
            }

            public IRepositoryPropertySample getID() {
                return id;
            }

            public IRepositoryPropertyTypeID getPropertyTypeID() {
                return propertyType.getRepositoryPropertyTypeID();
            }

            public IRepositoryObjectTypeID getObjectTypeID() {
                return propertyType.getAttributeSetType().getObjectType().getRepositoryObjectTypeID();
            }
        };
        EOPlatformLock eoLock = this.getSnapshotImplementation().getWorkstationImplementation().createEOLock((AbstractRepositoryLockSample)objectLockSample);
        String commitUID = this.getLockManager().getCommitUID(eoLock);
        return this.getWorkstationImplementation().getSnapshotID(commitUID);
    }

    @Override
    public String getCockpitDataTypeID() {
        return this.cockpitData.getTypeID();
    }

    @Override
    public String getCockpitDataUID() {
        return this.cockpitData.getUID();
    }

    public Object getAdapter(Class adapter) {
        if (ICockpitProjectData.class.isAssignableFrom(adapter)) {
            return this.cockpitData;
        }
        return null;
    }

    public int hashCode() {
        return this.cockpitDataID.hashCode();
    }

    public boolean equals(Object obj) {
        return this.cockpitDataID.equals(obj);
    }

    public ICollection_<? extends IOccurrenceRepositoryRelation> getOccurrenceRelations(IOccurrenceRepositoryRelationContributionType occurenceRelationContributionType) throws EXNotReproducibleSnapshot {
        ICollection_<PlatformAdapterOccurrenceRelation> occurenceRelations;
        IOccurrenceRepositoryRelationType occurenceRelationType = occurenceRelationContributionType.getRelatedRelationType();
        IOccurrenceManager occurenceManager = this.getOccurrenceManager(occurenceRelationType);
        if (occurenceManager != null) {
            Collection<IOccurrence> occurences = occurenceManager.getOccurrencesOfOccurringData(this.getCockpitDataUID());
            occurenceRelations = this.getSnapshotImplementation().fetchRelations(occurenceRelationType, occurences);
        } else {
            occurenceRelations = new ICollection_<PlatformAdapterOccurrenceRelation>();
        }
        return occurenceRelations;
    }
}

