/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.settings.local;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.EOArcwayMemento;
import de.plans.lib.xml.ISaveListener;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLDecoderPool;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ProjectSettingsStore
implements IFrameDataManager,
ISaveListener {
    private static final ILogger logger = Logger.getLogger(ProjectSettingsStore.class);
    private File saveFile;
    private EOList<EOArcwayMemento> localSettings = new EOList();

    public Collection<? extends EOArcwayMemento> getLocalSettings() {
        return this.localSettings;
    }

    public EOArcwayMemento getLocalSetting(String requesterID) {
        EOArcwayMemento setting2;
        if (this.localSettings == null) {
            this.localSettings = new EOList();
        }
        for (EOArcwayMemento setting2 : this.localSettings) {
            if (!setting2.getRequesterID().equals(requesterID)) continue;
            return setting2;
        }
        setting2 = new EOArcwayMemento(requesterID, "rootMemento", (ISaveListener)this);
        this.localSettings.add((EncodableObjectBase)setting2);
        return setting2;
    }

    public void setLocalSettings(Collection<? extends EOArcwayMemento> localSettings) {
        this.localSettings = new EOList(localSettings);
    }

    public boolean writeFile(File file) {
        boolean success = true;
        if (this.localSettings != null) {
            try {
                BufferedOutputStream b_out = new BufferedOutputStream(new FileOutputStream(file));
                success = this.write(b_out);
            }
            catch (FileNotFoundException e) {
                success = false;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean write(OutputStream b_out) {
        assert (this.localSettings != null);
        try {
            ProjectSettingsStore projectSettingsStore = this;
            synchronized (projectSettingsStore) {
                this.localSettings.writeToXMLStream(b_out, true);
            }
            b_out.close();
            return true;
        }
        catch (Exception e) {
            logger.error("could not write stakeholder modifications to file", (Throwable)e);
            return false;
        }
    }

    public void save() {
        this.writeFile(this.saveFile);
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
        this.saveFile = administrator.getProjectSettingsFile();
        try {
            if (this.saveFile.exists()) {
                this.read(this.saveFile);
            }
        }
        catch (Throwable ta) {
            logger.error("could not read from file " + this.saveFile.getAbsolutePath(), ta);
        }
    }

    private boolean read(File settingsFile) {
        try {
            this.localSettings = (EOList)XMLDecoderPool.decodeXMLFile((File)settingsFile, (IEncodableObjectFactory)new IEncodableObjectFactory(){

                public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
                    if (name.equals("com.arcway.cockpit.frame.client.project.localsettings.EOLocalSetting")) {
                        return new EOArcwayMemento(context, (ISaveListener)ProjectSettingsStore.this);
                    }
                    return MessageDataFactory.getInstance().createEncodableObject(name, context);
                }
            }, (boolean)true);
            return true;
        }
        catch (Throwable ta) {
            logger.error("could not read from file ", ta);
            this.localSettings = null;
            return false;
        }
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public String getLocalizedManagerName() {
        return Messages.getString("LocalSettingsStore.local_settings_store");
    }

    @Override
    public void discardLocalModifications() {
        this.localSettings.clear();
    }

    @Override
    public boolean hasLocalModifications() {
        return false;
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return false;
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        return null;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        return null;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        return null;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    public void applySynchronousModification(EOFrameDataModification frameDataModification) {
        throw new UnsupportedOperationException();
    }

    public void applyAsynchronousModifications(EOFrameDataModification frameDataModification) {
        throw new UnsupportedOperationException();
    }

    public Collection getData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        throw new UnsupportedOperationException();
    }

    public Collection getChildren(IAttributeOwner parent) {
        throw new UnsupportedOperationException();
    }

    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    public Collection addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
        throw new UnsupportedOperationException();
    }

    public List importDataFromEO(List eos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        throw new UnsupportedOperationException();
    }
}

