/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.offlinemode;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.offlinemode.IOfflineDataProvider;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineDataContainer;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineFrameServerProxyDataContainer;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineModeManager;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineDataNotAvailable;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineMode;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOCommit;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.serverexceptions.EXPendingAsynchronousUpdates;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.message.IPermissionOwner;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class OfflineFrameServerProxy
implements IFrameServerProxy {
    private static final ILogger logger = Logger.getLogger(OfflineFrameServerProxy.class);
    private static final String FILE_NAME_SUPRESSED_PERMISSIONS_IDS = "permissions.data";
    public static final String ROLE_ADDED_PERMISSIONS = "addedpermissions";
    public static final String ROLE_REMOVED_PERMISSIONS = "removedpermissions";
    private final IFrameProjectAgent projectAgent;
    private final IOfflineDataProvider offlineDataProvider;
    private EOUserAndGroupAndPermissions userData = null;
    private Collection<EOGroup> allServerGroups = null;
    private Collection<EOUser> allServerUser = null;
    private Collection<EOPermission> allPermissions = null;
    private EOList<EOPermission> removedPermissions;
    private EOList<EOPermission> addedPermissions;

    public static OfflineFrameServerProxyDataContainer cleanUpWithBackup(File projectRootDirectory) throws IOException, EXDecoderException {
        XMLFileAccessor<EOList<EOList<EOPermission>>> permissionsXmlFileAccessor = OfflineFrameServerProxy.createSupressedPermissionsFileAccessor(projectRootDirectory);
        EOList supressedPermissions = (EOList)permissionsXmlFileAccessor.read();
        if (supressedPermissions == null) {
            supressedPermissions = new EOList();
        }
        permissionsXmlFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(null));
        return new OfflineFrameServerProxyDataContainer((EOList<EOList<EOPermission>>)supressedPermissions);
    }

    public static void cleanUp(File projectRootDirectory) {
    }

    public static void restoreFromBackup(File projectRootDirectory, OfflineFrameServerProxyDataContainer backup) {
        XMLFileAccessor<EOList<EOList<EOPermission>>> permissionXmlFileAccessor = OfflineFrameServerProxy.createSupressedPermissionsFileAccessor(projectRootDirectory);
        permissionXmlFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(backup.getSupressedPermissions()));
    }

    private static XMLFileAccessor<EOList<EOList<EOPermission>>> createSupressedPermissionsFileAccessor(File projectRootDirectory) {
        File offlineDataFile = OfflineModeManager.getOfflineDataRelatedFile(FILE_NAME_SUPRESSED_PERMISSIONS_IDS, projectRootDirectory);
        XMLFileAccessor xmlFileAccessor = new XMLFileAccessor(offlineDataFile, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        return xmlFileAccessor;
    }

    public OfflineFrameServerProxy(IFrameProjectAgent projectAgent, IOfflineDataProvider offlineDataProvider) throws EXCorruptProjectData {
        this.projectAgent = projectAgent;
        this.offlineDataProvider = offlineDataProvider;
        try {
            this.initializeSupressedPermissionData(projectAgent.getProjectRoot());
        }
        catch (IOException e) {
            throw new EXCorruptProjectData((Exception)e);
        }
        catch (EXDecoderException e) {
            throw new EXCorruptProjectData((Exception)((Object)e));
        }
    }

    @Override
    public EOUser getCurrentUser() {
        Assert.checkState((this.userData != null ? 1 : 0) != 0, (String)"Server Data was not yet requestet. Therefore, user data is not loaded.");
        return this.userData.getUser();
    }

    @Override
    public EOUserAndGroupAndPermissions getUserData(boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        Assert.checkState((this.userData != null ? 1 : 0) != 0, (String)"Server Data was not yet requestet. Therefore, user data is not loaded.");
        return this.userData;
    }

    private ServerDataContainer loadOfflineData() throws EXOfflineDataNotAvailable {
        OfflineDataContainer offlineDataContainer = this.offlineDataProvider.getOfflineData();
        if (this.userData == null) {
            this.userData = offlineDataContainer.getUserData();
        }
        if (this.allServerGroups == null) {
            this.allServerGroups = offlineDataContainer.getAllServerGroups();
        }
        if (this.allServerUser == null) {
            this.allServerUser = offlineDataContainer.getAllServerUsers();
        }
        if (this.allPermissions == null) {
            this.allPermissions = offlineDataContainer.getAllPermissions();
        }
        return offlineDataContainer.getServerDataContainer();
    }

    private void initializeSupressedPermissionData(File projectRootDirectory) throws IOException, EXDecoderException {
        XMLFileAccessor<EOList<EOList<EOPermission>>> permissionsXmlFileAccessor = OfflineFrameServerProxy.createSupressedPermissionsFileAccessor(projectRootDirectory);
        EOList supressedPermissions = (EOList)permissionsXmlFileAccessor.read();
        if (supressedPermissions != null) {
            for (EOList permissions : supressedPermissions) {
                if (permissions.getRole().equals(ROLE_REMOVED_PERMISSIONS)) {
                    this.removedPermissions = permissions;
                    continue;
                }
                this.addedPermissions = permissions;
            }
        } else {
            this.removedPermissions = new EOList(ROLE_REMOVED_PERMISSIONS);
            this.addedPermissions = new EOList(ROLE_ADDED_PERMISSIONS);
        }
    }

    @Override
    public EOList<EOPlatformLock> allocateLocks(Collection<EOPlatformLock> locksToCheck, Collection<EOPlatformLock> locksToRelease, Collection<EOPlatformLock> locksToAllocate) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Collection<EOLock>> atomicCheckAndSetLocks(Collection<EOLock> locksToBeChecked, Collection<EOLock> clientLocksNeededByServer, Collection<EOLock> locksToBeSet) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EOLock> getForeignLocks(Collection<EOLock> clientLocksNeededByServer, boolean considerCommitVersion) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EOCommit commitProject(EOCommit projectModifications, Shell parentShell) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean concurrentWorkPossible() {
        return false;
    }

    @Override
    public void downloadFile(FileID fileID, File file) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean fileExistsOnServer(FileID fileID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IPermissionOwner> getAllPermissionOwners() {
        ArrayList<IPermissionOwner> permissionOwners = new ArrayList<IPermissionOwner>();
        permissionOwners.addAll(this.getAllServerUsers());
        permissionOwners.addAll(this.getAllServerGroups());
        permissionOwners.addAll(this.projectAgent.getFrameStakeholderManager().getRoles());
        return permissionOwners;
    }

    @Override
    public List<EOPermission> getAllPermissions() {
        Assert.checkState((this.allPermissions != null ? 1 : 0) != 0, (String)"Server Data was not yet requestet. Therefore, permissions are not loaded.");
        return (List)this.allPermissions;
    }

    @Override
    public Collection<EOGroup> getAllServerGroups() {
        Assert.checkState((this.allServerGroups != null ? 1 : 0) != 0, (String)"Server Data was not yet requestet. Therefore, server user data is not loaded.");
        return this.allServerGroups;
    }

    @Override
    public Collection<EOUser> getAllServerUsers() {
        Assert.checkState((this.allServerGroups != null ? 1 : 0) != 0, (String)"Server Data was not yet requestet. Therefore, server group data is not loaded.");
        return this.allServerUser;
    }

    @Override
    public String getAvailabilityState() {
        return null;
    }

    @Override
    public boolean isCommitable() {
        return false;
    }

    @Override
    public boolean prepareCommit(boolean useDefaultDestination, Shell parentShell) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshProject() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseLocks(Collection<EOLock> locksToBeReleased) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EOClientRequest subscribeListenerOnClientBusAndGetRequestToRegisterOnServer(INotificationBusListener listener, String notificationtype) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void subscribeListenerOnServer(INotificationBusListener listener, String notificationtype) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
    }

    @Override
    public void unsubscribeListenerOnServer(INotificationBusListener listener, String notificationType) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
    }

    @Override
    public boolean supportsVersioning() {
        return false;
    }

    public EOFrameData getVersion(String itemUID, String typeID, int modCount, String requestGroupID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EOCockpitProjectData> getAllVersions(String itemUID, String typeID, String requestGroupID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updatePermissions(Collection<EOPermission> permissionsToAdd, Collection<EOPermission> permissionsToRemove) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        if (permissionsToAdd != null && !permissionsToAdd.isEmpty()) {
            logger.error("Tried to add permissions in offline mode. This is currently not supported.");
        }
        this.removedPermissions.addAll(permissionsToRemove);
        XMLFileAccessor<EOList<EOList<EOPermission>>> permissionsXmlFileAccessor = OfflineFrameServerProxy.createSupressedPermissionsFileAccessor(this.projectAgent.getProjectRoot());
        permissionsXmlFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOList<EOList<EOPermission>>>(){

            public EOList<EOList<EOPermission>> getFileContent() {
                EOList supressedPermissions = new EOList();
                supressedPermissions.add((EncodableObjectBase)OfflineFrameServerProxy.this.removedPermissions);
                supressedPermissions.add((EncodableObjectBase)OfflineFrameServerProxy.this.addedPermissions);
                return supressedPermissions;
            }
        });
    }

    @Override
    public List<String> uploadFiles(List<File> files) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        throw new UnsupportedOperationException();
    }

    @Override
    public EOServerResponse sendRequest(String reqGroup, String reqSubID, EncodableObjectBase reqParam) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException, EXOfflineMode {
        throw new EXOfflineMode();
    }

    @Override
    public ServerDataContainer fetchServerDataContainer(Collection<EOLock> allLocksCurrentlyAllocatedOnServer) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException, EXOfflineDataNotAvailable, EXPendingAsynchronousUpdates {
        return this.offlineDataProvider.getOfflineData().getServerDataContainer();
    }

    @Override
    public ServerDataContainer setupAfterDataManagersAreCreated() throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException, EXOfflineDataNotAvailable {
        ServerDataContainer referenceToServerData = this.loadOfflineData();
        return referenceToServerData;
    }
}

