/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version4;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.shared.message.EOPermission;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReportTemplatePermissionMigrator
implements ICockpitMigrator {
    public static final String KEY = "reporttemplate-permission-migrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 4;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    EOList<EOPermission> permissions = historicView.readPermissions(currentProject);
                    ReportTemplatePermissionMigrator.migratePermissions(permissions);
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTorACP(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTorACP(projectFile);
    }

    private void migrateACTorACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
        try {
            EOList<? extends EncodableObjectBase> basePermissionList = projectFileView_3_.getDataList("permissions");
            ReportTemplatePermissionMigrator.migratePermissions(basePermissionList);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException(pfaE);
        }
    }

    private static void migratePermissions(Collection<EOPermission> permissions) {
        for (EOPermission permission : permissions) {
            if (!permission.getOperandType().equals("frame.project")) continue;
            permission.setOperandType("project");
        }
    }
}

