/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.OccurrenceList;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Locale;

public class UniqueElementHelper {
    private static final ILogger LOGGER = Logger.getLogger(UniqueElementHelper.class);

    public static final boolean isElementAssigned(IUniqueElement uniqueElement) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(uniqueElement.getProjectUID());
        IFrameUniqueElementManager uniqueElementMgr = projectAgent.getFrameUniqueElementMgr();
        OccurrenceList occurenceList = uniqueElementMgr.getUniqueElementOccurrences(uniqueElement.getUID());
        return !occurenceList.isEmpty();
    }

    public static final IConstructionElementTypeDescription getElementType(IUniqueElement uniqueElement) {
        try {
            return ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(uniqueElement.getElementTypeID());
        }
        catch (EXConstructionElementTypeUnknown e) {
            LOGGER.error("unknown unique element type", (Throwable)e);
            return null;
        }
    }

    public static final String getElementTypeName(IUniqueElement uniqueElement, Locale locale) {
        IConstructionElementTypeDescription meType = UniqueElementHelper.getElementType(uniqueElement);
        if (meType != null) {
            return meType.getConstructionElementTypeName(locale);
        }
        return "[unknown]";
    }
}

