/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameUniqueElementValidator;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyUniqueElements;
import com.arcway.cockpit.frame.client.project.IFrameLockManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionDefinitions;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.UniqueElementNormalizer;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;
import java.util.Collections;

public class UniqueElementAttributeModificationManager
implements IAttributeModificationManager {
    private UniqueElement uniqueElement;
    private final IFrameProjectAgent projectAgent;
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return UniqueElementAttributeModificationManager.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };

    public UniqueElementAttributeModificationManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameUniqueElementMgr().isLocallyAdded(this.uniqueElement.getUID())) {
            IAttributeType attributeType = this.uniqueElement.getAttributeType(newAttribute.getAttributeTypeID());
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree);
            transactionController.addLockToTest(this.uniqueElement, "modify");
            transactionController.addLock(this.uniqueElement, "modify");
        }
        if (newAttribute.getAttributeTypeID().equals(UniqueElementAttributeTypesProvider.ATTRID_DISPLAY_NAME)) {
            String newName = (String)newAttribute.getAttributeValue();
            RenameUniqueElementValidator validator = new RenameUniqueElementValidator(this.uniqueElement, this.projectAgent);
            String msg = validator.isValid(newName = UniqueElementNormalizer.normalizeValue((String)newName));
            if (msg != null) {
                ModificationProblem modProblem = new ModificationProblem(Messages.getString("UniqueElementAttributeModificationManager.new_Name_is_invalid0"), msg);
                transactionController.addLockModificationProblem(modProblem);
            }
            String lockType = this.projectAgent.getFrameUniqueElementMgr().getRenameOperationForLock(newName, this.uniqueElement.getElementTypeID());
            transactionController.addLockToTest(this.projectAgent, lockType);
            transactionController.addLock(this.projectAgent, lockType);
        }
    }

    @Override
    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyUniqueElements.getInstance());
        if (this.projectAgent.getFrameUniqueElementMgr().isLocallyAdded(this.uniqueElement.getUID())) {
            this.checkObjectTypeCategoryModificationPermission(transactionController);
        }
        transactionController.addLockToTest(this.uniqueElement, "modify");
        transactionController.addLock(this.uniqueElement, "modify");
    }

    @Override
    @Deprecated
    public IModificationProblem checkLocks() {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFrameUniqueElementMgr().isLocallyAdded(this.uniqueElement.getUID())) {
            Throwable serverException = null;
            try {
                EOLock lock = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.uniqueElement, "modify");
                if (lock != null) {
                    modProblem = new ModificationProblem(lock, Messages.getString("UniqueElementAttributeModificationManager.can_not_modify_ue"));
                }
            }
            catch (ServerNotAvailableException e) {
                serverException = e;
            }
            catch (LoginCanceledException e) {
                serverException = e;
            }
            catch (EXServerException e) {
                serverException = e;
            }
            catch (UnknownServerException e) {
                serverException = e;
            }
            if (serverException != null) {
                modProblem = new ModificationProblem((Exception)serverException, Messages.getString("UniqueElementAttributeModificationManager.can_not_modify_ue"));
            }
        }
        return modProblem;
    }

    public void checkGeneralModificationPermissions(IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameUniqueElementMgr().isLocallyAdded(this.uniqueElement.getUID())) {
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree, false);
            transactionController.addLockToTest(this.uniqueElement, "modify");
        }
    }

    @Override
    public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.checkGeneralModificationPermissions(attributeType, transactionController);
        Collection<IModificationProblem> modProblems = transactionController.checkConditions(true, true);
        return modProblems;
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        boolean isLocallyAdded = this.projectAgent.getFrameUniqueElementMgr().isLocallyAdded(this.uniqueElement.getUID());
        if (!isLocallyAdded) {
            IAttributeType attributeType = this.uniqueElement.getAttributeType(newAttribute.getAttributeTypeID());
            if (!this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, this.operandTree, false)) {
                ModificationProblem modProblem = new ModificationProblem(attributeType, this.operandTree, this.projectAgent);
                throw new EXNoPermission(modProblem.getHumanReadableDescriptionOfCause());
            }
        }
        if (newAttribute.getAttributeTypeID().equals(UniqueElementAttributeTypesProvider.ATTRID_DISPLAY_NAME)) {
            String newName = (String)newAttribute.getAttributeValue();
            RenameUniqueElementValidator validator = new RenameUniqueElementValidator(this.uniqueElement, this.projectAgent);
            String msg = validator.isValid(newName = UniqueElementNormalizer.normalizeValue((String)newName));
            if (msg != null) {
                throw new EXNoPermission(msg);
            }
            if (!isLocallyAdded) {
                if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(this.projectAgent, this.projectAgent.getFrameUniqueElementMgr().getRenameOperationForLock(newName, this.uniqueElement.getElementTypeID()))) {
                    throw new EXNoLock(this.projectAgent, this.projectAgent.getFrameUniqueElementMgr().getRenameOperationForLock(newName, this.uniqueElement.getElementTypeID()));
                }
                String oldName = (String)oldAttributeValue;
                oldName = UniqueElementNormalizer.normalizeValue((String)oldName);
                IFrameLockManager lockMgr = this.projectAgent.getFrameLockManager();
                Collection<EOLock> locksToRelease = lockMgr.findClientLocksByILockable(this.projectAgent, this.projectAgent.getFrameUniqueElementMgr().getRenameOperationForLock(oldName, this.uniqueElement.getElementTypeID()));
                if (locksToRelease != null) {
                    lockMgr.releaseLocks(locksToRelease);
                }
            }
        }
        if (!isLocallyAdded && !this.projectAgent.getFrameLockManager().clientAlreadyHasLock(this.uniqueElement, "modify")) {
            throw new EXNoLock(this.uniqueElement, "modify");
        }
        this.projectAgent.getFrameUniqueElementMgr().dataModified(this.uniqueElement);
    }

    public void setUniqueElement(UniqueElement uniqueElement) {
        this.uniqueElement = uniqueElement;
    }

    @Override
    public void modifyCategoryID() throws EXNoPermission, EXNoLock {
        boolean isLocallyAdded = this.projectAgent.getFrameUniqueElementMgr().isLocallyAdded(this.uniqueElement.getUID());
        if (!isLocallyAdded) {
            if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(this.uniqueElement, "modify")) {
                throw new EXNoLock(this.uniqueElement, "modify");
            }
            if (!this.projectAgent.getFramePermissionChecker().hasPermission("modify-category", "com.arcway.cockpit.uniqueelement", this.projectAgent)) {
                ModificationProblem modProblem = new ModificationProblem(FramePermissionDefinitions.MODIFY_MODEL_ELEMENT_CATEGORY_TEMPLATE, null, this.projectAgent);
                throw new EXNoPermission(modProblem.getHumanReadableDescriptionOfCause());
            }
        }
        this.projectAgent.getFrameUniqueElementMgr().dataModified(this.uniqueElement);
    }

    @Override
    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        if (!this.projectAgent.getFrameUniqueElementMgr().isLocallyAdded(this.uniqueElement.getUID())) {
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.checkObjectTypeCategoryModificationPermission(transactionController);
            return transactionController.checkConditions(false, true);
        }
        return Collections.emptyList();
    }

    private void checkObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addPermission("modify-category", "com.arcway.cockpit.uniqueelement", this.projectAgent);
    }
}

