/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.reporttemplates;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.IDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportOutputtemplateRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportOutputtemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.Collection;

public class ReportOutputtemplate
extends AbstractFrameData
implements IReportOutputtemplateRW {
    private static final ILogger logger = Logger.getLogger(ReportOutputtemplate.class);

    public ReportOutputtemplate(EOFrameData eo, IFrameProjectAgent projectAgent, IAttributeModificationManager modManager) {
        super(eo, FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, modManager, projectAgent);
    }

    public ReportOutputtemplate(String uID, Collection<IAttribute> attributes, IAttributeModificationManager modManager, IFrameProjectAgent projectAgent) {
        super(uID, projectAgent.getUID(), FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, attributes, modManager, projectAgent);
    }

    @Override
    public File getFile() {
        File result = null;
        try {
            IAttribute attribute = this.getAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_FILE);
            IAttributeType attributeType = this.getAttributeType(attribute.getAttributeTypeID());
            IDataTypeWithFile dataType = (IDataTypeWithFile)attributeType.getDataType();
            result = dataType.getFileCopy(attribute.getAttributeValue());
        }
        catch (ExInvalidAttributeType e) {
            logger.error("Could not get file attribute.", (Throwable)e);
        }
        catch (ServerNotAvailableException e) {
            logger.error("Could not get report output template file.", (Throwable)e);
        }
        catch (EXServerException e) {
            logger.error("Could not get report output template file.", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error("Could not get report output template file.", (Throwable)e);
        }
        catch (UnknownServerException e) {
            logger.error("Could not get report output template file.", (Throwable)e);
        }
        catch (ExPrematureEndOfTransfer e) {
            logger.error("Could not get report output template file.", (Throwable)e);
        }
        return result;
    }

    @Override
    public String getDescription() {
        try {
            IAttribute attribute = this.getAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_DESCRIPTION);
            return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getFormatPalettes() {
        IAttribute attribute = this.getAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_FORMATPALETTE);
        return (String)attribute.getAttributeValue();
    }

    @Override
    public String getName() {
        IAttribute attribute = this.getAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_NAME);
        return (String)attribute.getAttributeValue();
    }

    @Override
    public Integer getImageWidthMM() {
        IAttribute attribute = this.getAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_IMAGE_WIDTH_MM);
        return (Integer)attribute.getAttributeValue();
    }

    @Override
    public Integer getImageHeightMM() {
        IAttribute attribute = this.getAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_IMAGE_HEIGHT_MM);
        return (Integer)attribute.getAttributeValue();
    }

    @Override
    public String getReportOutputTemplateTypeID() {
        IAttribute attribute = this.getAttribute(ReportOutputtemplateAttributeTypesProvider.ATTRID_REPORTOUTPUTTEMPLATETYPEID);
        return (String)attribute.getAttributeValue();
    }
}

