/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.locking;

import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.frame.client.project.core.locking.IProjectLockFetcher;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.osgi.util.NLS;

public class LockTypeDescriptionProvider {
    private static final IHasher_<String> LOCK_TYPE_ID_HASHER = new IHasher_<String>(){

        public int getHashCode(String lockTypeID) {
            int hash = 0;
            hash = lockTypeID.startsWith("uniqueName") ? "uniqueName".hashCode() : lockTypeID.hashCode();
            return hash;
        }

        public boolean isEqual(String lockTypeID1, String lockTypeID2) {
            boolean equal = false;
            equal = lockTypeID1.startsWith("uniqueName") && lockTypeID2.startsWith("uniqueName") ? true : lockTypeID1.equals(lockTypeID2);
            return equal;
        }
    };
    private static final HashMap_<String, String> localizedLockTypes = new HashMap_(LOCK_TYPE_ID_HASHER);
    static final ILogger logger;

    static {
        localizedLockTypes.put((Object)"add", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_ADD);
        localizedLockTypes.put((Object)"delete", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_DEL);
        localizedLockTypes.put((Object)"modify", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_MOD);
        localizedLockTypes.put((Object)"move", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_MOV);
        localizedLockTypes.put((Object)"project_lock_exclusive", (Object)IProjectLockFetcher.LOCALIZED_DESCRIPTION_LOCK_TYPE_PROJECT_LOCK_EXCLUSIVE);
        localizedLockTypes.put((Object)"project_lock_shared", (Object)IProjectLockFetcher.LOCALIZED_DESCRIPTION_LOCK_TYPE_PROJECT_LOCK_SHARED);
        localizedLockTypes.put((Object)"project_lock_block_offline", (Object)IProjectLockFetcher.LOCALIZED_DESCRIPTION_LOCK_TYPE_PROJECT_LOCK_BLOCK_OFFLINE_MODE);
        localizedLockTypes.put((Object)"uniqueID", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_UNIQUE_ID);
        localizedLockTypes.put((Object)"uniqueName", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_UNIQUE_NAME);
        localizedLockTypes.put((Object)"link_lock_linkable_object", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_LINK_LOCK_LO);
        localizedLockTypes.put((Object)"link_lock_module_data", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_LINK_LOCK_MD);
        localizedLockTypes.put((Object)"link_lock_stakeholder_stakeholder_role", (Object)ILockManager.LOCALIZED_DESCRIPTION_LOCK_TYPE_STAKEHOLDER_ROLES);
        logger = Logger.getLogger(LockTypeDescriptionProvider.class);
    }

    public static String getLocalizedLockTypeDescription(String lockTypeID) {
        String localizedLockTypeDescription = (String)localizedLockTypes.getByKey((Object)lockTypeID);
        if (localizedLockTypeDescription == null) {
            logger.debug(NLS.bind((String)"No matching lock type description for lockTypeID: {0}", (Object)lockTypeID));
            localizedLockTypeDescription = lockTypeID;
        }
        return localizedLockTypeDescription;
    }
}

