/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.history;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.FrameHistoryDataCache;
import com.arcway.cockpit.frame.client.project.core.history.IHistoricDataItemConverter;
import com.arcway.cockpit.frame.client.project.core.links.IFrameLinkManager;
import com.arcway.cockpit.frame.shared.IFrameLinkTypeHelper;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.interFace.IVersionedCockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HistoryDataManager<T extends IVersionedCockpitProjectData> {
    private static final ILogger LOGGER = Logger.getLogger(HistoryDataManager.class);
    private final IFrameProjectAgent projectAgent;
    private final IFrameLinkManager linkManager;
    private final IHistoricDataItemConverter<T> dataConverter;
    private final IFrameLinkTypeHelper linkTypeHelper;
    private final String requestGroupID;
    private final Collection<String> typeIDs;
    private final Map<String, FrameHistoryDataCache<T>> historyDataCaches;

    public HistoryDataManager(IFrameProjectAgent projectAgent, IHistoricDataItemConverter<T> dataConverter, IFrameLinkTypeHelper linkTypeHelper, String requestGroupID, Collection<String> typeIDs) {
        this.projectAgent = projectAgent;
        this.linkManager = projectAgent.getLinkManager();
        this.dataConverter = dataConverter;
        this.linkTypeHelper = linkTypeHelper;
        this.requestGroupID = requestGroupID;
        this.typeIDs = new HashSet<String>(typeIDs);
        this.historyDataCaches = new HashMap<String, FrameHistoryDataCache<T>>();
        for (String typeID : typeIDs) {
            this.historyDataCaches.put(typeID, new FrameHistoryDataCache());
        }
    }

    public T getHistoricItem(String UID, String typeID, int modCount) {
        assert (this.typeIDs.contains(typeID));
        T versionedItem = this.historyDataCaches.get(typeID).getData(UID, modCount);
        if (versionedItem == null) {
            versionedItem = this.retrieveVersionAndLinkedItemsRecursively(UID, typeID, modCount);
        }
        return versionedItem;
    }

    public List<? extends T> getHistoricVersionsOfItem(T currentItem) {
        assert (currentItem != null);
        assert (this.typeIDs.contains(currentItem.getTypeID()));
        ArrayList<T> versions = new ArrayList<T>();
        FrameHistoryDataCache<T> historyDataCache = this.historyDataCaches.get(currentItem.getTypeID());
        int modCountUpToWhichAllVersionsAreCached = historyDataCache.getModCountUpToWhichAllVersionsAreCached(currentItem.getUID());
        if (modCountUpToWhichAllVersionsAreCached == 0 || modCountUpToWhichAllVersionsAreCached < currentItem.getModificationCount()) {
            List<EOCockpitProjectData> historicItemEOList = this.projectAgent.getFrameServerProxy().getAllVersions(currentItem.getUID(), currentItem.getTypeID(), this.requestGroupID);
            if (historicItemEOList == null) {
                return Collections.emptyList();
            }
            for (EOCockpitProjectData historicItemEO : historicItemEOList) {
                T version = this.convertVersionAndRetrieveLinkedItemsRecursively(historicItemEO);
                if (version != null) {
                    versions.add(version);
                    continue;
                }
                LOGGER.warn("Could not convert or retrieve linked items of version " + historicItemEO.getModCount() + " of " + currentItem.getTypeID() + " with uid " + currentItem.getUID());
            }
        } else {
            int version = 1;
            while (version <= currentItem.getModificationCount()) {
                versions.add(historyDataCache.getData(currentItem.getUID(), version));
                ++version;
            }
        }
        return versions;
    }

    private T retrieveVersionAndLinkedItemsRecursively(String UID, String typeID, int modCount) {
        T historicItem = this.historyDataCaches.get(typeID).getData(UID, modCount);
        if (historicItem != null) {
            return historicItem;
        }
        EOCockpitProjectData historicItemEO = this.projectAgent.getFrameServerProxy().getVersion(UID, typeID, modCount, this.requestGroupID);
        if (historicItemEO == null) {
            return null;
        }
        historicItem = this.convertVersionAndRetrieveLinkedItemsRecursively(historicItemEO);
        if (historicItem == null) {
            LOGGER.warn("Could not retrieve item version: " + typeID + " / " + UID + " / " + modCount);
        }
        return historicItem;
    }

    private T convertVersionAndRetrieveLinkedItemsRecursively(EOCockpitProjectData historicItemEO) {
        T historicItem = this.dataConverter.convertFromEO(historicItemEO);
        if (this.historyDataCaches.get(historicItem.getTypeID()).getData(historicItem.getUID(), historicItem.getModificationCount()) == null) {
            this.historyDataCaches.get(historicItem.getTypeID()).putDataItem(historicItem);
            for (EOLinkLog link : historicItemEO.getInLinkLogs()) {
                String moduleDataTypeID;
                int moduleDataVersion = link.getModuleDataVersion();
                if (moduleDataVersion != -1 && this.linkTypeHelper != null && this.typeIDs.contains(moduleDataTypeID = this.linkTypeHelper.getLinkSourceDataTypeIDForLinkType(link.getLinkTypeID()))) {
                    String moduleDataUID = link.getModuleDataUID();
                    this.retrieveVersionAndLinkedItemsRecursively(moduleDataUID, moduleDataTypeID, moduleDataVersion);
                }
                this.handOverLinkToLinkManager(link);
            }
            for (EOLinkLog link : historicItemEO.getOutLinkLogs()) {
                String linkableObjectTypeID;
                int linkableObjectVersion = link.getLinkableObjectVersion();
                if (linkableObjectVersion != -1 && this.linkTypeHelper != null && this.typeIDs.contains(linkableObjectTypeID = this.linkTypeHelper.getLinkTargetDataTypeIDForLinkType(link.getLinkTypeID()))) {
                    String linkableObjectUID = link.getLinkableObjectUID();
                    this.retrieveVersionAndLinkedItemsRecursively(linkableObjectUID, linkableObjectTypeID, linkableObjectVersion);
                }
                this.handOverLinkToLinkManager(link);
            }
        }
        return historicItem;
    }

    private void handOverLinkToLinkManager(EOLinkLog link) {
        if (!this.linkManager.addLinkVersion(link).isOK()) {
            LOGGER.warn("Could not add versioned link to the model. Link: " + link.toString());
        }
    }
}

