/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOInteger;

public abstract class EONumberFilterValue
extends EOEncodableObjectWithRole {
    private static final ILogger logger = Logger.getLogger(EONumberFilterValue.class);
    public static final String XML_NAME = "frame.datatypes.numberfiltervalue";
    private static final String DEFAULT_ROLE = "filterValue";
    private static final String ROLE_VALUE_1 = "int1";
    private static final String ROLE_VALUE_2 = "int2";
    private static final String ROLE_FILTER_METHOD = "filterMethod";
    public static final int FILTER_METHOD_LESS = 0;
    public static final int FILTER_METHOD_GREATER = 1;
    public static final int FILTER_METHOD_BETWEEN = 2;
    public static final int FILTER_METHOD_EQUALS = 3;
    private int filterMethod;
    private Number val1;
    private Number val2;

    public EONumberFilterValue(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    public EONumberFilterValue(String xmlName) {
        super(xmlName);
        this.setRole(DEFAULT_ROLE);
    }

    public EONumberFilterValue(String xmlName, Number val1, Number val2) {
        this(xmlName, val1, val2, 2);
    }

    public EONumberFilterValue(String xmlName, Number val1, Number val2, int filterMethod) {
        this(xmlName);
        assert (xmlName != null) : "xmlName must not be null";
        assert (val1 != null) : "val1 must not be null";
        assert (val2 != null) : "val2 must not be null";
        this.val1 = val1;
        this.val2 = val2;
        this.filterMethod = filterMethod;
    }

    public int getFilterMethod() {
        return this.filterMethod;
    }

    public void setFilterMethod(int filterMethod) {
        this.filterMethod = filterMethod;
    }

    public Number getVal1() {
        return this.val1;
    }

    public void setVal1(Number val1) {
        this.val1 = val1;
    }

    public Number getVal2() {
        return this.val2;
    }

    public void setVal2(Number val2) {
        this.val2 = val2;
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.writeChild(this.val1, ROLE_VALUE_1, writeContext, depth);
        this.writeChild(this.val2, ROLE_VALUE_2, writeContext, depth);
        new EOInteger(this.filterMethod, ROLE_FILTER_METHOD).writeXMLBody(writeContext, depth);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        String role;
        block6: {
            block5: {
                role = ((EOEncodableObjectWithRole)newChild).getRole();
                if (!(newChild instanceof EOInteger) || !role.equals(ROLE_FILTER_METHOD)) break block5;
                this.filterMethod = ((EOInteger)newChild).getInteger();
                return true;
            }
            if (!role.equals(ROLE_VALUE_1)) break block6;
            this.val1 = this.extractValue(newChild);
            return true;
        }
        try {
            if (role.equals(ROLE_VALUE_2)) {
                this.val2 = this.extractValue(newChild);
                return true;
            }
        }
        catch (ClassCastException e) {
            logger.warn("Unexpected class", (Throwable)e);
        }
        return false;
    }

    protected abstract Number extractValue(EncodableObjectBase var1) throws ClassCastException;

    protected abstract void writeChild(Number var1, String var2, EncodableObjectBase.WriteContext var3, int var4) throws EXEncoderException;

    public abstract EONumberFilterValue getStandardValue();
}

