/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXInvalidValue;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.client.base.interfaces.frame.gui.ISWTControlModifiedListener;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSingle;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import de.plans.lib.xml.encoding.EOEncodableObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractDataType
implements IAttributeTypeDataType {
    private final Map<SWTControlForModification, Collection<ISWTControlModifiedListener>> swtModListeners = new HashMap<SWTControlForModification, Collection<ISWTControlModifiedListener>>();

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof IAttributeTypeDataType) {
                IAttributeTypeDataType dt = (IAttributeTypeDataType)obj;
                return this.getID().equals(dt.getID());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public void notifyAboutValueBeeingInUse(Object newValue) throws EXInvalidValue {
    }

    public void notifyAboutValueNotBeeingInUseAnymore(Object oldValue) throws EXInvalidValue {
    }

    public IAttributeTypeDataType.ISWTControlForModification createSWTControlForModifying(Composite parent, Collection<ISWTControlModifiedListener> modifiedListeners, IValueRange valueRange) {
        return this.createSWTControlForModifying(parent, (Collection)modifiedListeners, this.getDefaultValue(), valueRange);
    }

    public final SWTControlForModification createSWTControlForModifying(Composite parent, Collection<ISWTControlModifiedListener> modifiedListeners, Object initialValue, IValueRange valueRange) {
        if (!this.supportsValue(initialValue, valueRange)) {
            throw new ExInvalidDataType(initialValue.getClass().toString(), this.getDisplayName());
        }
        SWTControlForModification controlObject = this.createSWTControlForModifying_internal(parent, initialValue, valueRange);
        this.addSWTControlModifiedListeners(controlObject, modifiedListeners);
        return controlObject;
    }

    protected abstract SWTControlForModification createSWTControlForModifying_internal(Composite var1, Object var2, IValueRange var3);

    private void addSWTControlModifiedListeners(final SWTControlForModification swtControl, Collection<ISWTControlModifiedListener> modifiedListeners) throws ExInvalidDataType {
        ArrayList<ISWTControlModifiedListener> listeners = new ArrayList<ISWTControlModifiedListener>(modifiedListeners);
        this.swtModListeners.put(swtControl, listeners);
        swtControl.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractDataType.this.swtModListeners.remove(swtControl);
            }
        });
    }

    private void removeSWTModifiedListeners(SWTControlForModification swtControl) {
        this.swtModListeners.remove(swtControl);
    }

    protected final void informSWTModifyListeners(SWTControlForModification swtControl, Object newValue, Object additionalInfo) {
        assert (!swtControl.isDisposed()) : "Disposed SWTControlForModification are no longer contained in the swtModListeners map => no listeners will be informed";
        Collection<ISWTControlModifiedListener> listeners = this.swtModListeners.get(swtControl);
        if (listeners != null) {
            for (ISWTControlModifiedListener listener : listeners) {
                listener.modified(newValue, additionalInfo);
            }
        }
    }

    protected final void setModificationInProgress(SWTControlForModification swtControl) {
        assert (!swtControl.isDisposed()) : "Disposed SWTControlForModification are no longer contained in the swtModListeners map => no listeners will be informed";
        Collection<ISWTControlModifiedListener> listeners = this.swtModListeners.get(swtControl);
        if (listeners != null) {
            for (ISWTControlModifiedListener listener : listeners) {
                listener.setModificationInProgress(true);
            }
        }
    }

    protected final void unsetModificationInProgress(SWTControlForModification swtControl) {
        assert (!swtControl.isDisposed()) : "Disposed SWTControlForModification are no longer contained in the swtModListeners map => no listeners will be informed";
        Collection<ISWTControlModifiedListener> listeners = this.swtModListeners.get(swtControl);
        if (listeners != null) {
            for (ISWTControlModifiedListener listener : listeners) {
                listener.setModificationInProgress(false);
            }
        }
    }

    public int getSWTVerticalFillHint() {
        return -1;
    }

    public IAttributeFilter getFilter() {
        return new IAttributeFilter(){

            public boolean select(EOEncodableObject filterValue, IAttribute value) {
                return true;
            }

            public EOEncodableObject getStandardFilterValue() {
                return null;
            }
        };
    }

    public List<String> getValueAsStrings(Object value, IValueRange valueRange, Locale locale) {
        String string = this.getValueAsSingleLineString(value, valueRange, ", ", locale);
        if (string != null) {
            return Collections.singletonList(string);
        }
        return Collections.emptyList();
    }

    public Comparator<Object> getComparator(IValueRange valueRange) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return 0;
            }
        };
    }

    public final IFilterItem createFilterItem(IAttributeType attributeType, AbstractFilter filter, IValueRange vaueRange) {
        return this.createFilterItem(attributeType.getDisplayName(), filter, vaueRange);
    }

    public IFilterItem createFilterItem(String filterName, AbstractFilter filter, IValueRange vaueRange) {
        return null;
    }

    public DetailsElement getDetailsElement(IAttributeType attributeType, Object attributeValue, Locale locale, Shell shell, IWorkbenchPage workbenchPage) {
        return new DetailsElementSingle(String.valueOf(attributeType.getCockpitDataTypeID()) + "-" + attributeType.getHumanReadableID(), attributeType.getDisplayName(), new DetailsValueSingle(this.getValueAsSingleLineString(attributeValue, attributeType.getValueRange(), "", locale)));
    }

    public final class SWTControlForModification
    implements IAttributeTypeDataType.ISWTControlForModification {
        private final Control control;
        private final Runnable runnableOnDispose;
        private final Runnable runnableOnReset;
        private boolean isDisposed;

        public SWTControlForModification(Control control, Runnable runnableOnDispose) {
            this.control = control;
            this.runnableOnDispose = runnableOnDispose;
            this.runnableOnReset = null;
            this.isDisposed = false;
        }

        public SWTControlForModification(Control control, Runnable runnableOnDispose, Runnable runnableOnReset) {
            this.control = control;
            this.runnableOnDispose = runnableOnDispose;
            this.runnableOnReset = runnableOnReset;
            this.isDisposed = false;
        }

        public Control getControl() {
            return this.control;
        }

        public void dispose() {
            if (this.runnableOnDispose != null) {
                this.runnableOnDispose.run();
            }
            AbstractDataType.this.removeSWTModifiedListeners(this);
            this.isDisposed = true;
        }

        public boolean isDisposed() {
            return this.isDisposed;
        }

        public void reset() {
            if (this.runnableOnReset != null) {
                this.runnableOnReset.run();
            }
        }
    }
}

