/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.constructionelements;

import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public abstract class ConstructionElementTypeDescription
implements IConstructionElementTypeDescription {
    private static final ILogger LOGGER = Logger.getLogger(ConstructionElementTypeDescription.class);

    public static boolean isValidCategoryID(String category) {
        boolean isValid = "always unique".equals(category) ? true : ("preferred unique".equals(category) ? true : ("preferred not unique".equals(category) ? true : "never unique".equals(category)));
        return isValid;
    }

    public static String getCategoryNameOfCategory(String category) {
        String name = "always unique".equals(category) ? Messages.getString("ConstructionElementTypeDescription.alwaysunique") : ("preferred unique".equals(category) ? Messages.getString("ConstructionElementTypeDescription.preferredunqiue") : ("preferred not unique".equals(category) ? Messages.getString("ConstructionElementTypeDescription.preferrednotunique") : ("never unique".equals(category) ? Messages.getString("ConstructionElementTypeDescription.neverunique") : Messages.getString("ConstructionElementTypeDescription.unknowncategory"))));
        return name;
    }

    @Override
    public abstract String getConstructionElementTypeID();

    protected abstract String getConstructionElementTypeName_key();

    protected abstract String getConstructionElementTypeNameInPlural_key();

    protected String getDefaultIDPrefix_key() {
        return null;
    }

    protected abstract ResourceBundle getConstructionElementTypeBundle(Locale var1);

    @Override
    public final String getConstructionElementTypeName(Locale locale) {
        return this.getString(this.getConstructionElementTypeName_key(), locale);
    }

    @Override
    public final String getConstructionElementTypeNameInPlural(Locale locale) {
        return this.getString(this.getConstructionElementTypeNameInPlural_key(), locale);
    }

    @Override
    public final String getDefaultIDPrefix(Locale locale) {
        String key = this.getDefaultIDPrefix_key();
        String prefix = key != null ? this.getString(key, locale) : Messages.getString("UnknownUETypeIDPrefix", locale);
        return prefix;
    }

    private String getString(String key, Locale locale) {
        ResourceBundle bundle = this.getConstructionElementTypeBundle(locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    @Override
    public final URL getIconURL() {
        URL iconURL = null;
        try {
            Bundle bundle = this.getPlugin().getBundle();
            URL pluginURL = bundle.getEntry("/");
            iconURL = new URL(pluginURL, this.getIconPath());
        }
        catch (MalformedURLException e) {
            LOGGER.error("Malformed icon file path in Extension ", (Throwable)e);
        }
        return iconURL;
    }

    protected abstract String getIconPath();

    protected abstract Plugin getPlugin();

    @Override
    public abstract String getCategoryID();

    @Override
    public final String getCategoryName() {
        return ConstructionElementTypeDescription.getCategoryNameOfCategory(this.getCategoryID());
    }

    @Override
    public final boolean isOfCategoryNeverUnique() {
        return "never unique".equals(this.getCategoryID());
    }

    @Override
    public final boolean isOfCategoryAlwaysUnique() {
        return "always unique".equals(this.getCategoryID());
    }

    @Override
    public final boolean isOfCategoryPreferredUnique() {
        return "preferred unique".equals(this.getCategoryID());
    }

    @Override
    public final boolean isOfCategoryPreferredNotUnique() {
        return "preferred not unique".equals(this.getCategoryID());
    }

    @Override
    public abstract int getPriority();

    @Override
    public int getActiveOrPassiveConstructionElementType() {
        return -1;
    }
}

