/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.DelegateBasedModuleAction;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ModuleActionDelegate;
import com.arcway.cockpit.frame.client.lib.dataviews.messages.Messages;
import com.arcway.cockpit.frame.client.lib.dataviews.view.IDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.IDataViewLabelProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.JFaceViewerDataView;
import com.arcway.lib.java.EitherOr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;

public abstract class JFaceViewerDataViewProvider<ContentType>
implements IDataViewProvider<ContentType> {
    private final JFaceViewerDataView<ContentType> dataView;
    private final DelegateBasedModuleAction filterAction;

    public JFaceViewerDataViewProvider(JFaceViewerDataView<ContentType> dataView) {
        assert (dataView != null) : "dataView must not be null";
        this.dataView = dataView;
        this.filterAction = this.createFilterAction();
    }

    protected abstract IDataViewLabelProvider createLabelProvider();

    public final IAction getFilterAction() {
        return this.filterAction;
    }

    @Override
    public List<? extends IAction> getAdditionalToolbarActions() {
        return Collections.singletonList(this.filterAction);
    }

    @Override
    public List<EitherOr<IAction, IContributionItem>> getAdditionalViewMenuActions() {
        ArrayList<EitherOr<IAction, IContributionItem>> viewMenuActions = new ArrayList<EitherOr<IAction, IContributionItem>>();
        viewMenuActions.add((EitherOr<IAction, IContributionItem>)new EitherOr.Either((Object)this.filterAction));
        viewMenuActions.add((EitherOr<IAction, IContributionItem>)new EitherOr.Or((Object)new Separator("com.arcway.cockpit.contextmenu.filter.separator")));
        return viewMenuActions;
    }

    private DelegateBasedModuleAction createFilterAction() {
        ModuleActionDelegate filterActionDelegate = new ModuleActionDelegate(){
            boolean enablement = false;

            public void run(IAction action) {
                JFaceViewerDataViewProvider.this.dataView.callbackFilterActionSelected();
            }

            @Override
            protected boolean determineEnabledStatus(String newModel) {
                this.enablement = newModel != null;
                return this.enablement;
            }

            @Override
            protected <T> boolean determineEnabledStatus(IPropertyChanges<T> changes, Class<T> clazz) {
                return this.enablement;
            }

            @Override
            protected boolean determineEnabledStatus(ISelection selection) {
                return this.enablement;
            }
        };
        DelegateBasedModuleAction filterAction_ = new DelegateBasedModuleAction(filterActionDelegate, 2);
        filterAction_.setText(Messages.getString("AbstractDataView.FilterActionText"));
        filterAction_.setToolTipText(Messages.getString("AbstractDataView.FilterActionTooltip"));
        filterAction_.setImageDescriptor(FramePlugin.getImageDescriptor("dataview", "filter_tsk.gif"));
        filterAction_.setDisabledImageDescriptor(FramePlugin.getImageDescriptor("dataview", "filter_ps.gif"));
        filterAction_.setChecked(false);
        return filterAction_;
    }

    public abstract IOpenListener createOpenListener();

    public abstract List<IFilterItem> createFilterItems();

    public abstract List<IFilterItem> createProjectSpecificFilterItems(String var1);

    public abstract String getFilterDialogueTitle();

    public abstract String getFilterDialogueDescription();

    public abstract boolean isRetainingTreeStructuresWhenFiltering();
}

