/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards.newproject;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.permissionsadmin.PermissionsAdminDialog;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.CreateNewProjectAdvancedPage;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.CreateNewProjectWizardPage;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.datainterchange.ImportFailedException;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.resource.IStreamResource;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CreateNewProjectWizard
extends Wizard {
    private final IWorkbenchPage workbenchPage;
    private final ServerConnection server;
    private ProjectFileAccess projectTemplate;
    private String predefinedDescription;
    private String predefinedCopyright;
    private IStreamResource predefinedLogoFile;
    private CreateNewProjectWizardPage mainPage;
    private CreateNewProjectAdvancedPage advancedPage;

    public CreateNewProjectWizard(IWorkbenchPage workbenchPage, ServerConnection serverConnection) {
        assert (workbenchPage != null);
        this.workbenchPage = workbenchPage;
        this.server = serverConnection;
        this.setDefaultPageImageDescriptor(FramePlugin.getImageDescriptor("newproject_wiz_big.gif"));
    }

    public CreateNewProjectWizard(IWorkbenchPage workbenchPage, String predefinedDescription, String predefinedCopyright, IStreamResource predefinedLogo, ProjectFileAccess projectTemplate, ServerConnection serverConnection) {
        this(workbenchPage, serverConnection);
        this.projectTemplate = projectTemplate;
        this.predefinedDescription = predefinedDescription;
        this.predefinedCopyright = predefinedCopyright;
        this.predefinedLogoFile = predefinedLogo;
        this.setDefaultPageImageDescriptor(FramePlugin.getImageDescriptor("newproject_wiz_big.gif"));
    }

    public boolean performFinish() {
        boolean creationSuccessful;
        ProjectFileAccess choosenTemplateFile = this.advancedPage.getTemplateFile();
        if (choosenTemplateFile == null) {
            MessageDialog md = new MessageDialog(this.getShell(), Messages.getString("CreateNewProjectWizard.no_file_specified"), Icons.getArcWayLogo(), Messages.getString("CreateNewProjectWizard.no_file_message"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            md.setBlockOnOpen(true);
            if (md.open() == 1) {
                this.advancedPage.projectCreationCompleted();
                return false;
            }
        } else if (!choosenTemplateFile.isInProductiveState()) {
            MessageDialog md = new MessageDialog(this.getShell(), Messages.getString("CreateNewProjectWizard.file_not_found"), Icons.getArcWayLogo(), String.valueOf(Messages.getString("CreateNewProjectWizard.the_file")) + choosenTemplateFile.getProjectFileName() + Messages.getString("CreateNewProjectWizard.was_not_found"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            md.setBlockOnOpen(true);
            md.open();
            this.advancedPage.projectCreationCompleted();
            return false;
        }
        IFrameProjectAgent newProjectAgent = null;
        Throwable th = null;
        try {
            newProjectAgent = ProjectMgr.getProjectMgr().createNewProject(this.workbenchPage, this.server.getServerID(), UUIDGenerator.getUniqueID(), this.mainPage.getProjectName(), this.mainPage.getProjectDescription(), this.advancedPage.getCopyrightNotice(), this.advancedPage.getLanguage(), this.advancedPage.getLogoFileResource(), choosenTemplateFile);
        }
        catch (ServerNotAvailableException e) {
            th = e;
        }
        catch (EXServerException e) {
            th = e;
        }
        catch (LoginCanceledException e) {
        }
        catch (UnknownServerException e) {
            th = e;
        }
        catch (IOException e) {
            th = e;
        }
        catch (ImportFailedException e) {
            th = e;
        }
        catch (ExPrematureEndOfTransfer e) {
            th = e;
        }
        catch (ExProjectOpenAbortWithMessage e) {
            th = e;
        }
        this.advancedPage.projectCreationCompleted();
        if (th != null) {
            String descriptionOfConsequence = Messages.getString("CreateNewProjectWizard.CreateFailed.DescriptionOfConsequence");
            String genericMessage = Messages.getString("CreateNewProjectWizard.CreateFailed.genericMessage");
            String dialogTitle = Messages.getString("CreateNewProjectWizard.CreateFailed.dialogTitle");
            String dialogMessage = Messages.getString("CreateNewProjectWizard.CreateFailed.dialogMessage");
            this.handleCreateNewProjectThrowable(th, this.getShell(), this.mainPage.getProjectName(), descriptionOfConsequence, genericMessage, dialogTitle, dialogMessage);
            creationSuccessful = false;
        } else {
            boolean administrate = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(newProjectAgent.getServerID()).arePermissionsNeeded();
            if (administrate) {
                administrate = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("CreateNewProjectWizard.Administrate_Permissions..._1"), (String)Messages.getString("CreateNewProjectWizard.administrate_permissions__2"));
            }
            if (administrate) {
                PermissionsAdminDialog dialog = new PermissionsAdminDialog(newProjectAgent, this.workbenchPage);
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
            creationSuccessful = true;
        }
        return creationSuccessful;
    }

    public boolean performCancel() {
        this.advancedPage.projectCreationCompleted();
        return super.performCancel();
    }

    private void handleCreateNewProjectThrowable(Throwable th, Shell parentShell, String projectOrServerName, String humanReadableDescriptionOfConsequence, String exGenericMessage, String dialogTitle, String dialogMessage) {
        Exception userShownEx;
        Throwable thToHandle = (th instanceof ExPrematureEndOfTransfer || th instanceof ImportFailedException) && th.getCause() != null ? th.getCause() : th;
        if (thToHandle instanceof Exception) {
            userShownEx = (Exception)thToHandle;
        } else {
            userShownEx = new Exception(exGenericMessage);
            userShownEx.initCause(thToHandle);
        }
        ModificationProblem mProblem = new ModificationProblem(userShownEx, 2, humanReadableDescriptionOfConsequence);
        ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
        mProblems.add(mProblem);
        String mProblemDialogMessage = NLS.bind((String)dialogMessage, (Object)projectOrServerName);
        ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, mProblemDialogMessage, parentShell);
        mpDialog.open();
    }

    public void addPages() {
        this.setWindowTitle(Messages.getString("CreateNewProjectWizard.Create_new_project_3"));
        this.mainPage = new CreateNewProjectWizardPage(this.server, this.predefinedDescription);
        this.advancedPage = new CreateNewProjectAdvancedPage(this.workbenchPage, this.predefinedCopyright, this.predefinedLogoFile, this.projectTemplate);
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.advancedPage);
    }
}

