/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2;

import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.CycleWrapper;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelper;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelperWO;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.CyclicUERelationshipIdentifier;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.ui.IMemento;

public class UEView2TreeDataViewStateModelAccess
implements ITreeDataViewStateSerialisationHelper<Object> {
    private static final String TAG_OBJECTTYPE = "OBJECTTYPE";
    private static final String VALUE_OBJECTTYPE_MODELELEMENT = "ModelElement";
    private static final String VALUE_OBJECTTYPE_CYCLE = "Cycle";
    private static final String TAG_MODELELEMENT_UID = "UID";
    private static final String TAG_CYCLE_PARENTUID = "PARENT_UID";
    private static final String TAG_CYCLE_ENTRYPOINTUID = "ENTRYPOINT_UID";
    private static final String TAG_CYCLE_ELEMENTUIDS = "ELEMENT_UIDS";
    private static final String VALUE_UID_NULL = "null";
    private final IFrameUniqueElementManager uniqueElementManager;
    private final IUniqueElementRelationshipProvider containmentRelationshipProvider;

    public static final ITreeDataViewStateSerialisationHelper<Object> getInstance(IFrameUniqueElementManager uniqueElementManager, IUniqueElementRelationshipProvider containmentRelationshipProvider) {
        assert (uniqueElementManager != null);
        assert (containmentRelationshipProvider != null);
        return new UEView2TreeDataViewStateModelAccess(uniqueElementManager, containmentRelationshipProvider);
    }

    public static final ITreeDataViewStateSerialisationHelperWO<Object> getInstanceWO() {
        return new UEView2TreeDataViewStateModelAccess(null, null);
    }

    private UEView2TreeDataViewStateModelAccess(IFrameUniqueElementManager uniqueElementManager, IUniqueElementRelationshipProvider containmentRelationshipProvider) {
        this.uniqueElementManager = uniqueElementManager;
        this.containmentRelationshipProvider = containmentRelationshipProvider;
    }

    @Override
    public void storeDataItemReferenceIntoMemento(Object dataItem, IMemento memento) {
        if (dataItem instanceof IUniqueElement) {
            memento.putString(TAG_OBJECTTYPE, VALUE_OBJECTTYPE_MODELELEMENT);
            memento.putString(TAG_MODELELEMENT_UID, ((IUniqueElement)dataItem).getUID());
        } else if (dataItem instanceof CycleWrapper) {
            memento.putString(TAG_OBJECTTYPE, VALUE_OBJECTTYPE_CYCLE);
            IUniqueElement parentElement = ((CycleWrapper)dataItem).getParent();
            memento.putString(TAG_CYCLE_PARENTUID, parentElement != null ? parentElement.getUID() : VALUE_UID_NULL);
            IUniqueElement entryPointElement = ((CycleWrapper)dataItem).getCycleEntryPoint();
            memento.putString(TAG_CYCLE_ENTRYPOINTUID, entryPointElement != null ? entryPointElement.getUID() : VALUE_UID_NULL);
            CyclicUERelationshipIdentifier.Cycle cycle = ((CycleWrapper)dataItem).getCycle();
            StringBuffer commaSeparatedCycleElements = new StringBuffer();
            boolean first = true;
            for (String cycleElement : cycle.getAllElements()) {
                if (first) {
                    first = false;
                } else {
                    commaSeparatedCycleElements.append(",");
                }
                commaSeparatedCycleElements.append(cycleElement);
            }
            memento.putString(TAG_CYCLE_ELEMENTUIDS, commaSeparatedCycleElements.toString());
        }
    }

    @Override
    public void copyDataItemReferenceBetweenMementos(IMemento source, IMemento target) {
        String objectType = source.getString(TAG_OBJECTTYPE);
        if (objectType.equals(VALUE_OBJECTTYPE_MODELELEMENT)) {
            target.putString(TAG_OBJECTTYPE, VALUE_OBJECTTYPE_MODELELEMENT);
            String UID = source.getString(TAG_MODELELEMENT_UID);
            target.putString(TAG_MODELELEMENT_UID, UID);
        } else if (objectType.equals(VALUE_OBJECTTYPE_CYCLE)) {
            target.putString(TAG_OBJECTTYPE, VALUE_OBJECTTYPE_CYCLE);
            String parentUID = source.getString(TAG_CYCLE_PARENTUID);
            target.putString(TAG_CYCLE_PARENTUID, parentUID);
            String entryPointUID = source.getString(TAG_CYCLE_ENTRYPOINTUID);
            target.putString(TAG_CYCLE_ENTRYPOINTUID, entryPointUID);
            String elementUIDs = source.getString(TAG_CYCLE_ELEMENTUIDS);
            target.putString(TAG_CYCLE_ELEMENTUIDS, elementUIDs);
        }
    }

    @Override
    public Object readDataItemFromMemento(IMemento memento) {
        String objectType = memento.getString(TAG_OBJECTTYPE);
        if (objectType.equals(VALUE_OBJECTTYPE_MODELELEMENT)) {
            String uid = memento.getString(TAG_MODELELEMENT_UID);
            return this.uniqueElementManager.getUniqueElement(uid);
        }
        if (objectType.equals(VALUE_OBJECTTYPE_CYCLE)) {
            IUniqueElement parent = null;
            String parentUID = memento.getString(TAG_CYCLE_PARENTUID);
            if (!parentUID.equals(VALUE_UID_NULL) && (parent = this.uniqueElementManager.getUniqueElement(parentUID)) == null) {
                return null;
            }
            IUniqueElement entryPoint = null;
            String entryPointUID = memento.getString(TAG_CYCLE_ENTRYPOINTUID);
            if (!entryPointUID.equals(VALUE_UID_NULL) && (entryPoint = this.uniqueElementManager.getUniqueElement(entryPointUID)) == null) {
                return null;
            }
            String commaSeparatedElementUIDs = memento.getString(TAG_CYCLE_ELEMENTUIDS);
            HashSet<String> elementUIDs = new HashSet<String>(Arrays.asList(commaSeparatedElementUIDs.split(",")));
            CyclicUERelationshipIdentifier.Cycle cycle = this.containmentRelationshipProvider.getCycle(elementUIDs);
            if (cycle != null) {
                return new CycleWrapper(parent, entryPoint, cycle, this.uniqueElementManager.getFrameProjectAgent().getProjectUID());
            }
            return null;
        }
        assert (false);
        return null;
    }
}

