/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.project.RootEntry;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ModificationRootItem;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplate;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.stakeholders.RoleList;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderList;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.client.project.sequences.ISequencer;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import de.plans.psc.client.communication.ServerConnection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class ProjectViewSorter
extends ViewerSorter
implements Comparator<ICockpitProjectData> {
    private static final ProjectViewSorter instance = new ProjectViewSorter();

    public static ProjectViewSorter getSingleton() {
        return instance;
    }

    private ProjectViewSorter() {
    }

    public int category(Object element) {
        int category = 100;
        if (element instanceof IFrameProjectAgent) {
            category = 0;
        } else if (element instanceof ISection) {
            category = 20;
        } else if (element instanceof IPlan) {
            category = 10;
        } else if (element instanceof IUniqueElement) {
            category = 50;
        } else if (element instanceof UniqueElementMgr) {
            category = 70;
        } else if (element instanceof ServerConnection) {
            category = 80;
        } else if (element instanceof IAddedItem[]) {
            category = 90;
        } else if (element instanceof IModifiedItem[]) {
            category = 100;
        } else if (element instanceof IDeletedItem[]) {
            category = 110;
        } else if (element instanceof StakeholderList) {
            category = 120;
        } else if (element instanceof RoleList) {
            category = 130;
        } else if (element instanceof RootEntry) {
            category = 140;
        } else if (element instanceof IModifiedItem[]) {
            category = 150;
        } else if (element instanceof ModificationRootItem) {
            category = 160;
        } else if (element instanceof IReportTemplate) {
            category = 170;
        } else if (element instanceof com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate) {
            category = 169;
        } else if (element instanceof IReportTemplateFolder) {
            category = 180;
        }
        return category;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        ISection s2;
        ISection s1;
        if (e1 instanceof IFrameProjectAgent && e2 instanceof IFrameProjectAgent) {
            String name1 = ((IFrameProjectAgent)e1).getProjectName();
            String name2 = ((IFrameProjectAgent)e2).getProjectName();
            return name1.compareToIgnoreCase(name2);
        }
        if (e1 instanceof IAttributeOwner && e2 instanceof IAttributeOwner) {
            IAttributeOwner a1 = (IAttributeOwner)e1;
            IAttributeOwner a2 = (IAttributeOwner)e2;
            if (a1.getProjectUID().equals(a2.getProjectUID())) {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(a1.getProjectUID());
                if (a1.getTypeID().equals(a2.getTypeID())) {
                    IFrameDataManager dm1 = projectAgent.getDataManager(a1.getTypeID());
                    IFrameDataManager dm2 = projectAgent.getDataManager(a2.getTypeID());
                    if (dm1 != null && dm2 != null) {
                        IAttributeOwner parent1 = dm1.getParent(a1);
                        IAttributeOwner parent2 = dm2.getParent(a2);
                        if (parent1 != null && parent2 != null) {
                            IAttributeOwner commonParent = null;
                            IAttributeOwner child1 = null;
                            IAttributeOwner child2 = null;
                            if (parent1.equals(parent2)) {
                                commonParent = parent1;
                                child1 = a1;
                                child2 = a2;
                            } else {
                                HashMap<IAttributeOwner, IAttributeOwner> parent_child_map = new HashMap<IAttributeOwner, IAttributeOwner>();
                                IAttributeOwner child = a1;
                                IAttributeOwner parent = parent1;
                                while (parent != null && !(parent instanceof Project)) {
                                    if (a2.equals(parent)) {
                                        return 1;
                                    }
                                    parent_child_map.put(parent, child);
                                    child = parent;
                                    parent = dm1.getParent(parent);
                                }
                                child = a2;
                                parent = parent2;
                                while (parent != null && !(parent instanceof Project)) {
                                    if (a1.equals(parent)) {
                                        return -1;
                                    }
                                    if (parent_child_map.containsKey(parent)) {
                                        commonParent = parent;
                                        child1 = (IAttributeOwner)parent_child_map.get(parent);
                                        child2 = child;
                                        break;
                                    }
                                    child = parent;
                                    parent = dm2.getParent(parent);
                                }
                            }
                            if (commonParent != null) {
                                String typeOfChild2;
                                int sgn = this.compareCategory((ICockpitProjectData)child1, (ICockpitProjectData)child2);
                                if (sgn != 0) {
                                    return sgn;
                                }
                                String typeOfChild1 = child1.getTypeID();
                                sgn = typeOfChild1.compareTo(typeOfChild2 = child2.getTypeID());
                                if (sgn != 0) {
                                    assert (false) : "Ambigous parent types " + typeOfChild1 + " and " + typeOfChild2 + " for " + a1 + " and " + a2;
                                    return sgn;
                                }
                                ISequencer sequencer = projectAgent.getSequencerManager().getSequencer(commonParent, Collections.emptyList(), FrameDataTypes.getDataType(typeOfChild1));
                                Comparator<ICockpitProjectData> comparator = sequencer.getComparator();
                                int result = comparator.compare((ICockpitProjectData)child1, (ICockpitProjectData)child2);
                                if (result != 0) {
                                    return result;
                                }
                            } else assert (false) : "No common parent found for objects " + a1 + " and " + a2;
                        }
                    }
                }
            }
        }
        if (e1 instanceof ISection && e2 instanceof ISection) {
            s1 = (ISection)e1;
            s2 = (ISection)e2;
            return s1.getSectionName().compareToIgnoreCase(s2.getSectionName());
        }
        if (e1 instanceof IPlan && e2 instanceof IPlan) {
            IPlan p1 = (IPlan)e1;
            IPlan p2 = (IPlan)e2;
            return p1.getPlanName().compareToIgnoreCase(p2.getPlanName());
        }
        if (e1 instanceof ILocalModificationContainer && e2 instanceof ILocalModificationContainer) {
            ILocalModificationContainer i1 = (ILocalModificationContainer)e1;
            ILocalModificationContainer i2 = (ILocalModificationContainer)e2;
            return i1.getGeneralDescription().compareToIgnoreCase(i2.getGeneralDescription());
        }
        if (e1 instanceof ServerConnection && e2 instanceof ServerConnection) {
            s1 = (ServerConnection)e1;
            s2 = (ServerConnection)e2;
            return s1.getServerName().compareToIgnoreCase(s2.getServerName());
        }
        if (e1 instanceof IStakeholder && e2 instanceof IStakeholder) {
            s1 = (IStakeholder)e1;
            s2 = (IStakeholder)e2;
            return s1.getStakeholderName().compareToIgnoreCase(s2.getStakeholderName());
        }
        if (e1 instanceof IStakeholderRole && e2 instanceof IStakeholderRole) {
            IStakeholderRole r1 = (IStakeholderRole)e1;
            IStakeholderRole r2 = (IStakeholderRole)e2;
            return r1.getName().compareToIgnoreCase(r2.getName());
        }
        return super.compare(viewer, e1, e2);
    }

    @Override
    public int compare(ICockpitProjectData arg0, ICockpitProjectData arg1) {
        int sgn = this.compareCategory(arg0, arg1);
        return sgn == 0 ? this.compare(null, arg0, arg1) : sgn;
    }

    public int compareCategory(ICockpitProjectData arg0, ICockpitProjectData arg1) {
        int category1;
        int category0 = this.category(arg0);
        if (category0 < (category1 = this.category(arg1))) {
            return -1;
        }
        if (category0 > category1) {
            return 1;
        }
        return 0;
    }
}

