/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.lib.dataview;

import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import de.plans.lib.util.LongComparator;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.graphics.Image;

public class GeneralTreeDataViewProvider {
    public static final String COLUMN_ID_OBJECTTYPECATEGORY = "objecttypecategory";
    public static final String COLUMN_ID_CREATOR = "creator";
    public static final String COLUMN_ID_CREATIONDATE = "creationdate";
    public static final String COLUMN_ID_MODIFIER = "modifier";
    public static final String COLUMN_ID_MODIFICATIONDATE = "modificationdate";

    public static <ContentType> Collection<IColumnDescription> getColumnDescriptions(CockpitTreeDataViewProvider.IGeneralColumnProvider<ContentType> generalColumnProvider) {
        ArrayList<IColumnDescription> generalColumnDescriptions = new ArrayList<IColumnDescription>(4);
        if (generalColumnProvider.isCategoryColumnNeeded()) {
            generalColumnDescriptions.add(new ColumnDescription(COLUMN_ID_OBJECTTYPECATEGORY, Messages.getString("GeneralColumnProvider.ColumnName.ObjectTypeCategory"), 120, 2950, false, 1, 950, new GeneralColumnComparator<ContentType>(COLUMN_ID_OBJECTTYPECATEGORY, generalColumnProvider)));
        }
        generalColumnDescriptions.add(new ColumnDescription(COLUMN_ID_CREATOR, Messages.getString("GeneralColumnProvider.ColumnName.Creator"), 120, 3000, false, 1, 1000, new GeneralColumnComparator<ContentType>(COLUMN_ID_CREATOR, generalColumnProvider)));
        generalColumnDescriptions.add(new ColumnDescription(COLUMN_ID_CREATIONDATE, Messages.getString("GeneralColumnProvider.ColumnName.CreationDate"), 120, 3001, false, 1, 1001, new GeneralColumnComparator<ContentType>(COLUMN_ID_CREATIONDATE, generalColumnProvider)));
        generalColumnDescriptions.add(new ColumnDescription(COLUMN_ID_MODIFIER, Messages.getString("GeneralColumnProvider.ColumnName.LastModifier"), 120, 3002, false, 1, 1002, new GeneralColumnComparator<ContentType>(COLUMN_ID_MODIFIER, generalColumnProvider)));
        generalColumnDescriptions.add(new ColumnDescription(COLUMN_ID_MODIFICATIONDATE, Messages.getString("GeneralColumnProvider.ColumnName.DateOfLastModification"), 120, 3003, false, 1, 1003, new GeneralColumnComparator<ContentType>(COLUMN_ID_MODIFICATIONDATE, generalColumnProvider)));
        return generalColumnDescriptions;
    }

    public static boolean isGeneralColumn(String columnID) {
        return columnID.equals(COLUMN_ID_OBJECTTYPECATEGORY) || columnID.equals(COLUMN_ID_CREATOR) || columnID.equals(COLUMN_ID_CREATIONDATE) || columnID.equals(COLUMN_ID_MODIFIER) || columnID.equals(COLUMN_ID_MODIFICATIONDATE);
    }

    public static <ContentType> Image getColumnImage(ContentType element, String columnID, CockpitTreeDataViewProvider.IGeneralColumnProvider<ContentType> generalColumnProvider) {
        return null;
    }

    public static <ContentType> String getColumnText(ContentType element, String columnID, CockpitTreeDataViewProvider.IGeneralColumnProvider<ContentType> generalColumnProvider) {
        if (columnID.equals(COLUMN_ID_OBJECTTYPECATEGORY)) {
            ObjectTypeCategory category = generalColumnProvider.getCategory(element);
            return category != null ? category.getDisplayName() : "";
        }
        if (columnID.equals(COLUMN_ID_CREATOR)) {
            String author = generalColumnProvider.getAuthor(element);
            return author != null ? author : "";
        }
        if (columnID.equals(COLUMN_ID_CREATIONDATE)) {
            String creationDate = generalColumnProvider.getCreationDateStringRepresentation(element);
            return creationDate != null ? creationDate : "";
        }
        if (columnID.equals(COLUMN_ID_MODIFIER)) {
            String modifier = generalColumnProvider.getLastModifier(element);
            return modifier != null ? modifier : "";
        }
        if (columnID.equals(COLUMN_ID_MODIFICATIONDATE)) {
            String modificationDate = generalColumnProvider.getDateOfLastModificationStringRepresentation(element);
            return modificationDate != null ? modificationDate : "";
        }
        assert (false);
        return "";
    }

    private static class GeneralColumnComparator<ContentType>
    implements IDataViewColumnComparator {
        private final String columnID;
        private final CockpitTreeDataViewProvider.IGeneralColumnProvider<ContentType> generalColumnProvider;

        public GeneralColumnComparator(String columnID, CockpitTreeDataViewProvider.IGeneralColumnProvider<ContentType> generalColumnProvider) {
            this.columnID = columnID;
            this.generalColumnProvider = generalColumnProvider;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (this.columnID.equals(GeneralTreeDataViewProvider.COLUMN_ID_OBJECTTYPECATEGORY)) {
                ObjectTypeCategory category1 = this.generalColumnProvider.getCategory(o1);
                ObjectTypeCategory category2 = this.generalColumnProvider.getCategory(o2);
                int category1SortPosition = category1 != null ? category1.getSortPosition() : 1000;
                int category2SortPosition = category2 != null ? category2.getSortPosition() : 1000;
                return category1SortPosition - category2SortPosition;
            }
            if (this.columnID.equals(GeneralTreeDataViewProvider.COLUMN_ID_CREATOR)) {
                String author1 = this.generalColumnProvider.getAuthor(o1);
                String author2 = this.generalColumnProvider.getAuthor(o2);
                if (author1 == null) {
                    return author2 == null ? 0 : 1;
                }
                return author2 == null ? -1 : author1.compareToIgnoreCase(author2);
            }
            if (this.columnID.equals(GeneralTreeDataViewProvider.COLUMN_ID_CREATIONDATE)) {
                Long creationDate1 = this.generalColumnProvider.getCreationDate(o1);
                Long creationDate2 = this.generalColumnProvider.getCreationDate(o2);
                if (creationDate1 == null) {
                    return creationDate2 == null ? 0 : 1;
                }
                return creationDate2 == null ? -1 : LongComparator.getDefault().compare((Object)creationDate1, (Object)creationDate2);
            }
            if (this.columnID.equals(GeneralTreeDataViewProvider.COLUMN_ID_MODIFIER)) {
                String modifier1 = this.generalColumnProvider.getLastModifier(o1);
                String modifier2 = this.generalColumnProvider.getLastModifier(o2);
                if (modifier1 == null) {
                    return modifier2 == null ? 0 : 1;
                }
                return modifier2 == null ? -1 : modifier1.compareToIgnoreCase(modifier2);
            }
            if (this.columnID.equals(GeneralTreeDataViewProvider.COLUMN_ID_MODIFICATIONDATE)) {
                Long modificationDate1 = this.generalColumnProvider.getDateOfLastModification(o1);
                Long modificationDate2 = this.generalColumnProvider.getDateOfLastModification(o2);
                if (modificationDate1 == null) {
                    return modificationDate2 == null ? 0 : 1;
                }
                return modificationDate2 == null ? -1 : LongComparator.getDefault().compare((Object)modificationDate1, (Object)modificationDate2);
            }
            assert (false);
            return 0;
        }
    }
}

