/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.element;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValue;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.lib.eclipse.transfer.dnd.IDragSourceListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;

public class DetailsElementTitle
extends DetailsElement {
    private final DetailsValue detailsValue;
    private IDetailsResourceProvider currentRessourceProvider;
    private Composite detailsLine;
    private Composite titleAndIconWidget;
    private Label iconWidget;
    private StyledText titleWidget;
    private StyledText whitespaceWidget;
    private IDragSourceListener dragListener;

    public DetailsElementTitle(String id, DetailsValueTitle detailsValue) {
        super(id);
        this.detailsValue = detailsValue;
    }

    public Control createWidget(Composite parent, IWorkbenchPartSite site, IDetailsResourceProvider resourceProvider) {
        this.detailsLine = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.detailsLine.setLayout((Layout)layout);
        this.titleAndIconWidget = new Composite(this.detailsLine, 0);
        GridData gridData = new GridData(4, 1, true, false);
        this.titleAndIconWidget.setLayoutData((Object)gridData);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        this.titleAndIconWidget.setLayout((Layout)layout);
        this.iconWidget = new Label(this.titleAndIconWidget, 0);
        gridData = new GridData(1, 1, false, false);
        gridData.verticalIndent = 0;
        this.iconWidget.setLayoutData((Object)gridData);
        if (this.detailsValue.getParameter() != null && this.detailsValue.getParameter() instanceof IDragSourceListener) {
            this.dragListener = (IDragSourceListener)this.detailsValue.getParameter();
        }
        if (this.dragListener != null) {
            DragSource dragSource = new DragSource((Control)this.iconWidget, this.dragListener.getSupportedOperations());
            dragSource.addDragListener((DragSourceListener)this.dragListener);
            this.dragListener.setSWTDragAgent(dragSource);
        }
        this.titleWidget = new StyledText(this.titleAndIconWidget, 72);
        this.titleWidget.setFont(resourceProvider.getTitleFont());
        this.titleWidget.setForeground(resourceProvider.getColour(4));
        gridData = new GridData(4, 1, true, false);
        this.titleWidget.setLayoutData((Object)gridData);
        this.whitespaceWidget = new StyledText(this.detailsLine, 8);
        this.whitespaceWidget.setFont(resourceProvider.getLabelFont());
        gridData = new GridData(4, 1, true, false);
        this.whitespaceWidget.setLayoutData((Object)gridData);
        return this.detailsLine;
    }

    public void fillWidget(IDetailsResourceProvider resourceProvider) {
        this.currentRessourceProvider = resourceProvider;
        String value = this.detailsValue.getDisplayText();
        Color backgroundColor = resourceProvider.getColour(this.detailsValue.getBackgroundType());
        if (this.detailsValue.getIcon() != null) {
            this.iconWidget.setImage(this.detailsValue.getIcon());
            ((GridLayout)this.titleAndIconWidget.getLayout()).horizontalSpacing = 5;
        } else {
            this.iconWidget.setImage(null);
            ((GridLayout)this.titleAndIconWidget.getLayout()).horizontalSpacing = 0;
        }
        if (value == null || value.equals("")) {
            value = "-";
        }
        this.titleWidget.setText(value);
        StyleRange styleRange = new StyleRange();
        styleRange.fontStyle = 1;
        styleRange.start = 0;
        styleRange.length = value.length();
        this.titleWidget.setStyleRange(styleRange);
        this.detailsLine.setBackground(backgroundColor);
        this.titleAndIconWidget.setBackground(backgroundColor);
        this.iconWidget.setBackground(backgroundColor);
        this.titleWidget.setBackground(backgroundColor);
        this.whitespaceWidget.setBackground(backgroundColor);
    }

    public int getMinimumWidth() {
        return 0;
    }

    public void setHighlighted(boolean highlighted) {
        if (this.detailsValue != null) {
            Color background = highlighted ? this.currentRessourceProvider.getColour(101) : this.currentRessourceProvider.getColour(100);
            this.detailsLine.setBackground(background);
            this.titleAndIconWidget.setBackground(background);
            this.iconWidget.setBackground(background);
            this.titleWidget.setBackground(background);
            this.whitespaceWidget.setBackground(background);
        }
    }

    public boolean showsEqualValues(DetailsElement detailsElement) {
        if (!(detailsElement instanceof DetailsElementTitle)) {
            return false;
        }
        DetailsElementTitle elementToCompare = (DetailsElementTitle)detailsElement;
        if (this.detailsValue == null || elementToCompare.detailsValue == null) {
            return false;
        }
        return this.detailsValue.getDisplayText().equals(elementToCompare.detailsValue.getDisplayText());
    }
}

