/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.AbstractPropertyGeneralWithCategorySelection;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyGeneralPlan
extends AbstractPropertyGeneralWithCategorySelection {
    private static final ILogger logger = Logger.getLogger(PropertyGeneralPlan.class);
    private IPlan plan;
    private AttributeTypesComposite attributeTypesComposite;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;
    private Combo categoryCombo;
    private Collection<IModificationProblem> initialCategoryModificationProblems;

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IPlan;
        }
        return false;
    }

    @Override
    public IModificationProblem init_internal(ICockpitProjectData element, boolean forCreation) {
        this.plan = (IPlan)element;
        return null;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyGeneral.General_1");
    }

    @Override
    public Image getPropertyImage() {
        return FrameDataTypes.getDataType("com.arcway.cockpit.plan").getIcon();
    }

    @Override
    public Composite getPropertyPage_internal(Composite parent) {
        IPropertiesDialog dialog = this.getDialog();
        dialog.setTitle(this.plan.getPlanName(), this);
        dialog.setMessage(Messages.getString("PropertyGeneral.Shows_all_general_properties_of_this__2"), 0, this);
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        base.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(base, 256);
        GridDataFactory.fillDefaults().align(4, 2).grab(false, false).applyTo((Control)label);
        label.setText(String.valueOf(ObjectTypeCategoryLabels.LABEL_CATEGORY) + ":");
        this.categoryCombo = new Combo(base, 12);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this.categoryCombo);
        LineSeparator line = new LineSeparator(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)line);
        Label space = new Label(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)space);
        IWorkbenchHelpSystem helpSystem = dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        IAttributeTypesProvider planAttributeTypeProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.plan");
        attributeTypes.add(planAttributeTypeProv.getAttributeType(PlanAttributeTypeProvider.ATTRID_NAME));
        attributeTypes.add(planAttributeTypeProv.getAttributeType(PlanAttributeTypeProvider.ATTRID_DESCRIPTION));
        this.attributeTypesComposite = new AttributeTypesComposite((IAttributeOwner)this.plan, base, attributeTypes, false, dialog, this);
        this.attributeTypesComposite.create();
        if (this.plan instanceof IPlanRW) {
            IPlanRW rw = (IPlanRW)this.plan;
            this.initialCategoryModificationProblems = rw.checkObjectTypeCategoryModificationPermission();
        }
        return base;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.isCategoryChanged() || this.attributeTypesComposite.isModified();
    }

    public Collection<IModificationProblem> requestCommit() {
        ArrayList<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
        if (this.hasChanges() && this.plan instanceof IPlanRW) {
            this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            IPlanRW rw = (IPlanRW)this.plan;
            if (this.attributeTypesComposite.isModified()) {
                this.newAttributes = this.attributeTypesComposite.getNewAttributes();
                for (IAttribute attribute : this.newAttributes) {
                    rw.requestAttributeModificationPermission(attribute, this.transactionController);
                }
            }
            if (this.isCategoryChanged()) {
                rw.requestObjectTypeCategoryModificationPermission(this.transactionController);
            }
            modProblems.addAll(this.transactionController.execute());
        }
        return modProblems;
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.transactionController != null) {
            this.transactionController.rollback();
            this.transactionController = null;
            this.newAttributes = null;
        }
    }

    @Override
    public void commitPropertyChanges1() {
        if (this.plan instanceof IPlanRW) {
            IPlanRW rw = (IPlanRW)this.plan;
            if (this.transactionController != null) {
                if (this.newAttributes != null) {
                    for (IAttribute attribute : this.newAttributes) {
                        try {
                            rw.setAttribute(attribute);
                        }
                        catch (EXNoPermission e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                        catch (EXNoLock e) {
                            logger.error("could not execute", (Throwable)e);
                        }
                    }
                }
                if (this.isCategoryChanged()) {
                    try {
                        rw.setCategoryID(this.getSelectedCategoryID());
                    }
                    catch (EXNoPermission e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (EXNoLock e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                }
            }
        }
        this.newAttributes = null;
        this.transactionController = null;
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        if (this.attributeTypesComposite != null) {
            this.attributeTypesComposite.dispose();
        }
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        if (this.attributeTypesComposite != null) {
            problems.addAll(this.attributeTypesComposite.getModificationProblems(true));
        }
        if (this.initialCategoryModificationProblems != null) {
            problems.addAll(this.initialCategoryModificationProblems);
        }
        return problems;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }

    @Override
    protected Combo getCategoryCombo() {
        return this.categoryCombo;
    }

    @Override
    protected ObjectTypeCategoryID getCategoryIDFromAttributeOwner() {
        if (this.plan != null) {
            return this.plan.getCategoryID();
        }
        return null;
    }

    @Override
    protected boolean hasCategoryChangePermission() {
        if (this.initialCategoryModificationProblems != null) {
            return this.initialCategoryModificationProblems.isEmpty();
        }
        return false;
    }
}

